/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractValuePresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.StringPropertySourceParser;
import org.eclipse.swt.widgets.Composite;

public class StringPresenter
extends AbstractValuePresenter<String> {
    private final IPropertySourceParser<String> m_parser = new StringPropertySourceParser();

    public StringPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, null);
    }

    public IPropertySourceParser<String> getParser() {
        return this.m_parser;
    }

    @Override
    protected String formatDisplayValue(String value) throws CoreException {
        return value;
    }

    @Override
    protected String parseSourceInput(String input) throws CoreException {
        return (String)this.getParser().parseSourceValue(input, this.getMethod().peekMethod(), this.getMethod().getSuperTypeHierarchy());
    }

    @Override
    protected String parseDisplayInput(String input) throws CoreException {
        if (StringUtility.isNullOrEmpty((String)input)) {
            return null;
        }
        return input;
    }

    @Override
    protected synchronized void storeValue(String value) throws CoreException {
        try {
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(this.getMethod(), this.getParser());
            updateOp.setValue((Object)value);
            OperationJob job = new OperationJob(new IOperation[]{updateOp});
            job.setDebug(true);
            job.schedule();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not parse default value of method '" + this.getMethod().getMethodName() + "' in type '" + this.getMethod().getType().getFullyQualifiedName() + "'.", e);
        }
    }

    @Override
    protected int getTextAlignment() {
        return 16384;
    }
}

