/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.util.LinkedList;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.TechnologyExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.extensions.technology.ITechnologyListener;
import org.eclipse.scout.sdk.ui.internal.extensions.technology.Technology;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TechnologyPresenter
extends AbstractPresenter {
    private final IScoutBundle m_scoutProject;
    private final LinkedList<P_TechnologyUiModel> m_techModels;

    public TechnologyPresenter(PropertyViewFormToolkit toolkit, Composite parent, IScoutBundle scoutProject) {
        super(toolkit, parent);
        this.m_scoutProject = scoutProject;
        this.m_techModels = new LinkedList();
        GridLayout layout = new GridLayout(1, false);
        layout.marginTop = 4;
        layout.marginBottom = 4;
        this.getContainer().setLayout((Layout)layout);
    }

    public void loadModel() {
        TreeSet<Technology> technologies = new TreeSet<Technology>();
        Technology[] technologyArray = TechnologyExtensionPoint.getTechnologyExtensions();
        int n = technologyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Technology t = technologyArray[n2];
            technologies.add(t);
            ++n2;
        }
        this.m_techModels.clear();
        for (Technology t : technologies) {
            try {
                P_TechnologyUiModel uiModel = new P_TechnologyUiModel();
                uiModel.technology = t;
                uiModel.active = uiModel.technology.isActive(this.m_scoutProject);
                if (uiModel.active) {
                    uiModel.selection = uiModel.technology.getSelection(this.m_scoutProject);
                }
                this.m_techModels.add(uiModel);
            }
            catch (Exception tt) {
                ScoutSdkUi.logError("unable to load model for technology " + t.getId(), tt);
            }
        }
    }

    public void createContent() {
        String cat = null;
        for (P_TechnologyUiModel t : this.m_techModels) {
            final Technology tec = t.technology;
            if (!t.active) continue;
            if (cat == null || !cat.equals(tec.getCategory())) {
                cat = tec.getCategory();
                this.createCategoryHeading(this.getContainer(), cat);
            }
            final Button checkbox = this.getToolkit().createButton(this.getContainer(), tec.getName(), 32);
            TriState initVal = t.selection;
            TechnologyPresenter.setCheckBoxVal(checkbox, initVal);
            checkbox.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    checkbox.setEnabled(false);
                    boolean saved = false;
                    try {
                        saved = tec.setSelection(TechnologyPresenter.this.m_scoutProject, !checkbox.getSelection());
                    }
                    catch (CoreException e1) {
                        ScoutSdkUi.logError("Unable to change technology selection.", e1);
                    }
                    if (!saved) {
                        checkbox.setEnabled(true);
                    }
                }
            });
            tec.addSelectionChangedListener(new ITechnologyListener(){

                @Override
                public void selectionChangeCompleted(boolean newSelection) {
                    TechnologyPresenter.setCheckBoxVal(checkbox, TriState.parseTriState((Object)newSelection));
                    if (!checkbox.isDisposed()) {
                        checkbox.setEnabled(true);
                    }
                }
            });
        }
    }

    private Composite createCategoryHeading(Composite parent, String label) {
        Composite body = this.getToolkit().createComposite(parent);
        GridLayout bodyLayout = new GridLayout(2, false);
        bodyLayout.horizontalSpacing = 4;
        bodyLayout.marginHeight = 0;
        bodyLayout.marginWidth = 0;
        bodyLayout.verticalSpacing = 0;
        body.setLayout((Layout)bodyLayout);
        GridData bodyLayoutData = new GridData(768);
        body.setLayoutData((Object)bodyLayoutData);
        Label l = new Label(body, 0);
        l.setText(label);
        Label line = new Label(body, 266);
        line.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return body;
    }

    private static void setCheckBoxVal(Button checkbox, TriState val) {
        if (checkbox == null || checkbox.isDisposed()) {
            return;
        }
        if (val == TriState.FALSE) {
            checkbox.setSelection(false);
            checkbox.setGrayed(false);
        } else {
            checkbox.setSelection(true);
            checkbox.setGrayed(val == TriState.UNDEFINED);
        }
    }

    private static class P_TechnologyUiModel {
        private Technology technology;
        private TriState selection;
        private boolean active;

        private P_TechnologyUiModel() {
        }
    }
}

