/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jdt.compile.ScoutSeverityManager;
import org.eclipse.scout.sdk.ui.internal.view.outline.job.RefreshOutlineLabelsJob;
import org.eclipse.scout.sdk.ui.internal.view.outline.job.RefreshOutlineSubTreeJob;
import org.eclipse.scout.sdk.ui.view.outline.IDirtyManageable;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.IScoutSeverityListener;

public class DirtyUpdateManager {
    private final IDirtyManageable m_view;
    private final LinkedList<IPage> m_structureRoots = new LinkedList();
    private final Job m_currentRefreshSubTreeProcess;
    private Job m_currentRefreshLabelsProcess;

    public DirtyUpdateManager(IDirtyManageable view) {
        this.m_view = view;
        this.m_currentRefreshSubTreeProcess = new RefreshOutlineSubTreeJob(this.m_view, this, Texts.get((String)"Refreshing"));
        ScoutSeverityManager.getInstance().addQualityManagerListener(new IScoutSeverityListener(){

            public void severityChanged(IResource r) {
                DirtyUpdateManager.this.enqueueLabelsJob();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStructureDirty(IPage page) {
        LinkedList<IPage> linkedList = this.m_structureRoots;
        synchronized (linkedList) {
            IPage p = page;
            while (p != null) {
                if (this.m_structureRoots.contains(p)) {
                    return;
                }
                p = p.getParent();
            }
            Iterator it = this.m_structureRoots.iterator();
            block4: while (it.hasNext()) {
                p = (IPage)it.next();
                while (p != null) {
                    if (p == page) {
                        it.remove();
                        continue block4;
                    }
                    p = p.getParent();
                }
            }
            this.m_structureRoots.add(page);
        }
        this.enqueueStructureJob();
    }

    private synchronized void enqueueStructureJob() {
        this.m_currentRefreshSubTreeProcess.cancel();
        this.m_currentRefreshSubTreeProcess.schedule(200L);
    }

    private synchronized void enqueueLabelsJob() {
        if (this.m_currentRefreshLabelsProcess != null) {
            this.m_currentRefreshLabelsProcess.cancel();
            this.m_currentRefreshLabelsProcess = null;
        }
        this.m_currentRefreshLabelsProcess = new RefreshOutlineLabelsJob(this.m_view, Texts.get((String)"Refreshing"));
        this.m_currentRefreshLabelsProcess.schedule(200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPage[] fetchDirtyStructurePages() {
        LinkedList<IPage> linkedList = this.m_structureRoots;
        synchronized (linkedList) {
            if (this.m_structureRoots.size() > 0) {
                IPage[] pages = this.m_structureRoots.toArray(new IPage[this.m_structureRoots.size()]);
                this.m_structureRoots.clear();
                return pages;
            }
            return new IPage[0];
        }
    }
}

