/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.dialog.ProductSelectionDialog;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.PageFilterPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.ProjectVersionPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.TechnologyPresenter;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.Section;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.AbstractSinglePageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.ProductLaunchPresenter;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IMemento;
import org.osgi.service.prefs.BackingStoreException;

public class ScoutProjectPropertyPart
extends AbstractSinglePageSectionBasedViewPart {
    private static final String SECTION_ID_FILTER = "section.filter";
    private static final String SECTION_ID_PRODUCT_LAUNCHER = "section.productLauncher";
    private static final String SECTION_ID_VERSION = "section.version";
    private static final String SECTION_ID_TECHNOLOGY = "section.technology";
    private static final String PROJECT_PROD_LAUNCHERS = "pref_scout_project_prod_launcher";
    private final ArrayList<ProductLaunchPresenter> m_launchPresenters = new ArrayList();

    @Override
    protected void createSections() {
        ISection filterSection = this.createSection(SECTION_ID_FILTER, Texts.get((String)"Filter"));
        PageFilterPresenter filterPresenter = new PageFilterPresenter(this.getFormToolkit(), filterSection.getSectionClient(), this.getPage());
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        filterPresenter.getContainer().setLayoutData((Object)layoutData);
        filterSection.setExpanded(this.wasSectionExpanded(SECTION_ID_FILTER, false));
        if (!this.getScoutProject().isBinary()) {
            ISection versionSection = this.createSection(SECTION_ID_VERSION, Texts.get((String)"ProjectVersion"));
            ProjectVersionPresenter versionPresenter = new ProjectVersionPresenter(this.getFormToolkit(), versionSection.getSectionClient(), this.getScoutProject());
            GridData versionLayoutData = new GridData(768);
            versionLayoutData.widthHint = 200;
            versionPresenter.getContainer().setLayoutData((Object)versionLayoutData);
            versionSection.setExpanded(this.wasSectionExpanded(SECTION_ID_VERSION, true));
        }
        Section linkSection = (Section)this.createSection(SECTION_ID_PRODUCT_LAUNCHER, Texts.get((String)"ProductLauncher"));
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)linkSection.getUiSection());
        Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        Action action = new Action(){

            public void run() {
                ArrayList<IFile> productFiles = new ArrayList<IFile>();
                for (ProductLaunchPresenter p : ScoutProjectPropertyPart.this.m_launchPresenters) {
                    productFiles.add(p.getProductFile());
                }
                ProductSelectionDialog dialog = new ProductSelectionDialog(ScoutProjectPropertyPart.this.getForm().getShell(), ScoutProjectPropertyPart.this.getScoutProject());
                dialog.setCheckedProductFiles(productFiles.toArray(new IFile[productFiles.size()]));
                if (dialog.open() == 0) {
                    ScoutProjectPropertyPart.this.refreshProductLaunchPresenters(dialog.getCheckedProductFiles());
                }
            }
        };
        action.setImageDescriptor(ScoutSdkUi.getImageDescriptor("usereditor.gif"));
        action.setToolTipText(Texts.get((String)"EditContent"));
        action.setText(Texts.get((String)"EditContent"));
        toolBarManager.add((IAction)action);
        toolBarManager.update(true);
        linkSection.getUiSection().setTextClient((Control)toolbar);
        linkSection.setExpanded(this.wasSectionExpanded(SECTION_ID_PRODUCT_LAUNCHER, true));
        if (!this.getScoutProject().isBinary()) {
            Section techSection = (Section)this.createSection(SECTION_ID_TECHNOLOGY, Texts.get((String)"Technologies"));
            final TechnologyPresenter techPresenter = new TechnologyPresenter(this.getFormToolkit(), techSection.getSectionClient(), this.getScoutProject());
            GridData techLayoutData = new GridData(768);
            techLayoutData.widthHint = 200;
            techPresenter.getContainer().setLayoutData((Object)techLayoutData);
            final ProgressIndicator indicator = new ProgressIndicator(techPresenter.getContainer(), 65538);
            indicator.beginAnimatedTask();
            GridData indicatorData = new GridData(768);
            indicatorData.horizontalSpan = 2;
            indicatorData.heightHint = 5;
            indicator.setLayoutData((Object)indicatorData);
            Job j = new Job("load technologies..."){

                protected IStatus run(IProgressMonitor monitor) {
                    if (techPresenter != null && !techPresenter.isDisposed()) {
                        try {
                            techPresenter.loadModel();
                        }
                        catch (Throwable throwable) {
                            if (techPresenter.getContainer() != null && !techPresenter.getContainer().isDisposed()) {
                                techPresenter.getContainer().getDisplay().asyncExec(new Runnable(techPresenter, indicator){
                                    private final /* synthetic */ TechnologyPresenter val$techPresenter;
                                    private final /* synthetic */ ProgressIndicator val$indicator;
                                    {
                                        this.val$techPresenter = technologyPresenter;
                                        this.val$indicator = progressIndicator;
                                    }

                                    @Override
                                    public void run() {
                                        if (this.val$techPresenter != null && !this.val$techPresenter.isDisposed()) {
                                            this.val$techPresenter.createContent();
                                            this.val$indicator.dispose();
                                            ScoutProjectPropertyPart.this.getForm().layout(true, true);
                                            ScoutProjectPropertyPart.this.getForm().updateToolBar();
                                            ScoutProjectPropertyPart.this.getForm().reflow(true);
                                        }
                                    }
                                });
                            }
                            throw throwable;
                        }
                        if (techPresenter.getContainer() != null && !techPresenter.getContainer().isDisposed()) {
                            techPresenter.getContainer().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            j.setSystem(true);
            j.schedule();
            techSection.setExpanded(this.wasSectionExpanded(SECTION_ID_TECHNOLOGY, true));
        }
    }

    protected IScoutBundle getScoutProject() {
        return this.getPage().getScoutBundle();
    }

    private void refreshProductLaunchPresenters(IFile[] productFiles) {
        ISection section = this.getSection(SECTION_ID_PRODUCT_LAUNCHER);
        for (ProductLaunchPresenter p : this.m_launchPresenters) {
            p.dispose();
        }
        this.m_launchPresenters.clear();
        Arrays.sort(productFiles, 0, productFiles.length, new Comparator<IFile>(){

            @Override
            public int compare(IFile o1, IFile o2) {
                boolean o2IsServer;
                String serverKeyWord = "server";
                boolean o1IsServer = o1.getName().contains(serverKeyWord);
                if (o1IsServer == (o2IsServer = o2.getName().contains(serverKeyWord))) {
                    return o1.getName().compareTo(o2.getName());
                }
                return Boolean.valueOf(o2IsServer).compareTo(o1IsServer);
            }
        });
        IFile[] iFileArray = productFiles;
        int n = productFiles.length;
        int n2 = 0;
        while (n2 < n) {
            IFile prodFile = iFileArray[n2];
            try {
                ProductLaunchPresenter presenter = new ProductLaunchPresenter(this.getFormToolkit(), section.getSectionClient(), prodFile);
                GridData layoutData = new GridData(768);
                layoutData.widthHint = 200;
                presenter.getContainer().setLayoutData((Object)layoutData);
                this.m_launchPresenters.add(presenter);
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("Unable to create product file presenter for file '" + prodFile.getFullPath().toOSString() + "'.", e);
            }
            ++n2;
        }
        this.getForm().layout(true, true);
        this.getForm().reflow(true);
    }

    @Override
    public void init(IMemento memento) {
        this.refreshProductLaunchPresenters(ScoutProjectPropertyPart.getProjectProductLaunchers(this.getScoutProject().getSymbolicName()));
    }

    @Override
    public void save(IMemento memento) {
        IFile[] files = new IFile[this.m_launchPresenters.size()];
        int i = 0;
        while (i < files.length) {
            files[i] = this.m_launchPresenters.get(i).getProductFile();
            ++i;
        }
        ScoutProjectPropertyPart.saveProjectProductLaunchers(this.getScoutProject().getSymbolicName(), files);
    }

    public static void saveProjectProductLaunchers(String projectName, IFile[] productFiles) {
        StringBuilder mementoString = new StringBuilder();
        int i = 0;
        while (i < productFiles.length) {
            mementoString.append(productFiles[i].getFullPath());
            if (i < productFiles.length - 1) {
                mementoString.append(",");
            }
            ++i;
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(ScoutSdkUi.getDefault().getBundle().getSymbolicName());
        node.put("pref_scout_project_prod_launcher_" + projectName, mementoString.toString());
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ScoutSdkUi.logError("unable to persist project product launcher settings.", e);
        }
    }

    public static void addProjectProductLauncher(String projectName, IFile productFile) {
        IFile[] existingLaunchers = ScoutProjectPropertyPart.getProjectProductLaunchers(projectName);
        IPath path = productFile.getFullPath();
        IFile[] iFileArray = existingLaunchers;
        int n = existingLaunchers.length;
        int n2 = 0;
        while (n2 < n) {
            IFile existing = iFileArray[n2];
            if (existing.getFullPath().equals((Object)path)) {
                return;
            }
            ++n2;
        }
        IFile[] newProdFiles = new IFile[existingLaunchers.length + 1];
        System.arraycopy(existingLaunchers, 0, newProdFiles, 0, existingLaunchers.length);
        newProdFiles[existingLaunchers.length] = productFile;
        ScoutProjectPropertyPart.saveProjectProductLaunchers(projectName, newProdFiles);
    }

    public static IFile[] getProjectProductLaunchers(String projectName) {
        String[] productLocations;
        ArrayList<IFile> products = new ArrayList<IFile>();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(ScoutSdkUi.getDefault().getBundle().getSymbolicName());
        String mementoProducts = node.get("pref_scout_project_prod_launcher_" + projectName, "");
        if (!StringUtility.isNullOrEmpty((String)mementoProducts) && (productLocations = mementoProducts.split(",\\s*")) != null && productLocations.length > 0) {
            String[] stringArray = productLocations;
            int n = productLocations.length;
            int n2 = 0;
            while (n2 < n) {
                IFile productFile;
                String productPath = stringArray[n2];
                if (!StringUtility.isNullOrEmpty((String)productPath) && (productFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(productPath))) != null && productFile.exists()) {
                    products.add(productFile);
                }
                ++n2;
            }
        }
        return products.toArray(new IFile[products.size()]);
    }
}

