/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.beanproperty;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IBeanPropertyNewOperation;
import org.eclipse.scout.sdk.operation.SharedContextBeanPropertyNewOperation;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.beanproperty.BeanPropertyNewWizardPage;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.MethodFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class SharedContextBeanPropertyNewWizard
extends AbstractWorkspaceWizard {
    public SharedContextBeanPropertyNewWizard(IType serverSessionType, IType clientSessionType) {
        this.setWindowTitle(Texts.get((String)"NewSharedContextProperty"));
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{serverSessionType.getJavaProject()});
        BeanPropertyNewWizardPage beanPropertyWizardPage = new BeanPropertyNewWizardPage(searchScope, serverSessionType);
        SharedContextBeanPropertyNewOperation op = new SharedContextBeanPropertyNewOperation(serverSessionType, clientSessionType);
        beanPropertyWizardPage.setOperation((IBeanPropertyNewOperation)op);
        HashSet<String> notAllowedMethodNames = new HashSet<String>();
        this.collectMethodNames(serverSessionType, notAllowedMethodNames);
        if (clientSessionType != null) {
            this.collectMethodNames(clientSessionType, notAllowedMethodNames);
        }
        beanPropertyWizardPage.setNotAllowedNames(notAllowedMethodNames);
        this.addPage((IWizardPage)beanPropertyWizardPage);
    }

    protected void collectMethodNames(IType type, Set<String> collector) {
        IMethodFilter filter = MethodFilters.getMultiMethodFilter((IMethodFilter[])new IMethodFilter[]{MethodFilters.getFlagsFilter((int)1), MethodFilters.getNameRegexFilter((Pattern)Pattern.compile("^(get|set|is).*"))});
        IMethod[] iMethodArray = TypeUtility.getMethods((IType)type, (IMethodFilter)filter);
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            collector.add(m.getElementName());
            ++n2;
        }
    }
}

