/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.radiobutton;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.form.field.ButtonFieldNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureSubTypeProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RadioButtonNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iRadioButton = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton");
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private String m_genericSignature;
    private SiblingProposal m_sibling;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_genericTypeField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private IType m_createdRadioButton;
    private IType m_radioButtonGroupValueType;
    private String m_radioButtonGroupValueTypeSig;

    public RadioButtonNewWizardPage(IType declaringType) {
        super(RadioButtonNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewRadioButtonNoPopup"));
        this.setDescription(Texts.get((String)"CreateANewRadioButton"));
        this.m_declaringType = declaringType;
        this.m_sibling = SiblingProposal.SIBLING_END;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"PropLabel"));
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    RadioButtonNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = RadioButtonNewWizardPage.this.getNlsName();
                    RadioButtonNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (RadioButtonNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(RadioButtonNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)RadioButtonNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        RadioButtonNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)RadioButtonNewWizardPage.this.m_nlsName.getKey(), (boolean)false));
                    }
                }
                finally {
                    RadioButtonNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        ITypeFilter filter = null;
        try {
            ITypeHierarchy radioGroupSuperTypeHierarchy = this.m_declaringType.newSupertypeHierarchy(null);
            this.m_radioButtonGroupValueTypeSig = SignatureUtility.resolveGenericParameterInSuperHierarchy((IType)this.m_declaringType, (ITypeHierarchy)radioGroupSuperTypeHierarchy, (String)"org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup", (String)"T");
            if (this.m_radioButtonGroupValueTypeSig != null) {
                this.m_radioButtonGroupValueType = TypeUtility.getTypeBySignature((String)this.m_radioButtonGroupValueTypeSig);
                filter = TypeFilters.getTypeParamSubTypeFilter((String)this.m_radioButtonGroupValueTypeSig, (String)"org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton", (String)"T");
            }
        }
        catch (CoreException e1) {
            ScoutSdkUi.logWarning("Cannot resolve RadioButtonGroup generic type.", e1);
        }
        IType defaultSuperType = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton", (IJavaProject)this.m_declaringType.getJavaProject());
        if (filter == null || filter.accept(defaultSuperType)) {
            this.m_superType = defaultSuperType;
            if (this.m_radioButtonGroupValueTypeSig != null) {
                this.setGenericSignature(this.m_radioButtonGroupValueTypeSig);
            }
        }
        final SignatureSubTypeProposalProvider genericProposalProvider = new SignatureSubTypeProposalProvider(this.getGenericTypeOfSuperClass(), this.m_declaringType.getJavaProject());
        IType genericTypeOfSuperClass = this.getGenericTypeOfSuperClass();
        try {
            genericProposalProvider.setBaseType(TypeUtility.getMoreSpecificType((IType)genericTypeOfSuperClass, (IType)this.m_radioButtonGroupValueType));
        }
        catch (JavaModelException e1) {
            ScoutSdkUi.logWarning("Cannot resolve generic base type.", e1);
        }
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Button");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RadioButtonNewWizardPage.this.m_typeName = RadioButtonNewWizardPage.this.m_typeNameField.getText();
                RadioButtonNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iRadioButton, this.m_declaringType.getJavaProject(), filter, defaultSuperType));
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                RadioButtonNewWizardPage.this.m_superType = (IType)event.proposal;
                RadioButtonNewWizardPage.this.pingStateChanging();
                IType gtosc = RadioButtonNewWizardPage.this.getGenericTypeOfSuperClass();
                try {
                    if (TypeUtility.exists((IJavaElement)gtosc) && (RadioButtonNewWizardPage.this.getGenericSignature() == null || !TypeUtility.getTypeBySignature((String)RadioButtonNewWizardPage.this.getGenericSignature()).newSupertypeHierarchy(null).contains(gtosc))) {
                        RadioButtonNewWizardPage.this.m_genericTypeField.acceptProposal(SignatureCache.createTypeSignature((String)gtosc.getFullyQualifiedName()));
                    }
                    genericProposalProvider.setBaseType(TypeUtility.getMoreSpecificType((IType)gtosc, (IType)RadioButtonNewWizardPage.this.m_radioButtonGroupValueType));
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                }
            }
        });
        this.m_genericTypeField = this.getFieldToolkit().createProposalField(parent, Texts.get((String)"ValueType"), 1);
        this.m_genericTypeField.setContentProvider(genericProposalProvider);
        this.m_genericTypeField.setLabelProvider((IBaseLabelProvider)genericProposalProvider.getLabelProvider());
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()));
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                RadioButtonNewWizardPage.this.m_genericSignature = (String)event.proposal;
                RadioButtonNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createFormFieldSiblingProposalField(parent, this.m_declaringType);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                RadioButtonNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                RadioButtonNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_sibling = (SiblingProposal)this.m_siblingField.getSelectedProposal();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SiblingProposal siblingProposal;
        ButtonFieldNewOperation op = new ButtonFieldNewOperation(this.getTypeName(), this.getDeclaringType(), true);
        if (this.getNlsName() != null) {
            op.setNlsEntry(this.getNlsName());
        }
        if (this.getSuperType() != null) {
            String sig = null;
            sig = this.getGenericSignature() != null ? SignatureCache.createTypeSignature((String)(String.valueOf(this.getSuperType().getFullyQualifiedName()) + "<" + Signature.toString((String)this.getGenericSignature()) + ">")) : SignatureCache.createTypeSignature((String)this.getSuperType().getFullyQualifiedName());
            op.setSuperTypeSignature(sig);
        }
        if ((siblingProposal = this.getSibling()) == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredCompositeField((IType)this.m_declaringType);
            op.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_FORM_FIELD));
        } else if (siblingProposal != null) {
            op.setSibling(siblingProposal.getElement());
        }
        op.validate();
        op.run(monitor, workingCopyManager);
        this.m_createdRadioButton = op.getCreatedButton();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusNameField());
        multiStatus.add(this.getStatusSuperType());
        multiStatus.add(this.getStatusGenericType());
        multiStatus.add(this.getStatusGenericTypeToSuperClass());
        if (this.isControlCreated()) {
            this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()));
        }
    }

    protected IStatus getStatusNameField() {
        return ScoutUtility.validateFormFieldName((String)this.getTypeName(), (String)"Button", (IType)this.m_declaringType);
    }

    protected IStatus getStatusSuperType() {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericType() {
        if (TypeUtility.isGenericType((IType)this.getSuperType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericTypeToSuperClass() {
        IType generic;
        IType superType;
        if (this.getGenericSignature() != null && TypeUtility.exists((IJavaElement)(superType = this.getGenericTypeOfSuperClass())) && TypeUtility.exists((IJavaElement)(generic = TypeUtility.getTypeBySignature((String)this.getGenericSignature()))) && !TypeUtility.getSuperTypeHierarchy((IType)generic).contains(superType)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeDoesNotMatchSuperClass"));
        }
        return Status.OK_STATUS;
    }

    protected IType getGenericTypeOfSuperClass() {
        if (TypeUtility.exists((IJavaElement)this.getSuperType())) {
            try {
                String typeParamSig = SignatureUtility.resolveGenericParameterInSuperHierarchy((IType)this.getSuperType(), (ITypeHierarchy)this.getSuperType().newSupertypeHierarchy(null), (String)"org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton", (String)"T");
                if (typeParamSig != null) {
                    return TypeUtility.getTypeBySignature((String)typeParamSig);
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logError(e);
            }
        }
        return null;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    public IType getCreatedRadioButton() {
        return this.m_createdRadioButton;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setGenericSignature(String genericSignature) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericSignature;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getGenericSignature() {
        return this.m_genericSignature;
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

