/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.operation.service.CalendarServiceNewOperation;
import org.eclipse.scout.sdk.operation.service.ServiceRegistrationDescription;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractServiceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.services.ServiceNewWizardPage;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class CalendarServiceNewWizard
extends AbstractServiceWizard {
    public static final String TYPE_SERVICE_INTERFACE = "svcIfc";
    public static final String TYPE_SERVICE_IMPLEMENTATION = "svcImpl";
    public static final String TYPE_SERVICE_REG_CLIENT = "svcClientReg";
    public static final String TYPE_SERVICE_REG_SERVER = "svcServerReg";
    private final ServiceNewWizardPage m_serviceNewWizardPage;
    private final BundleTreeWizardPage m_locationWizardPage;
    private final ITreeNode m_locationWizardPageRoot;
    private CalendarServiceNewOperation m_operation;

    public CalendarServiceNewWizard(IScoutBundle serverBundle) {
        this.setWindowTitle(Texts.get((String)"NewCalendarService"));
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_serviceNewWizardPage = new ServiceNewWizardPage(Texts.get((String)"NewCalendarService"), Texts.get((String)"CreateANewCalendarService"), TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.calendar.ICalendarService"), "CalendarService", serverBundle, DefaultTargetPackage.get((IScoutBundle)serverBundle, (String)"server.services.calendar"));
        this.m_serviceNewWizardPage.addStatusProvider(statusProvider);
        this.m_serviceNewWizardPage.addPropertyChangeListener(new P_LocationPropertyListener());
        this.addPage((IWizardPage)this.m_serviceNewWizardPage);
        this.m_locationWizardPageRoot = this.createTree(serverBundle);
        this.m_locationWizardPage = new BundleTreeWizardPage(Texts.get((String)"CalendarServiceLocation"), Texts.get((String)"OrganiseLocations"), this.m_locationWizardPageRoot, new AbstractServiceWizard.P_InitialCheckedFilter(this));
        this.m_locationWizardPage.addStatusProvider(statusProvider);
        this.m_locationWizardPage.addDndListener(new P_TreeDndListener());
        this.m_locationWizardPage.addCheckSelectionListener(new AbstractServiceWizard.P_SessionCheckListener(this));
        this.addPage((IWizardPage)this.m_locationWizardPage);
        this.m_serviceNewWizardPage.setSuperType(RuntimeClasses.getSuperType((String)"org.eclipse.scout.service.IService", (IJavaProject)serverBundle.getJavaProject()));
    }

    private ITreeNode createTree(IScoutBundle serverBundle) {
        IScoutBundle sharedBundle = null;
        IScoutBundle clientBundle = null;
        sharedBundle = serverBundle.getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), false);
        if (sharedBundle != null) {
            clientBundle = sharedBundle.getChildBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}), serverBundle, false);
        }
        ITreeNode rootNode = TreeUtility.createBundleTree(serverBundle, NodeFilters.getByType("CLIENT", "SERVER", "SHARED"), ScoutBundleFilters.getWorkspaceBundlesFilter());
        if (clientBundle != null) {
            ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
            TreeUtility.createNode(clientNode, TYPE_SERVICE_REG_CLIENT, Texts.get((String)"ServiceProxyRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"));
        }
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, TYPE_SERVICE_INTERFACE, Texts.get((String)"IService"), ScoutSdkUi.getImageDescriptor("innerinterface_obj.gif"));
        }
        ITreeNode serverNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(serverBundle));
        TreeUtility.createNode(serverNode, TYPE_SERVICE_IMPLEMENTATION, Texts.get((String)"Service"), ScoutSdkUi.getImageDescriptor("class_obj.gif"), 1);
        ITreeNode svcRegNode = TreeUtility.createNode(serverNode, TYPE_SERVICE_REG_SERVER, Texts.get((String)"ServiceRegistration"), ScoutSdkUi.getImageDescriptor("public_co.gif"), 2);
        this.refreshAvailableSessions(svcRegNode, svcRegNode);
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle[] regProxyLocations;
        IScoutBundle implementationBundle;
        this.m_operation = new CalendarServiceNewOperation(this.m_locationWizardPage.getTextOfNode(TYPE_SERVICE_INTERFACE, true, true), this.m_locationWizardPage.getTextOfNode(TYPE_SERVICE_IMPLEMENTATION, true, true));
        IType superType = this.m_serviceNewWizardPage.getSuperType();
        if (superType != null) {
            this.m_operation.setImplementationSuperTypeSignature(SignatureCache.createTypeSignature((String)superType.getFullyQualifiedName()));
        }
        if ((implementationBundle = this.m_locationWizardPage.getLocationBundle(TYPE_SERVICE_IMPLEMENTATION, true, true)) != null) {
            this.m_operation.setImplementationProject(implementationBundle.getJavaProject());
            this.m_operation.setImplementationPackageName(implementationBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage()));
        }
        IScoutBundle[] iScoutBundleArray = regProxyLocations = this.m_locationWizardPage.getLocationBundles(TYPE_SERVICE_REG_CLIENT, true, true);
        int n = regProxyLocations.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle cb = iScoutBundleArray[n2];
            this.m_operation.addProxyRegistrationProject(cb.getJavaProject());
            ++n2;
        }
        for (ServiceRegistrationDescription desc : this.getCheckedServiceRegistrations(this.m_locationWizardPage.getTreeNodes(TYPE_SERVICE_REG_SERVER, true, true))) {
            this.m_operation.addServiceRegistration(desc);
            this.storeUsedSession(desc);
        }
        IScoutBundle interfaceBundle = this.m_locationWizardPage.getLocationBundle(TYPE_SERVICE_INTERFACE, true, true);
        if (interfaceBundle != null) {
            this.m_operation.setInterfaceProject(interfaceBundle.getJavaProject());
            this.m_operation.setInterfacePackageName(interfaceBundle.getPackageName(this.m_serviceNewWizardPage.getTargetPackage()));
        }
        this.m_operation.addInterfaceInterfaceSignature(SignatureCache.createTypeSignature((String)"org.eclipse.scout.rt.shared.services.common.calendar.ICalendarService"));
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.validate();
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (IllegalArgumentException e) {
            ScoutSdkUi.logWarning("validation error of operation '" + this.m_operation.getOperationName() + "'. " + e.getMessage());
            return false;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during executing operation '" + this.m_operation.getOperationName() + "'.", e);
            return false;
        }
    }

    @Override
    public BundleTreeWizardPage getLocationsPage() {
        return this.m_locationWizardPage;
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String typeName;
            if (evt.getPropertyName().equals("typeName") && !StringUtility.isNullOrEmpty((String)(typeName = CalendarServiceNewWizard.this.m_serviceNewWizardPage.getTypeName()))) {
                String prefix = typeName.replaceAll("CalendarService$", "");
                TreeUtility.findNode(CalendarServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(CalendarServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION)).setText(String.valueOf(prefix) + "CalendarService");
                TreeUtility.findNode(CalendarServiceNewWizard.this.m_locationWizardPageRoot, NodeFilters.getByType(CalendarServiceNewWizard.TYPE_SERVICE_INTERFACE)).setText("I" + prefix + "CalendarService");
                CalendarServiceNewWizard.this.m_locationWizardPage.refreshTree();
            }
            CalendarServiceNewWizard.this.m_locationWizardPage.pingStateChanging();
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusService());
            multiStatus.add(this.getStatusServiceRegistrationClient());
            multiStatus.add(this.getStatusServiceRegistrationServer());
            multiStatus.add(this.getStatusTypeNames());
        }

        protected IStatus getStatusTypeNames() {
            ITreeNode serviceInterfaceNode;
            IScoutBundle serviceInterfaceBundle;
            ITreeNode serviceImplNode;
            IScoutBundle serviceImplementationBundle = CalendarServiceNewWizard.this.m_locationWizardPage.getLocationBundle(CalendarServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null && (serviceImplNode = CalendarServiceNewWizard.this.m_locationWizardPage.getTreeNode(CalendarServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceImplementationBundle.getPackageName(CalendarServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage())) + "." + serviceImplNode.getText();
                    if (serviceImplementationBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceImplNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            if ((serviceInterfaceBundle = CalendarServiceNewWizard.this.m_locationWizardPage.getLocationBundle(CalendarServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && (serviceInterfaceNode = CalendarServiceNewWizard.this.m_locationWizardPage.getTreeNode(CalendarServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null) {
                try {
                    String fqn = String.valueOf(serviceInterfaceBundle.getPackageName(CalendarServiceNewWizard.this.m_serviceNewWizardPage.getTargetPackage())) + "." + serviceInterfaceNode.getText();
                    if (serviceInterfaceBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", "'" + serviceInterfaceNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusService() {
            IScoutBundle serviceInterfaceBundle;
            IScoutBundle serviceImplementationBundle = CalendarServiceNewWizard.this.m_locationWizardPage.getLocationBundle(CalendarServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            if (serviceImplementationBundle != null && (serviceInterfaceBundle = CalendarServiceNewWizard.this.m_locationWizardPage.getLocationBundle(CalendarServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true)) != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceImplementationBundle)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "'" + CalendarServiceNewWizard.this.m_locationWizardPage.getTextOfNode(CalendarServiceNewWizard.TYPE_SERVICE_INTERFACE) + " is not on classpath of '" + CalendarServiceNewWizard.this.m_locationWizardPage.getTextOfNode(CalendarServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION) + "'.");
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationClient() {
            ITreeNode[] serviceRegistrationClientNodes;
            IScoutBundle serviceInterfaceBundle = CalendarServiceNewWizard.this.m_locationWizardPage.getLocationBundle(CalendarServiceNewWizard.TYPE_SERVICE_INTERFACE, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationClientNodes = CalendarServiceNewWizard.this.m_locationWizardPage.getTreeNodes(CalendarServiceNewWizard.TYPE_SERVICE_REG_CLIENT, true, true);
            int n = serviceRegistrationClientNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceInterfaceBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceInterfaceBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{CalendarServiceNewWizard.this.m_locationWizardPage.getTextOfNode(CalendarServiceNewWizard.TYPE_SERVICE_INTERFACE), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusServiceRegistrationServer() {
            ITreeNode[] serviceRegistrationServerNodes;
            IScoutBundle serviceImplementationBundle = CalendarServiceNewWizard.this.m_locationWizardPage.getLocationBundle(CalendarServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, true, true);
            ITreeNode[] iTreeNodeArray = serviceRegistrationServerNodes = CalendarServiceNewWizard.this.m_locationWizardPage.getTreeNodes(CalendarServiceNewWizard.TYPE_SERVICE_REG_SERVER, true, true);
            int n = serviceRegistrationServerNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode serviceRegNode = iTreeNodeArray[n2];
                Object data = serviceRegNode.getParent().getData();
                if (data instanceof IScoutBundle) {
                    IScoutBundle serviceRegistrationBundle = (IScoutBundle)data;
                    if (serviceImplementationBundle != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)serviceImplementationBundle, (IScoutBundle)serviceRegistrationBundle)) {
                        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotOnClasspathOfServiceY", (String[])new String[]{CalendarServiceNewWizard.this.m_locationWizardPage.getTextOfNode(CalendarServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION), serviceRegistrationBundle.getSymbolicName()}));
                    }
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            return TreeUtility.isOneOf(node.getType(), CalendarServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION, CalendarServiceNewWizard.TYPE_SERVICE_INTERFACE, CalendarServiceNewWizard.TYPE_SERVICE_REG_CLIENT, CalendarServiceNewWizard.TYPE_SERVICE_REG_SERVER);
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.targetParent.getData() instanceof IScoutBundle && ((IScoutBundle)dndEvent.targetParent.getData()).isBinary()) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            if (dndEvent.node.getType() == CalendarServiceNewWizard.TYPE_SERVICE_REG_SERVER) {
                CalendarServiceNewWizard.this.refreshAvailableSessions(dndEvent.newNode, dndEvent.node);
            }
            CalendarServiceNewWizard.this.m_serviceNewWizardPage.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            String t = dndEvent.node.getType();
            dndEvent.doit = CalendarServiceNewWizard.TYPE_SERVICE_REG_CLIENT.equals(t) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (CalendarServiceNewWizard.TYPE_SERVICE_REG_SERVER.equals(t) ? "SERVER".equals(dndEvent.targetParent.getType()) : false);
        }

        private void validateDropMove(DndEvent dndEvent) {
            String t = dndEvent.node.getType();
            dndEvent.doit = CalendarServiceNewWizard.TYPE_SERVICE_REG_CLIENT.equals(t) ? "CLIENT".equals(dndEvent.targetParent.getType()) : (CalendarServiceNewWizard.TYPE_SERVICE_INTERFACE.equals(t) ? "SHARED".equals(dndEvent.targetParent.getType()) : (CalendarServiceNewWizard.TYPE_SERVICE_IMPLEMENTATION.equals(t) || CalendarServiceNewWizard.TYPE_SERVICE_REG_SERVER.equals(t) ? "SERVER".equals(dndEvent.targetParent.getType()) : false));
        }
    }
}

