/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.ast.visitor;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.scout.sdk.util.ast.visitor.DefaultAstVisitor;

public class MethodBodyAstVisitor
extends DefaultAstVisitor {
    private final String m_declaringTypeFqn;
    private final IMethod m_method;
    private final ASTVisitor m_visitor;
    private boolean m_inMethod;
    private boolean m_inBody;

    public MethodBodyAstVisitor(IMethod methodToVisit, ASTVisitor visitor) {
        this.m_method = methodToVisit;
        this.m_declaringTypeFqn = methodToVisit.getDeclaringType().getFullyQualifiedName();
        this.m_visitor = visitor;
        this.m_inMethod = false;
        this.m_inBody = false;
    }

    @Override
    public boolean visitNode(ASTNode node) {
        if (this.m_inBody) {
            node.accept(this.m_visitor);
        }
        return false;
    }

    @Override
    public boolean visit(CompilationUnit node) {
        return true;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        IJavaElement javaElement;
        boolean isMethodInteresting = false;
        IMethodBinding binding = node.resolveBinding();
        if (binding != null && (javaElement = binding.getJavaElement()) != null) {
            isMethodInteresting = javaElement.equals(this.m_method);
        }
        this.m_inMethod = isMethodInteresting;
        return isMethodInteresting;
    }

    public void endVisit(MethodDeclaration node) {
        this.m_inMethod = false;
        this.m_inBody = false;
    }

    @Override
    public boolean visit(Block node) {
        if (this.m_inMethod) {
            this.m_inBody = true;
            return this.m_inBody;
        }
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        ITypeBinding binding = node.resolveBinding();
        if (binding != null) {
            String curTypeFqn = ((IType)binding.getJavaElement()).getFullyQualifiedName();
            return this.m_declaringTypeFqn.startsWith(curTypeFqn);
        }
        return true;
    }
}

