/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.ast.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.scout.sdk.util.ast.AstUtility;
import org.eclipse.scout.sdk.util.ast.VariableType;
import org.eclipse.scout.sdk.util.ast.visitor.DefaultAstVisitor;
import org.eclipse.scout.sdk.util.ast.visitor.VariableResolveVisitor;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;

public class TypeSignatureResolveVisitor
extends DefaultAstVisitor {
    private boolean m_debug = false;
    private boolean m_canceled;
    public String m_indent = "";
    private final IJavaElement m_containerElement;
    private final ASTNode m_rootNode;
    private int m_mode;
    private HashSet<String> m_assignedSignatures;
    private String m_typeSignature;
    private P_MethodInvocation m_methodInvocation;

    public TypeSignatureResolveVisitor(ASTNode rootNode, IJavaElement containerElement) {
        this.m_rootNode = rootNode;
        this.m_containerElement = containerElement;
        this.m_assignedSignatures = new HashSet();
    }

    public void preVisit(ASTNode node) {
        if (this.m_debug && !this.m_canceled) {
            SdkUtilActivator.logInfo(String.valueOf(this.m_indent) + "typeSigResolve " + node.getNodeType() + "  " + node + "     ");
            this.m_indent = String.valueOf(this.m_indent) + "  ";
        }
    }

    public void postVisit(ASTNode node) {
        if (this.m_debug && !this.m_canceled) {
            this.m_indent = this.m_indent.replaceFirst("\\s\\s$", "");
            SdkUtilActivator.logInfo(String.valueOf(this.m_indent) + "end " + node.getNodeType());
        }
    }

    @Override
    public boolean visitNode(ASTNode node) {
        return !this.m_canceled;
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        if (this.m_canceled) {
            return false;
        }
        this.m_mode = node.getNodeType();
        return super.visit(node);
    }

    public void endVisit(ClassInstanceCreation node) {
        if (this.m_mode == node.getNodeType()) {
            this.m_mode = -1;
            this.m_canceled = true;
        }
    }

    @Override
    public boolean visit(MethodInvocation node) {
        if (this.m_canceled) {
            return false;
        }
        this.m_methodInvocation = new P_MethodInvocation();
        this.m_mode = node.getNodeType();
        return super.visit(node);
    }

    public void endVisit(MethodInvocation node) {
        if (this.m_mode == node.getNodeType()) {
            if (this.m_methodInvocation != null) {
                List segments = this.m_methodInvocation.m_segments;
                ArrayList<String> fqSignatures = new ArrayList<String>();
                if (segments.size() > 1) {
                    VariableType var = AstUtility.getTypeSignature((ASTNode)segments.get(0), this.m_rootNode, this.m_containerElement);
                    if (var.getAssignedTypeSignatures().length > 0) {
                        fqSignatures.addAll(Arrays.asList(var.getAssignedTypeSignatures()));
                    } else if (var.getTypeSignature() != null) {
                        fqSignatures.add(var.getTypeSignature());
                    }
                    int i = 1;
                    while (i < segments.size()) {
                        ArrayList<String> newList = new ArrayList<String>();
                        for (String sig : fqSignatures) {
                            String newSig = AstUtility.resolveReturnValueSignature(sig, ((SimpleName)segments.get(i)).getFullyQualifiedName());
                            newList.add(newSig);
                        }
                        fqSignatures = newList;
                        ++i;
                    }
                } else if (segments.size() == 1) {
                    String resolveReturnValueSignature;
                    IType declaringType = JdtUtility.findDeclaringType(this.m_containerElement);
                    this.m_typeSignature = resolveReturnValueSignature = AstUtility.resolveReturnValueSignature(SignatureCache.createTypeSignature(declaringType.getFullyQualifiedName()), node.getName().getFullyQualifiedName());
                }
                this.m_assignedSignatures.addAll(fqSignatures);
                this.m_canceled = true;
                this.m_methodInvocation = null;
            }
            this.m_mode = -1;
            this.m_canceled = true;
        }
    }

    @Override
    public boolean visit(SimpleType node) {
        if (this.m_canceled) {
            return false;
        }
        switch (this.m_mode) {
            case 14: {
                String signature = Signature.createTypeSignature((String)node.getName().getFullyQualifiedName(), (boolean)false);
                IType declaringType = JdtUtility.findDeclaringType(this.m_containerElement);
                try {
                    String resolvedSignature = SignatureUtility.getResolvedSignature(signature, declaringType);
                    if (resolvedSignature != null) {
                        this.m_typeSignature = resolvedSignature;
                    }
                }
                catch (CoreException e) {
                    SdkUtilActivator.logError("could not resolve class instance creation of '" + signature + "' in '" + declaringType.getFullyQualifiedName() + "'.");
                }
                this.m_canceled = true;
                return false;
            }
            case 32: {
                return false;
            }
        }
        return super.visit(node);
    }

    @Override
    public boolean visit(SimpleName node) {
        if (this.m_canceled) {
            return false;
        }
        switch (this.m_mode) {
            case 32: {
                if (this.m_methodInvocation != null) {
                    this.m_methodInvocation.m_segments.add(node);
                }
                return false;
            }
        }
        if (!this.m_assignedSignatures.isEmpty() || this.m_typeSignature != null) {
            HashSet<String> newSet = new HashSet<String>();
            if (!this.m_assignedSignatures.isEmpty()) {
                for (String s : this.m_assignedSignatures) {
                    newSet.add(AstUtility.resolveReturnValueSignature(s, node.getFullyQualifiedName()));
                }
            } else if (this.m_typeSignature != null) {
                newSet.add(AstUtility.resolveReturnValueSignature(this.m_typeSignature, node.getFullyQualifiedName()));
            }
            this.m_typeSignature = null;
            this.m_assignedSignatures.clear();
            this.m_assignedSignatures.addAll(newSet);
        } else {
            VariableResolveVisitor visitor = new VariableResolveVisitor(node.getFullyQualifiedName(), this.m_containerElement, this.m_rootNode, (ASTNode)node);
            this.m_rootNode.accept((ASTVisitor)visitor);
            String[] assignedTypesSignatures = visitor.getAssignedTypesSignatures();
            if (assignedTypesSignatures.length > 0) {
                this.m_assignedSignatures.addAll(Arrays.asList(assignedTypesSignatures));
            } else if (visitor.getVariableTypeSignature() != null) {
                this.m_typeSignature = visitor.getVariableTypeSignature();
            }
        }
        return super.visit(node);
    }

    public String[] getAssignedSignatures() {
        return this.m_assignedSignatures.toArray(new String[this.m_assignedSignatures.size()]);
    }

    public String getTypeSignature() {
        return this.m_typeSignature;
    }

    private class P_MethodInvocation {
        private List<SimpleName> m_segments = new ArrayList<SimpleName>();

        private P_MethodInvocation() {
        }
    }
}

