/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.internal.typecache.CachedTypeHierarchy;
import org.eclipse.scout.sdk.util.internal.typecache.PrimaryTypeHierarchy;
import org.eclipse.scout.sdk.util.internal.typecache.TypeHierarchy;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IHierarchyCache;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;

public final class HierarchyCache
implements IHierarchyCache {
    private static final HierarchyCache INSTANCE = new HierarchyCache();
    private final Object m_cacheLock;
    private final HashMap<IType, PrimaryTypeHierarchy> m_cachedPrimaryTypeHierarchies = new HashMap();

    public static HierarchyCache getInstance() {
        return INSTANCE;
    }

    private HierarchyCache() {
        this.m_cacheLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.m_cacheLock;
        synchronized (object) {
            this.m_cachedPrimaryTypeHierarchies.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPrimaryTypeTypeHierarchy[] getAllCachedHierarchies() {
        Object object = this.m_cacheLock;
        synchronized (object) {
            return this.m_cachedPrimaryTypeHierarchies.values().toArray(new IPrimaryTypeTypeHierarchy[this.m_cachedPrimaryTypeHierarchies.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPrimaryTypeTypeHierarchy getPrimaryTypeHierarchy(IType type) throws IllegalArgumentException {
        if (!TypeUtility.exists((IJavaElement)type) || !type.getJavaProject().exists()) {
            throw new IllegalArgumentException("type does not exist!");
        }
        if (TypeUtility.exists((IJavaElement)type.getDeclaringType())) {
            throw new IllegalArgumentException("type '" + type.getElementName() + "' must be a primary type.");
        }
        PrimaryTypeHierarchy hierarchy = null;
        Object object = this.m_cacheLock;
        synchronized (object) {
            hierarchy = this.m_cachedPrimaryTypeHierarchies.get(type);
            if (!(hierarchy == null || TypeUtility.exists((IJavaElement)hierarchy.getType()) && TypeUtility.exists((IJavaElement)hierarchy.getType().getJavaProject()))) {
                this.m_cachedPrimaryTypeHierarchies.remove(type);
                hierarchy = null;
            }
            if (hierarchy == null) {
                hierarchy = new PrimaryTypeHierarchy(type);
                this.m_cachedPrimaryTypeHierarchies.put(type, hierarchy);
            }
        }
        return hierarchy;
    }

    @Override
    public TypeHierarchy getLocalHierarchy(IRegion region) {
        try {
            ITypeHierarchy hierarchy = JavaCore.newTypeHierarchy((IRegion)region, null, null);
            return new TypeHierarchy(null, hierarchy);
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not build hierarchy of region '" + region + "'.", e);
            return null;
        }
    }

    @Override
    public TypeHierarchy getSuperHierarchy(IType type) {
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
            return new TypeHierarchy(type, hierarchy);
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not build super hierarchy '" + type.getFullyQualifiedName() + "'.", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll() {
        Object object = this.m_cacheLock;
        synchronized (object) {
            for (IPrimaryTypeTypeHierarchy iPrimaryTypeTypeHierarchy : this.m_cachedPrimaryTypeHierarchies.values()) {
                if (!iPrimaryTypeTypeHierarchy.isCreated()) continue;
                iPrimaryTypeTypeHierarchy.invalidate();
            }
        }
    }

    private static boolean areTypesInHierarchy(CachedTypeHierarchy h, IType[] types) {
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (h.contains(t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTypeChange(IType t, ITypeHierarchy superTypeHierarchy) {
        try {
            ArrayList<PrimaryTypeHierarchy> hierarchies = new ArrayList<PrimaryTypeHierarchy>(this.m_cachedPrimaryTypeHierarchies.size());
            if (!TypeUtility.exists((IJavaElement)t.getDeclaringType())) {
                Object object = this.m_cacheLock;
                synchronized (object) {
                    hierarchies.addAll(this.m_cachedPrimaryTypeHierarchies.values());
                }
            }
            if (hierarchies.size() > 0) {
                IType[] superTypes = superTypeHierarchy.getSupertypes(t);
                for (CachedTypeHierarchy cachedTypeHierarchy : hierarchies) {
                    if (!cachedTypeHierarchy.isCreated()) continue;
                    if (cachedTypeHierarchy.contains(t)) {
                        if (!HierarchyCache.areTypesInHierarchy(cachedTypeHierarchy, superTypes)) {
                            cachedTypeHierarchy.invalidate();
                            continue;
                        }
                        IType[] hierarchySuperTypes = cachedTypeHierarchy.getSubtypes(t);
                        if (TypeUtility.equalTypes(hierarchySuperTypes, superTypes)) continue;
                        cachedTypeHierarchy.invalidate();
                        continue;
                    }
                    if (!HierarchyCache.areTypesInHierarchy(cachedTypeHierarchy, superTypes)) continue;
                    cachedTypeHierarchy.invalidate();
                }
            }
        }
        catch (Exception e) {
            SdkUtilActivator.logError("could not handle type('" + t.getFullyQualifiedName() + "') change in hierarchies.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTypeRemoved(IType type) {
        try {
            ArrayList<PrimaryTypeHierarchy> hierarchies = new ArrayList<PrimaryTypeHierarchy>(this.m_cachedPrimaryTypeHierarchies.size());
            Object object = this.m_cacheLock;
            synchronized (object) {
                hierarchies.addAll(this.m_cachedPrimaryTypeHierarchies.values());
            }
            ITypeFilter compilationUnitFilter = TypeFilters.getInnerTypeFilter(type);
            block5: for (CachedTypeHierarchy cachedTypeHierarchy : hierarchies) {
                IType[] allTypes;
                if (!cachedTypeHierarchy.isCreated()) continue;
                IType[] iTypeArray = allTypes = cachedTypeHierarchy.getJdtHierarchy().getAllTypes();
                int n = allTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType candidate = iTypeArray[n2];
                    if (compilationUnitFilter.accept(candidate)) {
                        cachedTypeHierarchy.invalidate();
                        continue block5;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            SdkUtilActivator.logError("could not handle type removed ('" + type.getElementName() + "') change in hierarchies.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJavaElementRemoved(IJavaElement element) {
        if (element.getElementType() < 7) {
            try {
                ArrayList<PrimaryTypeHierarchy> hierarchies = new ArrayList<PrimaryTypeHierarchy>(this.m_cachedPrimaryTypeHierarchies.size());
                Object object = this.m_cacheLock;
                synchronized (object) {
                    hierarchies.addAll(this.m_cachedPrimaryTypeHierarchies.values());
                }
                for (CachedTypeHierarchy cachedTypeHierarchy : hierarchies) {
                    IType[] allTypes;
                    if (TypeUtility.isAncestor(element, (IJavaElement)cachedTypeHierarchy.getType())) {
                        Object object2 = this.m_cacheLock;
                        synchronized (object2) {
                            this.m_cachedPrimaryTypeHierarchies.remove(cachedTypeHierarchy.getType());
                            continue;
                        }
                    }
                    if (!cachedTypeHierarchy.isCreated()) continue;
                    IType[] iTypeArray = allTypes = cachedTypeHierarchy.getJdtHierarchy().getAllTypes();
                    int n = allTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType candidate = iTypeArray[n2];
                        if (TypeUtility.isAncestor(element, (IJavaElement)candidate)) {
                            cachedTypeHierarchy.invalidate();
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                SdkUtilActivator.logError("could not handle element removed event ('" + element.getElementName() + "') in hierarchies.");
            }
        } else if (element.getElementType() == 7) {
            this.handleTypeRemoved((IType)element);
        }
    }

    private void handleCompilationUnitChangedExternal(ICompilationUnit icu) {
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)icu);
        try {
            ITypeHierarchy hierarchy = JavaCore.newTypeHierarchy((IRegion)region, null, null);
            IType[] iTypeArray = icu.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType t = iTypeArray[n2];
                this.reqTypeChangedFromExternal(t, hierarchy);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not find types in compilation unti '" + icu.getElementName() + "'.", e);
        }
    }

    private void reqTypeChangedFromExternal(IType type, ITypeHierarchy hierarchy) {
        this.handleTypeChange(type, hierarchy);
        try {
            IType[] iTypeArray = type.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType subType = iTypeArray[n2];
                this.reqTypeChangedFromExternal(subType, hierarchy);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not find subtypes of type '" + type.getElementName() + "'.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        ArrayList<PrimaryTypeHierarchy> hierarchies = new ArrayList<PrimaryTypeHierarchy>(this.m_cachedPrimaryTypeHierarchies.size());
        Object object = this.m_cacheLock;
        synchronized (object) {
            hierarchies.addAll(this.m_cachedPrimaryTypeHierarchies.values());
            this.m_cachedPrimaryTypeHierarchies.clear();
        }
        for (CachedTypeHierarchy cachedTypeHierarchy : hierarchies) {
            cachedTypeHierarchy.invalidate();
        }
    }

    public void elementChanged(JdtEvent e) {
        switch (e.getEventType()) {
            case 1: 
            case 4: {
                if (e.getElementType() == 7 && e.getDeclaringType() == null) {
                    this.handleTypeChange((IType)e.getElement(), e.getSuperTypeHierarchy());
                    break;
                }
                if (e.getElementType() == 5) {
                    try {
                        IType[] types;
                        if (!TypeUtility.exists(e.getElement()) || (types = ((ICompilationUnit)e.getElement()).getTypes()).length <= 0) break;
                        this.handleTypeChange(types[0], e.getSuperTypeHierarchy());
                    }
                    catch (JavaModelException ex) {
                        SdkUtilActivator.logError(ex);
                    }
                    break;
                }
                if (e.getElementType() == 2) {
                    if ((e.getFlags() & 0x200) != 0 || e.getFlags() == 0) {
                        this.invalidateAll();
                        break;
                    }
                    if ((e.getFlags() & 0x400) == 0) break;
                    this.handleJavaElementRemoved(e.getElement());
                    break;
                }
                if (e.getElementType() != 3 || (e.getFlags() & 0x81C0) == 0 && e.getFlags() != 0) break;
                this.invalidateAll();
                break;
            }
            case 2: {
                if (!TypeUtility.exists(e.getElement().getParent())) break;
                this.handleJavaElementRemoved(e.getElement());
                break;
            }
            case 229: {
                if (e.getElementType() == 5) {
                    this.handleCompilationUnitChangedExternal((ICompilationUnit)e.getElement());
                    break;
                }
                if (e.getElementType() != 7) break;
                this.handleTypeChange((IType)e.getElement(), e.getSuperTypeHierarchy());
            }
        }
    }
}

