/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jdt.core.BufferChangedEvent;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.internal.typecache.HierarchyCache;
import org.eclipse.scout.sdk.util.internal.typecache.JdtEventCollector;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.jdt.finegraned.FineGrainedJavaElementDelta;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IJavaResourceChangedEmitter;

public final class JavaResourceChangedEmitter
implements IJavaResourceChangedEmitter {
    public static final int CHANGED_EXTERNAL = 229;
    public static final int CHANGED_FLAG_MASK = 7409459;
    private static final JavaResourceChangedEmitter INSTANCE = new JavaResourceChangedEmitter(HierarchyCache.getInstance());
    private final P_JavaElementChangedListener m_javaElementListener;
    private final Object m_resourceLock;
    private final HashMap<ICompilationUnit, JdtEventCollector> m_eventCollectors;
    private final EventListenerList m_eventListeners;
    private final WeakHashMap<IType, ArrayList<WeakReference<IJavaResourceChangedListener>>> m_innerTypeChangedListeners;
    private final WeakHashMap<IType, ArrayList<WeakReference<IJavaResourceChangedListener>>> m_methodChangedListeners;
    private final Object m_eventListenerLock;
    private final HierarchyCache m_hierarchyCache;
    private final IBufferChangedListener m_sourceBufferListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICompilationUnit[] getPendingWorkingCopies() {
        Object object = JavaResourceChangedEmitter.INSTANCE.m_resourceLock;
        synchronized (object) {
            return JavaResourceChangedEmitter.INSTANCE.m_eventCollectors.keySet().toArray(new ICompilationUnit[JavaResourceChangedEmitter.INSTANCE.m_eventCollectors.size()]);
        }
    }

    private JavaResourceChangedEmitter(HierarchyCache hierarchyCache) {
        this.m_hierarchyCache = hierarchyCache;
        this.m_eventCollectors = new HashMap();
        this.m_eventListenerLock = new Object();
        this.m_resourceLock = new Object();
        this.m_innerTypeChangedListeners = new WeakHashMap();
        this.m_methodChangedListeners = new WeakHashMap();
        this.m_eventListeners = new EventListenerList();
        this.m_sourceBufferListener = new P_SourceBufferListener();
        this.m_javaElementListener = new P_JavaElementChangedListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.m_javaElementListener);
        ICompilationUnit[] iCompilationUnitArray = JavaCore.getWorkingCopies(null);
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit icu = iCompilationUnitArray[n2];
            try {
                this.aquireEventCollector(icu);
            }
            catch (JavaModelException ex) {
                SdkUtilActivator.logWarning("could not aquire event collector for '" + icu.getElementName() + "'.", ex);
            }
            ++n2;
        }
    }

    public static JavaResourceChangedEmitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void dispose() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.m_javaElementListener);
        this.m_eventCollectors.clear();
        this.m_innerTypeChangedListeners.clear();
        this.m_methodChangedListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInnerTypeChangedListener(IType type, IJavaResourceChangedListener listener) {
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            ArrayList<WeakReference<IJavaResourceChangedListener>> listenerList = this.m_innerTypeChangedListeners.get(type);
            if (listenerList == null) {
                listenerList = new ArrayList();
                this.m_innerTypeChangedListeners.put(type, listenerList);
            }
            listenerList.add(new WeakReference<IJavaResourceChangedListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInnerTypeChangedListener(IType type, IJavaResourceChangedListener listener) {
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            ArrayList<WeakReference<IJavaResourceChangedListener>> listenerList = this.m_innerTypeChangedListeners.get(type);
            if (listenerList != null) {
                Iterator<WeakReference<IJavaResourceChangedListener>> it = listenerList.iterator();
                while (it.hasNext()) {
                    IJavaResourceChangedListener curListener = (IJavaResourceChangedListener)it.next().get();
                    if (curListener != null && !curListener.equals(listener)) continue;
                    it.remove();
                }
                if (listenerList.isEmpty()) {
                    this.m_innerTypeChangedListeners.remove(type);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMethodChangedListener(IType type, IJavaResourceChangedListener listener) {
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            ArrayList<WeakReference<IJavaResourceChangedListener>> listenerList = this.m_methodChangedListeners.get(type);
            if (listenerList == null) {
                listenerList = new ArrayList();
                this.m_methodChangedListeners.put(type, listenerList);
            }
            listenerList.add(new WeakReference<IJavaResourceChangedListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMethodChangedListener(IType type, IJavaResourceChangedListener listener) {
        Object object = this.m_eventListenerLock;
        synchronized (object) {
            ArrayList<WeakReference<IJavaResourceChangedListener>> listenerList = this.m_methodChangedListeners.get(type);
            if (listenerList != null) {
                Iterator<WeakReference<IJavaResourceChangedListener>> it = listenerList.iterator();
                while (it.hasNext()) {
                    IJavaResourceChangedListener curListener = (IJavaResourceChangedListener)it.next().get();
                    if (curListener != null && !curListener.equals(listener)) continue;
                    it.remove();
                }
                if (listenerList.isEmpty()) {
                    this.m_methodChangedListeners.remove(type);
                }
            }
        }
    }

    @Override
    public void addJavaResourceChangedListener(IJavaResourceChangedListener listener) {
        this.m_eventListeners.add(IJavaResourceChangedListener.class, (EventListener)listener);
    }

    @Override
    public void removeJavaResourceChangedListener(IJavaResourceChangedListener listener) {
        this.m_eventListeners.remove(IJavaResourceChangedListener.class, (EventListener)listener);
    }

    private void handleJdtDelta(ElementChangedEvent rootEvent, IJavaElementDelta delta) {
        IJavaElement e = delta.getElement();
        if (e == null) {
            return;
        }
        JdtEventCollector collector = null;
        ICompilationUnit compilationUnit = (ICompilationUnit)e.getAncestor(5);
        if (compilationUnit != null && TypeUtility.exists((IJavaElement)compilationUnit)) {
            collector = this.m_eventCollectors.get(compilationUnit);
            try {
                if (collector == null && compilationUnit.hasUnsavedChanges()) {
                    collector = this.aquireEventCollector(compilationUnit);
                }
            }
            catch (JavaModelException ex) {
                SdkUtilActivator.logWarning("could not aquire event collector for '" + compilationUnit.getElementName() + "'.", ex);
            }
        }
        int kind = delta.getKind();
        int flags = delta.getFlags();
        switch (kind) {
            case 1: {
                if (e.getElementType() < 5) {
                    this.fireEvent(new JdtEvent(this, kind, flags, e));
                    break;
                }
                this.addEvent(collector, new JdtEvent(this, kind, flags, e));
                break;
            }
            case 2: {
                if (e.getElementType() <= 5) {
                    this.removeEventCollectors(e);
                    this.fireEvent(new JdtEvent(this, kind, flags, e));
                    break;
                }
                this.addEvent(collector, new JdtEvent(this, kind, flags, e));
                break;
            }
            case 4: {
                if (e.getElementType() < 5) {
                    this.fireEvent(new JdtEvent(this, kind, flags, delta.getElement()));
                    break;
                }
                if (e.getElementType() == 5) {
                    if (collector == null || (flags & 0x710F33) == 0) break;
                    FineGrainedJavaElementDelta[] astDiff = collector.updateAst();
                    if (astDiff != null && astDiff.length > 0) {
                        FineGrainedJavaElementDelta[] fineGrainedJavaElementDeltaArray = astDiff;
                        int n = astDiff.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FineGrainedJavaElementDelta a = fineGrainedJavaElementDeltaArray[n2];
                            if (TypeUtility.exists(a.getElement())) {
                                this.addEvent(collector, new JdtEvent(this, kind, flags, a.getElement()));
                            }
                            ++n2;
                        }
                        break;
                    }
                    if (!collector.isEmpty()) break;
                    this.addEvent(collector, new JdtEvent(this, kind, flags, e));
                    break;
                }
                this.addEvent(collector, new JdtEvent(this, collector != null ? kind : 229, flags, e));
            }
        }
        if (e.getElementType() == 5) {
            ICompilationUnit icu = (ICompilationUnit)e;
            try {
                if (!icu.hasUnsavedChanges()) {
                    if (rootEvent.getType() == 4) {
                        this.releaseEventCollector((ICompilationUnit)e, true);
                    } else if (rootEvent.getType() == 1 && (flags & 8) == 0 && (flags & 1) == 0) {
                        this.releaseEventCollector(icu, true);
                    }
                }
            }
            catch (JavaModelException ex) {
                SdkUtilActivator.logWarning("could not release event collector for '" + icu.getElementName() + "'.", ex);
            }
        }
    }

    private void addEvent(JdtEventCollector collector, JdtEvent event) {
        if (collector != null) {
            if (collector.isEmpty()) {
                this.fireEvent(new JdtEvent(this, 10, 0, (IJavaElement)collector.getCompilationUnit()));
            }
            collector.addEvent(event);
        } else {
            this.fireEvent(event);
        }
    }

    private JdtEventCollector aquireEventCollector(ICompilationUnit icu) throws JavaModelException {
        JdtEventCollector collector = null;
        collector = this.m_eventCollectors.get(icu);
        if (collector == null && icu.isWorkingCopy()) {
            collector = new JdtEventCollector(icu);
            this.m_eventCollectors.put(icu, collector);
            icu.getBuffer().addBufferChangedListener(this.m_sourceBufferListener);
        }
        return collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseEventCollector(ICompilationUnit icu, boolean clearWorkingCopy) {
        JdtEventCollector collector = null;
        collector = icu.isWorkingCopy() ? this.m_eventCollectors.get(icu) : this.m_eventCollectors.remove(icu);
        if (collector != null && !collector.isEmpty()) {
            boolean fireChanges = false;
            JdtEvent[] jdtEvents = new JdtEvent[]{};
            Object object = this.m_resourceLock;
            synchronized (object) {
                if (collector.hasEvents()) {
                    long resourceModification = icu.getResource().getModificationStamp();
                    fireChanges = resourceModification != collector.getLastModification();
                    jdtEvents = collector.removeAllEvents(resourceModification);
                }
            }
            if (fireChanges) {
                JdtEvent[] jdtEventArray = jdtEvents;
                int n = jdtEvents.length;
                int n2 = 0;
                while (n2 < n) {
                    JdtEvent e = jdtEventArray[n2];
                    this.fireEvent(e);
                    ++n2;
                }
            }
            this.fireEvent(new JdtEvent(this, 11, 0, (IJavaElement)icu));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEventCollectors(IJavaElement element) {
        Object object = this.m_resourceLock;
        synchronized (object) {
            Iterator<Map.Entry<ICompilationUnit, JdtEventCollector>> it = this.m_eventCollectors.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ICompilationUnit, JdtEventCollector> cur = it.next();
                if (!TypeUtility.isAncestor(element, (IJavaElement)cur.getKey())) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void fireEvent(JdtEvent e) {
        IJavaResourceChangedListener listener;
        WeakReference<IJavaResourceChangedListener> ref;
        Iterator<WeakReference<IJavaResourceChangedListener>> it;
        ArrayList<IJavaResourceChangedListener> listeners;
        void object;
        if (this.m_hierarchyCache != null) {
            this.m_hierarchyCache.elementChanged(e);
        }
        IJavaResourceChangedListener[] iJavaResourceChangedListenerArray = (IJavaResourceChangedListener[])this.m_eventListeners.getListeners(IJavaResourceChangedListener.class);
        int n = iJavaResourceChangedListenerArray.length;
        boolean n2 = false;
        while (object < n) {
            IJavaResourceChangedListener l = iJavaResourceChangedListenerArray[object];
            try {
                l.handleEvent(e);
            }
            catch (Exception ex) {
                SdkUtilActivator.logWarning("error during listener notification.", ex);
            }
            ++object;
        }
        if (e.getElementType() == 7) {
            listeners = new ArrayList<IJavaResourceChangedListener>();
            Object object2 = this.m_eventListenerLock;
            synchronized (object2) {
                ArrayList<WeakReference<IJavaResourceChangedListener>> listenerList = this.m_innerTypeChangedListeners.get(e.getDeclaringType());
                if (listenerList != null) {
                    it = listenerList.iterator();
                    while (it.hasNext()) {
                        ref = it.next();
                        listener = (IJavaResourceChangedListener)ref.get();
                        if (listener == null) {
                            it.remove();
                            continue;
                        }
                        listeners.add(listener);
                    }
                    if (listenerList.isEmpty()) {
                        this.m_innerTypeChangedListeners.remove(e.getDeclaringType());
                    }
                }
            }
            for (IJavaResourceChangedListener iJavaResourceChangedListener : listeners) {
                try {
                    iJavaResourceChangedListener.handleEvent(e);
                }
                catch (Exception ex) {
                    SdkUtilActivator.logWarning("error during listener notification.", ex);
                }
            }
        }
        if (e.getElementType() == 9) {
            listeners = new ArrayList();
            Object object3 = this.m_eventListenerLock;
            synchronized (object3) {
                ArrayList<WeakReference<IJavaResourceChangedListener>> listenerList = this.m_methodChangedListeners.get(e.getDeclaringType());
                if (listenerList != null) {
                    it = listenerList.iterator();
                    while (it.hasNext()) {
                        ref = it.next();
                        listener = (IJavaResourceChangedListener)ref.get();
                        if (listener == null) {
                            it.remove();
                            continue;
                        }
                        listeners.add(listener);
                    }
                    if (listenerList.isEmpty()) {
                        this.m_methodChangedListeners.remove(e.getDeclaringType());
                    }
                }
            }
            for (IJavaResourceChangedListener iJavaResourceChangedListener : listeners) {
                try {
                    iJavaResourceChangedListener.handleEvent(e);
                }
                catch (Exception ex) {
                    SdkUtilActivator.logWarning("error during listener notification.", ex);
                }
            }
        }
    }

    private class P_JavaElementChangedListener
    implements IElementChangedListener {
        private P_JavaElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            try {
                this.visitDelta(event, event.getDelta(), event.getType());
            }
            catch (Exception e) {
                SdkUtilActivator.logError(e);
            }
        }

        private void visitDelta(ElementChangedEvent rootEvent, IJavaElementDelta delta, int eventType) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAnnotationDeltas();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta annotationDelta = iJavaElementDeltaArray[n2];
                this.visitDelta(rootEvent, annotationDelta, eventType);
                ++n2;
            }
            if ((delta.getFlags() & 8) != 0) {
                IJavaElementDelta[] childDeltas = delta.getAffectedChildren();
                if (childDeltas != null && childDeltas.length > 0) {
                    int i = 0;
                    while (i < childDeltas.length) {
                        this.visitDelta(rootEvent, childDeltas[i], eventType);
                        ++i;
                    }
                }
            } else {
                JavaResourceChangedEmitter.this.handleJdtDelta(rootEvent, delta);
            }
        }
    }

    private class P_SourceBufferListener
    implements IBufferChangedListener {
        private P_SourceBufferListener() {
        }

        public void bufferChanged(BufferChangedEvent event) {
            IBuffer buffer = event.getBuffer();
            ICompilationUnit icu = (ICompilationUnit)buffer.getOwner();
            if (!buffer.hasUnsavedChanges() && buffer.isClosed()) {
                JavaResourceChangedEmitter.this.releaseEventCollector(icu, icu.isWorkingCopy());
                if (!icu.isWorkingCopy()) {
                    buffer.removeBufferChangedListener(JavaResourceChangedEmitter.this.m_sourceBufferListener);
                }
            }
        }
    }
}

