/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.jdt.finegraned;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.BufferChangedEvent;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.jdt.finegraned.FineGrainedAstAnalyzer;
import org.eclipse.scout.sdk.util.jdt.finegraned.FineGrainedJavaElementDelta;

public class FineGrainedJavaElementDeltaManager {
    private static FineGrainedJavaElementDeltaManager instance = new FineGrainedJavaElementDeltaManager();
    private Object m_cacheLock = new Object();
    private WeakHashMap<IJavaElementDelta, FineGrainedJavaElementDelta[]> m_deltaCache = new WeakHashMap();
    private HashMap<String, String> m_sourceCache = new HashMap();
    private IBufferChangedListener m_bufferListener = new IBufferChangedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bufferChanged(BufferChangedEvent e) {
            if (e.getBuffer().isClosed() && e.getBuffer().getOwner() instanceof ICompilationUnit) {
                ICompilationUnit icu = (ICompilationUnit)e.getBuffer().getOwner();
                Object object = FineGrainedJavaElementDeltaManager.this.m_cacheLock;
                synchronized (object) {
                    String path = icu.getPath().toString();
                    FineGrainedJavaElementDeltaManager.this.m_sourceCache.remove(path);
                }
            }
        }
    };

    public static FineGrainedJavaElementDeltaManager getInstance() {
        return instance;
    }

    private FineGrainedJavaElementDeltaManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FineGrainedJavaElementDelta[] getDelta(IJavaElementDelta delta) {
        FineGrainedJavaElementDelta[] astDeltas;
        Object object = this.m_cacheLock;
        synchronized (object) {
            astDeltas = this.m_deltaCache.get(delta);
            if (astDeltas == null) {
                try {
                    ICompilationUnit icu = (ICompilationUnit)delta.getElement();
                    String path = icu.getPath().toString();
                    String oldContent = this.m_sourceCache.get(path);
                    IFile file = (IFile)icu.getResource();
                    String bufferContent = null;
                    if (file.exists()) {
                        bufferContent = IOUtility.getContent((Reader)new InputStreamReader(file.getContents(true), file.getCharset()));
                    }
                    String newContent = icu.getSource();
                    if (oldContent == null) {
                        oldContent = bufferContent;
                    }
                    if (newContent.equals(bufferContent)) {
                        this.m_sourceCache.remove(path);
                    } else {
                        this.m_sourceCache.put(path, newContent);
                        icu.getBuffer().removeBufferChangedListener(this.m_bufferListener);
                        icu.getBuffer().addBufferChangedListener(this.m_bufferListener);
                    }
                    astDeltas = new FineGrainedAstAnalyzer(delta).calculateDeltas(oldContent, newContent);
                }
                catch (Exception e) {
                    SdkUtilActivator.logWarning(e);
                    astDeltas = new FineGrainedJavaElementDelta[]{};
                }
                this.m_deltaCache.put(delta, astDeltas);
            }
        }
        return astDeltas;
    }
}

