/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.pde;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.product.ProductFeature;
import org.eclipse.pde.internal.core.product.ProductPlugin;
import org.eclipse.scout.sdk.util.pde.LazyProductFileModel;
import org.osgi.framework.Version;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ProductFileModelHelper {
    private final LazyProductFileModel m_model;
    public final ConfigurationFilePart ConfigurationFile;
    public final ProductFilePart ProductFile;

    public ProductFileModelHelper(IProject project, IPath projRelPathToProduct) throws CoreException {
        this(project.getFile(projRelPathToProduct));
    }

    public ProductFileModelHelper(IProject project, String projRelPathToProduct) throws CoreException {
        this(project.getFile(projRelPathToProduct));
    }

    public ProductFileModelHelper(IFile productFile) throws CoreException {
        this.m_model = new LazyProductFileModel(productFile);
        this.ConfigurationFile = new ConfigurationFilePart(this.m_model);
        this.ProductFile = new ProductFilePart(this.m_model);
    }

    public void save() throws CoreException {
        this.m_model.save();
    }

    public static class ConfigurationFilePart {
        private final LazyProductFileModel m_model;

        private ConfigurationFilePart(LazyProductFileModel model) {
            this.m_model = model;
        }

        public String getEntry(String key) throws CoreException {
            return this.m_model.getConfigFileProperties().getProperty(key);
        }

        public boolean existsEntry(String key) throws CoreException {
            return this.m_model.getConfigFileProperties().containsProperty(key);
        }

        public void setEntry(String key, String value) throws CoreException {
            this.m_model.getConfigFileProperties().setProperty(key, value);
        }

        public void removeEntry(String key) throws CoreException {
            this.m_model.getConfigFileProperties().removeProperty(key);
        }

        public String getOsgiBundlesEntry() throws CoreException {
            return this.getEntry("osgi.bundles");
        }

        public void setOsgiBundlesEntry(String value) throws CoreException {
            this.setEntry("osgi.bundles", value);
        }

        public IFile getFile() throws CoreException {
            return this.m_model.getConfigIniFile();
        }

        public Map<String, String> getEntries() throws CoreException {
            return this.m_model.getConfigFileProperties().getEntries();
        }
    }

    public static enum DependencyType {
        Plugin,
        Fragment,
        Feature;

    }

    private static class P_ProductPlugin
    extends ProductPlugin {
        private static final long serialVersionUID = 1L;
        private boolean m_fragment;

        private P_ProductPlugin(IProductModel model, String id) {
            this(model, id, false);
        }

        private P_ProductPlugin(IProductModel model, String id, boolean isFragment) {
            super(model);
            this.m_fragment = isFragment;
            this.setId(id);
        }

        public void parse(Node node) {
            super.parse(node);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                this.setFragment(Boolean.parseBoolean(element.getAttribute("fragment")));
            }
        }

        public void write(String indent, PrintWriter writer) {
            writer.print(String.valueOf(indent) + "<plugin id=\"" + this.getId() + "\"");
            if (this.getVersion() != null && this.getVersion().length() > 0 && !"0.0.0".equals(this.getVersion())) {
                writer.print(" version=\"" + this.getVersion() + "\"");
            }
            IPluginModelBase modBase = PluginRegistry.findModel((String)this.getId());
            if (this.isFragment() || modBase != null && modBase.isFragmentModel()) {
                writer.print(" fragment=\"true\"");
            }
            writer.println("/>");
        }

        public boolean isFragment() {
            return this.m_fragment;
        }

        public void setFragment(boolean isFragment) {
            this.m_fragment = isFragment;
        }
    }

    public static class ProductFilePart {
        private final LazyProductFileModel m_model;

        private ProductFilePart(LazyProductFileModel model) {
            this.m_model = model;
        }

        public void addDependency(String pluginId) throws CoreException {
            this.addDependency(pluginId, DependencyType.Plugin);
        }

        public synchronized void addDependency(String id, DependencyType type) throws CoreException {
            if (!this.existsDependency(id)) {
                if (DependencyType.Feature.equals((Object)type)) {
                    ProductFeature pf = this.createFeature(id);
                    this.m_model.getWorkspaceProductModel().getProduct().addFeatures(new IProductFeature[]{pf});
                } else {
                    P_ProductPlugin newPlugin = this.createPlugin(id, DependencyType.Fragment.equals((Object)type));
                    this.m_model.getWorkspaceProductModel().getProduct().addPlugins(new IProductPlugin[]{newPlugin});
                }
            }
        }

        private ProductFeature createFeature(String id) throws CoreException {
            ProductFeature pf = new ProductFeature((IProductModel)this.m_model.getWorkspaceProductModel());
            pf.setId(id);
            return pf;
        }

        private P_ProductPlugin createPlugin(String pluginId, boolean isFragment) throws CoreException {
            return new P_ProductPlugin((IProductModel)this.m_model.getWorkspaceProductModel(), pluginId, isFragment);
        }

        public boolean existsDependency(String pluginOrFeatureId) throws CoreException {
            IProductPlugin[] iProductPluginArray = this.m_model.getWorkspaceProductModel().getProduct().getPlugins();
            int n = iProductPluginArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProductPlugin p = iProductPluginArray[n2];
                if (p.getId().equals(pluginOrFeatureId)) {
                    return true;
                }
                ++n2;
            }
            IProductFeature[] features = this.m_model.getWorkspaceProductModel().getProduct().getFeatures();
            if (features != null && features.length > 0) {
                IProductFeature[] iProductFeatureArray = features;
                int n3 = features.length;
                n = 0;
                while (n < n3) {
                    IProductFeature feature = iProductFeatureArray[n];
                    if (feature.getId().equals(pluginOrFeatureId)) {
                        return true;
                    }
                    ++n;
                }
                Map<String, ? extends Set<String>> allBundlesInFeatures = this.getBundlesInFeatures();
                IProductFeature[] iProductFeatureArray2 = features;
                int n4 = features.length;
                n3 = 0;
                while (n3 < n4) {
                    IProductFeature f = iProductFeatureArray2[n3];
                    Set<String> bundlesInCurrentFeature = allBundlesInFeatures.get(f.getId());
                    if (bundlesInCurrentFeature != null && bundlesInCurrentFeature.contains(pluginOrFeatureId)) {
                        return true;
                    }
                    ++n3;
                }
            }
            return false;
        }

        private Map<String, ? extends Set<String>> getBundlesInFeatures() {
            IFeatureModel[] features = PDECore.getDefault().getFeatureModelManager().getModels();
            HashMap<String, HashSet<String>> allBundlesInFeatures = new HashMap<String, HashSet<String>>(features.length);
            IFeatureModel[] iFeatureModelArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureModel feature = iFeatureModelArray[n2];
                IFeaturePlugin[] iFeaturePluginArray = feature.getFeature().getPlugins();
                int n3 = iFeaturePluginArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFeaturePlugin bundle = iFeaturePluginArray[n4];
                    HashSet<String> bundlesInFeature = (HashSet<String>)allBundlesInFeatures.get(feature.getFeature().getId());
                    if (bundlesInFeature == null) {
                        bundlesInFeature = new HashSet<String>();
                        allBundlesInFeatures.put(feature.getFeature().getId(), bundlesInFeature);
                    }
                    bundlesInFeature.add(bundle.getId());
                    ++n4;
                }
                ++n2;
            }
            return allBundlesInFeatures;
        }

        public void removeDependency(String id) throws CoreException {
            this.m_model.getWorkspaceProductModel().getProduct().removePlugins(new IProductPlugin[]{this.createPlugin(id, false)});
            this.m_model.getWorkspaceProductModel().getProduct().removeFeatures(new IProductFeature[]{this.createFeature(id)});
        }

        public boolean isValid() throws CoreException {
            return this.m_model.getWorkspaceProductModel().isValid();
        }

        public BundleDescription[] getPluginModels() throws CoreException {
            ArrayList<BundleDescription> list = new ArrayList<BundleDescription>();
            State state = TargetPlatformHelper.getState();
            IProductPlugin[] plugins = this.m_model.getWorkspaceProductModel().getProduct().getPlugins();
            int i = 0;
            while (i < plugins.length) {
                BundleDescription bundle = null;
                String v = plugins[i].getVersion();
                if (v != null && v.length() > 0) {
                    bundle = state.getBundle(plugins[i].getId(), Version.parseVersion((String)v));
                }
                if (bundle == null) {
                    bundle = state.getBundle(plugins[i].getId(), null);
                }
                if (bundle != null) {
                    list.add(bundle);
                }
                ++i;
            }
            return list.toArray(new BundleDescription[list.size()]);
        }

        public String[] getPluginSymbolicNames() throws CoreException {
            IProductPlugin[] plugins = this.m_model.getWorkspaceProductModel().getProduct().getPlugins();
            String[] result = new String[plugins.length];
            int i = 0;
            while (i < result.length) {
                result[i] = plugins[i].getId();
                ++i;
            }
            return result;
        }

        public IProduct getProduct() throws CoreException {
            return this.m_model.getWorkspaceProductModel().getProduct();
        }
    }
}

