/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.signature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.IRegEx;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.ITypeGenericMapping;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.signature.internal.TypeGenericMapping;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public final class SignatureUtility {
    private static final Pattern QUALIFIED_SIG_REGEX = Pattern.compile("^([\\+\\[]*)([^\\<\\(\\;]*)(.*)$");
    private static final Pattern SIG_REPLACEMENT_REGEX = Pattern.compile("[\\.\\$]{1}");
    private static final Pattern PARAM_SIG_REPLACEMENT_REGEX = Pattern.compile("^([^\\:]*)\\:(.*)$");
    private static final Pattern SIG_END = Pattern.compile("(^.*)\\;$");
    public static final char C_ARBITRARY_ARRAY = '|';
    public static final int ARBITRARY_ARRAY_SIGNATURE = 29;

    private SignatureUtility() {
    }

    public static String unboxPrimitiveSignature(String signature) {
        if (Signature.getTypeSignatureKind((String)signature) == 2) {
            if ("Z".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Boolean.class.getName());
            } else if ("B".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Byte.class.getName());
            } else if ("C".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Character.class.getName());
            } else if ("D".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Double.class.getName());
            } else if ("F".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Float.class.getName());
            } else if ("I".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Integer.class.getName());
            } else if ("J".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Long.class.getName());
            } else if ("S".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Short.class.getName());
            }
        }
        return signature;
    }

    public static int getTypeSignatureKind(String signature) {
        if (signature == null || signature.length() < 1) {
            throw new IllegalArgumentException("signature is null or less than 1 char.");
        }
        char c = signature.charAt(0);
        if (c == '|') {
            return 29;
        }
        return Signature.getTypeSignatureKind((String)signature);
    }

    private static String quoteRegexSpecialCharacters(String input) {
        input = input.replace("\\", "\\\\");
        input = input.replace(".", "\\.");
        input = input.replace("+", "\\+");
        input = input.replace("?", "\\?");
        input = input.replace("^", "\\^");
        input = input.replace("$", "\\$");
        input = input.replace("[", "\\[");
        input = input.replace("]", "\\]");
        input = input.replace("(", "\\(");
        input = input.replace(")", "\\)");
        input = input.replace("{", "\\{");
        input = input.replace("}", "\\}");
        input = input.replace("*", "\\*");
        input = input.replace("|", "\\|");
        return input;
    }

    public static String getResolvedSignature(String signature, IType signatureOwner) throws CoreException {
        return SignatureUtility.getResolvedSignature(signature, signatureOwner, null);
    }

    private static boolean endsWith(String stringToSearchIn, char charToFind) {
        return stringToSearchIn != null && !stringToSearchIn.isEmpty() && stringToSearchIn.charAt(stringToSearchIn.length() - 1) == charToFind;
    }

    private static boolean startsWith(String stringToSearchIn, char charToFind) {
        return stringToSearchIn != null && !stringToSearchIn.isEmpty() && stringToSearchIn.charAt(0) == charToFind;
    }

    public static String getResolvedSignature(String signature, IType signatureOwner, IType contextType) throws CoreException {
        Map<Object, Object> genericParameters = null;
        if (TypeUtility.exists((IJavaElement)contextType) && TypeUtility.exists((IJavaElement)signatureOwner)) {
            LinkedHashMap<String, ITypeGenericMapping> collector = new LinkedHashMap<String, ITypeGenericMapping>();
            SignatureUtility.resolveGenericParametersInSuperHierarchy(contextType, new String[0], contextType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()), collector);
            ITypeGenericMapping mapping = collector.get(signatureOwner.getFullyQualifiedName());
            if (mapping != null) {
                genericParameters = mapping.getParameters();
            }
        }
        if (genericParameters == null) {
            genericParameters = new HashMap(0);
        }
        return SignatureUtility.getResolvedSignature(signatureOwner, genericParameters, signature);
    }

    public static boolean isEqualSignature(String signature1, String signature2) {
        if (signature1 == null && signature2 == null) {
            return true;
        }
        if (signature1 == null || signature2 == null) {
            return false;
        }
        signature1 = IRegEx.DOLLAR_REPLACEMENT.matcher(signature1).replaceAll(".");
        signature2 = IRegEx.DOLLAR_REPLACEMENT.matcher(signature2).replaceAll(".");
        return signature1.equals(signature2);
    }

    public static String getTypeReferenceFromFqn(String fullyQualifiedTypeName, IImportValidator importValidator) throws CoreException {
        return SignatureUtility.getTypeReference(SignatureCache.createTypeSignature(fullyQualifiedTypeName), importValidator);
    }

    public static String getTypeReference(String signature, IImportValidator importValidator) throws CoreException {
        return SignatureUtility.getTypeReference(signature, null, null, importValidator);
    }

    public static String getTypeReference(String signature, IType signatureOwner, IImportValidator validator) throws CoreException {
        return SignatureUtility.getTypeReference(signature, signatureOwner, null, validator);
    }

    private static String getTypeReference(String signature, IType signatureOwner, IType contextType, IImportValidator validator) throws CoreException {
        StringBuilder sigBuilder = new StringBuilder();
        int arrayCount = 0;
        boolean isArbitraryArray = false;
        switch (SignatureUtility.getTypeSignatureKind(signature)) {
            case 5: {
                sigBuilder.append("?");
                if (signature.length() <= 1) break;
                sigBuilder.append(" extends ");
                sigBuilder.append(SignatureUtility.getTypeReference(signature.substring(1), signatureOwner, contextType, validator));
                break;
            }
            case 4: {
                arrayCount = Signature.getArrayCount((String)signature);
                sigBuilder.append(SignatureUtility.getTypeReference(signature.substring(arrayCount), signatureOwner, contextType, validator));
                break;
            }
            case 29: {
                isArbitraryArray = true;
                sigBuilder.append(SignatureUtility.getTypeReference(signature.substring(1), signatureOwner, contextType, validator));
                break;
            }
            case 2: {
                sigBuilder.append(Signature.getSignatureSimpleName((String)signature));
                break;
            }
            case 3: {
                String sig = SignatureUtility.findTypeParameterSignature(signature, signatureOwner, contextType);
                if (CompareUtility.equals((Object)sig, (Object)signature)) {
                    sigBuilder.append(sig);
                    break;
                }
                sigBuilder.append(SignatureUtility.getTypeReference(sig, signatureOwner, contextType, validator));
                break;
            }
            default: {
                String[] typeArguments = Signature.getTypeArguments((String)signature);
                signature = Signature.getTypeErasure((String)signature);
                signature = SIG_REPLACEMENT_REGEX.matcher(signature).replaceAll(".");
                if (SignatureUtility.startsWith(signature, 'Q')) {
                    if (signatureOwner != null) {
                        String simpleName = Signature.getSignatureSimpleName((String)signature);
                        String referencedTypeSignature = SignatureUtility.getReferencedTypeSignature(signatureOwner, simpleName, false);
                        if (referencedTypeSignature != null) {
                            sigBuilder.append(validator.getTypeName(referencedTypeSignature));
                        }
                    } else {
                        sigBuilder.append(Signature.toString((String)signature));
                    }
                } else {
                    sigBuilder.append(validator.getTypeName(signature));
                }
                if (typeArguments == null || typeArguments.length <= 0) break;
                sigBuilder.append('<');
                int i = 0;
                while (i < typeArguments.length) {
                    if (i > 0) {
                        sigBuilder.append(", ");
                    }
                    sigBuilder.append(SignatureUtility.getTypeReference(typeArguments[i], signatureOwner, contextType, validator));
                    ++i;
                }
                sigBuilder.append('>');
            }
        }
        int i = 0;
        while (i < arrayCount) {
            sigBuilder.append("[]");
            ++i;
        }
        if (isArbitraryArray) {
            sigBuilder.append("...");
        }
        return sigBuilder.toString();
    }

    public static String[] getMethodParameterSignatureResolved(IMethod method) throws CoreException {
        return SignatureUtility.getMethodParameterSignatureResolved(method, method.getDeclaringType());
    }

    public static String[] getMethodParameterSignatureResolved(IMethod jdtMethod, IType contextType) throws CoreException {
        LinkedHashMap<String, ITypeGenericMapping> genericMapperCollector = new LinkedHashMap<String, ITypeGenericMapping>();
        SignatureUtility.resolveGenericParametersInSuperHierarchy(contextType, new String[0], contextType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()), genericMapperCollector);
        ITypeGenericMapping mapping = genericMapperCollector.get(jdtMethod.getDeclaringType().getFullyQualifiedName());
        Map<String, String> parameters = null;
        parameters = mapping != null ? mapping.getParameters() : new HashMap<String, String>(0);
        return SignatureUtility.getMethodParameterSignatureResolved(jdtMethod, parameters);
    }

    public static String[] getMethodParameterSignatureResolved(IMethod jdtMethod, Map<String, String> generics) throws CoreException {
        String[] methodParameterSignature = SignatureUtility.getMethodParameterSignature(jdtMethod);
        IType methodOwnerType = jdtMethod.getDeclaringType();
        int i = 0;
        while (i < methodParameterSignature.length) {
            methodParameterSignature[i] = SignatureUtility.getResolvedSignature(methodOwnerType, generics, methodParameterSignature[i]);
            ++i;
        }
        return methodParameterSignature;
    }

    public static String[] getMethodParameterSignature(IMethod method) throws JavaModelException {
        String[] paramNames = method.getParameterNames();
        String[] paramSignatures = Arrays.copyOf(method.getParameterTypes(), method.getParameterTypes().length);
        if (paramSignatures != null && paramSignatures.length > 0) {
            String regex;
            String source;
            String lastSig = paramSignatures[paramSignatures.length - 1];
            String lastParamName = paramNames[paramNames.length - 1];
            if (Signature.getTypeSignatureKind((String)lastSig) == 4 && (source = method.getSource()) != null && Pattern.compile(regex = String.valueOf(method.getElementName()) + "\\s*\\(.*([\\.]{3})\\s*" + lastParamName + "\\s*\\)", 8).matcher(source).find()) {
                paramSignatures[paramSignatures.length - 1] = lastSig.replaceFirst("^\\[", "|");
            }
        }
        return paramSignatures;
    }

    public static String getReturnTypeSignatureResolved(IMethod method, IType contextType) throws CoreException {
        String returnTypeSignature = method.getReturnType();
        IType methodDeclaringType = method.getDeclaringType();
        returnTypeSignature = SignatureUtility.getResolvedSignature(returnTypeSignature, methodDeclaringType, contextType);
        return returnTypeSignature;
    }

    private static String ensureSourceTypeParametersAreCorrect(String signature, IType signatureOwner) throws JavaModelException {
        if (!TypeUtility.exists((IJavaElement)signatureOwner) || signatureOwner.isBinary()) {
            return signature;
        }
        ITypeParameter[] typeParameters = signatureOwner.getTypeParameters();
        if (typeParameters != null && typeParameters.length > 0) {
            ITypeParameter[] iTypeParameterArray = typeParameters;
            int n = typeParameters.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeParameter tp = iTypeParameterArray[n2];
                if (CompareUtility.equals((Object)tp.getElementName(), (Object)Signature.getSignatureSimpleName((String)signature))) {
                    return 'T' + tp.getElementName() + ';';
                }
                ++n2;
            }
        }
        return signature;
    }

    public static String getMethodIdentifier(IMethod method) throws CoreException {
        StringBuilder methodIdBuilder = new StringBuilder();
        methodIdBuilder.append(method.getElementName());
        methodIdBuilder.append("(");
        String[] resolvedParamSignatures = SignatureUtility.getMethodParameterSignatureResolved(method, method.getDeclaringType());
        int i = 0;
        while (i < resolvedParamSignatures.length) {
            methodIdBuilder.append(resolvedParamSignatures[i]);
            if (i + 1 < resolvedParamSignatures.length) {
                methodIdBuilder.append(",");
            }
            ++i;
        }
        methodIdBuilder.append(")");
        return methodIdBuilder.toString();
    }

    private static String findTypeParameterSignature(String typeParameterSignature, IType signatureOwner, IType contextType) throws CoreException {
        if (!TypeUtility.exists((IJavaElement)contextType) || !TypeUtility.exists((IJavaElement)signatureOwner)) {
            return typeParameterSignature;
        }
        String paramTypeName = Signature.getSignatureSimpleName((String)typeParameterSignature);
        ArrayList<IType> hierarchyList = new ArrayList<IType>();
        if (contextType != null) {
            ITypeHierarchy superTypeHierarchy = contextType.newSupertypeHierarchy(null);
            IType visitorType = contextType;
            while (visitorType != null && !visitorType.equals(signatureOwner)) {
                hierarchyList.add(0, visitorType);
                visitorType = superTypeHierarchy.getSuperclass(visitorType);
            }
        }
        String[] ownerParameterSignatures = signatureOwner.getTypeParameterSignatures();
        int parameterIndex = -1;
        int i = 0;
        while (i < ownerParameterSignatures.length) {
            String paramSig = ownerParameterSignatures[i];
            String paramName = PARAM_SIG_REPLACEMENT_REGEX.matcher(paramSig).replaceAll("$1");
            paramSig = PARAM_SIG_REPLACEMENT_REGEX.matcher(paramSig).replaceAll("$2");
            if (contextType == null) {
                String signature = SignatureUtility.getResolvedSignature(paramSig, signatureOwner, null);
                return signature;
            }
            if (paramTypeName.equals(paramName)) {
                parameterIndex = i;
                break;
            }
            ++i;
        }
        if (parameterIndex < 0) {
            return SignatureCache.createTypeSignature(Object.class.getName());
        }
        Iterator iterator = hierarchyList.iterator();
        if (iterator.hasNext()) {
            IType hType = (IType)iterator.next();
            String superClassSignature = hType.getSuperclassTypeSignature();
            if (StringUtility.isNullOrEmpty((String)superClassSignature)) {
                return SignatureCache.createTypeSignature(Object.class.getName());
            }
            String[] superClassParameterSignatures = Signature.getTypeArguments((String)superClassSignature);
            if (superClassParameterSignatures.length < parameterIndex + 1) {
                return SignatureCache.createTypeSignature(Object.class.getName());
            }
            String signature = SignatureUtility.getResolvedSignature(superClassParameterSignatures[parameterIndex], hType, contextType);
            return signature;
        }
        return typeParameterSignature;
    }

    public static String getFullyQualifiedName(String signature) {
        int arrayCount = Signature.getArrayCount((String)(signature = Signature.getTypeErasure((String)signature)));
        if (arrayCount > 0) {
            signature = signature.substring(arrayCount);
        }
        String fqn = Signature.toString((String)signature);
        return fqn;
    }

    public static boolean isGenericSignature(String sig) {
        String[] params = Signature.getTypeArguments((String)sig);
        return params != null && params.length > 0;
    }

    public static String getQualifiedSignature(String signature, IType jdtType) throws JavaModelException {
        if (SignatureUtility.getTypeSignatureKind(signature) == 2) {
            return signature;
        }
        Matcher m = QUALIFIED_SIG_REGEX.matcher(signature);
        if (m.find()) {
            String[] typeArguments;
            String simpleName;
            String referencedTypeSignature;
            String prefix = m.group(1);
            String simpleSignature = m.group(2);
            String postfix = m.group(3);
            if (SignatureUtility.startsWith(simpleSignature, 'Q') && (referencedTypeSignature = SignatureUtility.getReferencedTypeSignature(jdtType, simpleName = Signature.getSignatureSimpleName((String)(String.valueOf(simpleSignature) + ';')), false)) != null) {
                simpleSignature = SIG_END.matcher(referencedTypeSignature).replaceAll("$1");
                signature = String.valueOf(prefix) + simpleSignature + postfix;
            }
            String[] stringArray = typeArguments = Signature.getTypeArguments((String)signature);
            int n = typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                String typeArg = stringArray[n2];
                signature.replaceFirst("^([^<]*\\<.*)(" + SignatureUtility.quoteRegexSpecialCharacters(typeArg) + ")(.*)$", "$1" + SignatureUtility.getQualifiedSignature(typeArg, jdtType) + "$3");
                ++n2;
            }
        } else {
            SdkUtilActivator.logWarning("could not qualify types of signature '" + signature + "'");
        }
        return signature;
    }

    public static void resolveGenericParametersInSuperHierarchy(String signature, String superTypeSignature, String[] interfaceSignatures, LinkedHashMap<String, ITypeGenericMapping> collector) throws CoreException {
        SignatureUtility.resolveGenericParametersInSuperHierarchy(signature, new String[0], superTypeSignature, interfaceSignatures, collector);
    }

    private static void resolveGenericParametersInSuperHierarchy(String signature, String[] parameterSignatures, String superTypeSignature, String[] interfaceSignatures, LinkedHashMap<String, ITypeGenericMapping> collector) throws CoreException {
        TypeGenericMapping typeDesc = new TypeGenericMapping(String.valueOf(Signature.getSignatureQualifier((String)signature)) + "." + Signature.getSignatureSimpleName((String)signature));
        String[] localParameterSignatures = Signature.getTypeParameters((String)signature);
        if (localParameterSignatures.length > 0) {
            int i = 0;
            while (i < localParameterSignatures.length) {
                typeDesc.addParameter(Signature.getSignatureSimpleName((String)localParameterSignatures[i]), parameterSignatures[i]);
                ++i;
            }
        }
        collector.put(typeDesc.getFullyQualifiedName(), typeDesc);
        if (superTypeSignature != null) {
            String[] superTypeParameterSignatures = new String[]{};
            IType superType = TypeUtility.getTypeBySignature(superTypeSignature);
            if (TypeUtility.exists((IJavaElement)superType)) {
                String[] typeParameters = Signature.getTypeArguments((String)superTypeSignature);
                superTypeParameterSignatures = new String[typeParameters.length];
                int i = 0;
                while (i < typeParameters.length) {
                    superTypeParameterSignatures[i] = Signature.getTypeSignatureKind((String)typeParameters[i]) == 3 ? typeDesc.getParameterSignature(Signature.getSignatureSimpleName((String)typeParameters[i])) : typeParameters[i];
                    ++i;
                }
                SignatureUtility.resolveGenericParametersInSuperHierarchy(superType, superTypeParameterSignatures, superType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()), collector);
            }
        }
        if (interfaceSignatures != null) {
            String[] stringArray = interfaceSignatures;
            int n = interfaceSignatures.length;
            int n2 = 0;
            while (n2 < n) {
                String interfaceSignature = stringArray[n2];
                IType interfaceType = TypeUtility.getTypeBySignature(interfaceSignature);
                if (TypeUtility.exists((IJavaElement)interfaceType)) {
                    String[] typeParameters = Signature.getTypeParameters((String)interfaceSignature);
                    String[] intefaceTypeParameterSignatures = new String[typeParameters.length];
                    int i = 0;
                    while (i < typeParameters.length) {
                        if (Signature.getTypeSignatureKind((String)typeParameters[i]) == 3) {
                            intefaceTypeParameterSignatures[i] = typeDesc.getParameterSignature(Signature.getSignatureSimpleName((String)typeParameters[i]));
                        }
                        ++i;
                    }
                    SignatureUtility.resolveGenericParametersInSuperHierarchy(interfaceType, intefaceTypeParameterSignatures, interfaceType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()), collector);
                }
                ++n2;
            }
        }
    }

    public static String resolveGenericParameterInSuperHierarchy(IType startType, ITypeHierarchy superHierarchy, String genericDefiningSuperTypeFqn, String paramName) throws CoreException {
        LinkedHashMap<String, ITypeGenericMapping> collector = new LinkedHashMap<String, ITypeGenericMapping>();
        SignatureUtility.resolveGenericParametersInSuperHierarchy(startType, new String[0], superHierarchy, collector);
        ITypeGenericMapping genericMapping = collector.get(genericDefiningSuperTypeFqn);
        if (genericMapping != null) {
            return genericMapping.getParameterSignature(paramName);
        }
        return null;
    }

    public static void resolveGenericParametersInSuperHierarchy(IType type, ITypeHierarchy hierarchy, LinkedHashMap<String, ITypeGenericMapping> collector) throws CoreException {
        SignatureUtility.resolveGenericParametersInSuperHierarchy(type, new String[0], hierarchy, collector);
    }

    private static void resolveGenericParametersInSuperHierarchy(IType type, String[] parameterSignatures, ITypeHierarchy hierarchy, LinkedHashMap<String, ITypeGenericMapping> collector) throws CoreException {
        String[] superInterfaceTypeSignatures;
        String superclassTypeSignature;
        if (!TypeUtility.exists((IJavaElement)type)) {
            return;
        }
        TypeGenericMapping typeDesc = new TypeGenericMapping(type.getFullyQualifiedName());
        ITypeParameter[] typeParameters = type.getTypeParameters();
        HashMap<String, String> paramsUnresolved = new HashMap<String, String>(typeParameters.length);
        ITypeParameter[] iTypeParameterArray = typeParameters;
        int n = typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeParameter par = iTypeParameterArray[n2];
            String[] boundsSignatures = par.getBoundsSignatures();
            if (boundsSignatures != null && boundsSignatures.length > 0) {
                paramsUnresolved.put(par.getElementName(), par.getBoundsSignatures()[0]);
            }
            ++n2;
        }
        int i = 0;
        while (i < typeParameters.length) {
            if (parameterSignatures.length > i) {
                typeDesc.addParameter(typeParameters[i].getElementName(), parameterSignatures[i]);
            } else {
                String[] boundsSignatures = typeParameters[i].getBoundsSignatures();
                if (boundsSignatures != null && boundsSignatures.length > 0) {
                    typeDesc.addParameter(typeParameters[i].getElementName(), SignatureUtility.getResolvedSignature(type, paramsUnresolved, boundsSignatures[0]));
                } else {
                    typeDesc.addParameter(typeParameters[i].getElementName(), SignatureCache.createTypeSignature(Object.class.getName()));
                }
            }
            ++i;
        }
        collector.put(typeDesc.getFullyQualifiedName(), typeDesc);
        if (!Flags.isInterface((int)type.getFlags()) && StringUtility.hasText((String)(superclassTypeSignature = type.getSuperclassTypeSignature()))) {
            String[] superParameterSigs = Signature.getTypeArguments((String)superclassTypeSignature);
            String[] superclassParameterSignatures = new String[superParameterSigs.length];
            int i2 = 0;
            while (i2 < superclassParameterSignatures.length) {
                String resolvedSignature = SignatureUtility.getResolvedSignature(type, typeDesc.getParameters(), superParameterSigs[i2]);
                String signatureQualifier = Signature.getSignatureQualifier((String)resolvedSignature);
                String signatureSimpleName = Signature.getSignatureSimpleName((String)resolvedSignature);
                if (StringUtility.isNullOrEmpty((String)signatureQualifier) && typeDesc.getParameterSignature(signatureSimpleName) != null) {
                    resolvedSignature = typeDesc.getParameterSignature(signatureSimpleName);
                }
                superclassParameterSignatures[i2] = resolvedSignature;
                ++i2;
            }
            SignatureUtility.resolveGenericParametersInSuperHierarchy(hierarchy.getSuperclass(type), superclassParameterSignatures, hierarchy, collector);
        }
        String[] stringArray = superInterfaceTypeSignatures = type.getSuperInterfaceTypeSignatures();
        int n3 = superInterfaceTypeSignatures.length;
        n = 0;
        while (n < n3) {
            String superInterfaceTypeSignature = stringArray[n];
            String[] interfaceParameterSigs = Signature.getTypeArguments((String)superInterfaceTypeSignature);
            String[] interfaceParameterSignatures = new String[interfaceParameterSigs.length];
            int i3 = 0;
            while (i3 < interfaceParameterSignatures.length) {
                String resolvedSignature = SignatureUtility.getResolvedSignature(type, typeDesc.getParameters(), interfaceParameterSigs[i3]);
                String signatureQualifier = Signature.getSignatureQualifier((String)resolvedSignature);
                String signatureSimpleName = Signature.getSignatureSimpleName((String)resolvedSignature);
                if (StringUtility.isNullOrEmpty((String)signatureQualifier) && typeDesc.getParameterSignature(signatureSimpleName) != null) {
                    resolvedSignature = typeDesc.getParameterSignature(signatureSimpleName);
                }
                interfaceParameterSignatures[i3] = resolvedSignature;
                ++i3;
            }
            SignatureUtility.resolveGenericParametersInSuperHierarchy(TypeUtility.getTypeBySignature(superInterfaceTypeSignature), interfaceParameterSignatures, hierarchy, collector);
            ++n;
        }
    }

    public static String getResolvedSignature(IType contextType, Map<String, String> parameterSignatures, String unresolvedSignature) throws JavaModelException {
        StringBuilder sigBuilder = new StringBuilder();
        unresolvedSignature = SignatureUtility.ensureSourceTypeParametersAreCorrect(unresolvedSignature, contextType);
        switch (SignatureUtility.getTypeSignatureKind(unresolvedSignature)) {
            case 5: {
                sigBuilder.append(unresolvedSignature.charAt(0));
                if (unresolvedSignature.length() <= 1) break;
                sigBuilder.append(SignatureUtility.getResolvedSignature(contextType, parameterSignatures, unresolvedSignature.substring(1)));
                break;
            }
            case 4: {
                sigBuilder.append('[');
                sigBuilder.append(SignatureUtility.getResolvedSignature(contextType, parameterSignatures, unresolvedSignature.substring(1)));
                break;
            }
            case 29: {
                sigBuilder.append('|');
                sigBuilder.append(SignatureUtility.getResolvedSignature(contextType, parameterSignatures, unresolvedSignature.substring(1)));
                break;
            }
            case 2: {
                if (SignatureUtility.endsWith(unresolvedSignature, ';')) {
                    unresolvedSignature = unresolvedSignature.substring(0, unresolvedSignature.length() - 1);
                }
                sigBuilder.append(unresolvedSignature);
                break;
            }
            case 3: {
                String simpleName;
                String referencedTypeSignature;
                String sig = parameterSignatures.get(Signature.getSignatureSimpleName((String)unresolvedSignature));
                if (SignatureUtility.startsWith(sig, 'Q') && TypeUtility.exists((IJavaElement)contextType) && (referencedTypeSignature = SignatureUtility.getReferencedTypeSignature(contextType, simpleName = Signature.getSignatureSimpleName((String)sig), false)) != null) {
                    sig = referencedTypeSignature;
                }
                sigBuilder.append(sig);
                break;
            }
            case 1: {
                String[] typeArguments = Signature.getTypeArguments((String)unresolvedSignature);
                unresolvedSignature = Signature.getTypeErasure((String)unresolvedSignature);
                unresolvedSignature = SIG_REPLACEMENT_REGEX.matcher(unresolvedSignature).replaceAll(".");
                if (SignatureUtility.startsWith(unresolvedSignature, 'Q')) {
                    String simpleName;
                    String referencedTypeSignature;
                    if (StringUtility.hasText((String)Signature.getSignatureQualifier((String)unresolvedSignature))) {
                        IType t = TypeUtility.getTypeBySignature(unresolvedSignature);
                        if (TypeUtility.exists((IJavaElement)t)) {
                            unresolvedSignature = SignatureCache.createTypeSignature(t.getFullyQualifiedName().replace('$', '.'));
                        }
                    } else if (TypeUtility.exists((IJavaElement)contextType) && (referencedTypeSignature = SignatureUtility.getReferencedTypeSignature(contextType, simpleName = Signature.getSignatureSimpleName((String)unresolvedSignature), false)) != null) {
                        unresolvedSignature = referencedTypeSignature;
                    }
                }
                if (SignatureUtility.endsWith(unresolvedSignature, ';')) {
                    unresolvedSignature = unresolvedSignature.substring(0, unresolvedSignature.length() - 1);
                }
                sigBuilder.append(unresolvedSignature);
                if (typeArguments != null && typeArguments.length > 0) {
                    sigBuilder.append('<');
                    int i = 0;
                    while (i < typeArguments.length) {
                        sigBuilder.append(SignatureUtility.getResolvedSignature(contextType, parameterSignatures, typeArguments[i]));
                        ++i;
                    }
                    sigBuilder.append('>');
                }
                sigBuilder.append(';');
                break;
            }
            default: {
                SdkUtilActivator.logWarning("unhandled signature type: '" + Signature.getTypeSignatureKind((String)unresolvedSignature) + "'");
            }
        }
        return sigBuilder.toString();
    }

    public static String getReferencedTypeSignature(IType declaringType, String typeName, boolean searchOnClassPath) throws JavaModelException {
        String referencedTypeFqn = TypeUtility.getReferencedTypeFqn(declaringType, typeName, searchOnClassPath);
        if (referencedTypeFqn != null) {
            return SignatureCache.createTypeSignature(referencedTypeFqn);
        }
        return null;
    }
}

