/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.type;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ast.AstUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.internal.typecache.HierarchyCache;
import org.eclipse.scout.sdk.util.internal.typecache.TypeCache;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.FieldFilters;
import org.eclipse.scout.sdk.util.type.IFieldFilter;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.IPropertyBean;
import org.eclipse.scout.sdk.util.type.IPropertyBeanFilter;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.MethodFilters;
import org.eclipse.scout.sdk.util.type.MethodParameter;
import org.eclipse.scout.sdk.util.type.PropertyBean;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;

public class TypeUtility {
    public static final String DEFAULT_SOURCE_FOLDER_NAME = "src";
    public static final Pattern BEAN_METHOD_NAME = Pattern.compile("(get|set|is)([A-Z].*)");

    protected TypeUtility() {
    }

    public static IType getType(String typeName) {
        return TypeCache.getInstance().getType(typeName);
    }

    public static IType[] getTypes(String typeName) {
        return TypeCache.getInstance().getTypes(typeName);
    }

    public static IType getType(String typeName, IJavaProject classpath) {
        return TypeCache.getInstance().getType(typeName, classpath);
    }

    public static IType[] getTypes(String typeName, IJavaProject classpath) {
        return TypeCache.getInstance().getTypes(typeName, classpath);
    }

    public static boolean existsType(String typeName) {
        return TypeUtility.exists((IJavaElement)TypeUtility.getType(typeName));
    }

    public static IPackageFragmentRoot getSrcPackageFragmentRoot(IJavaProject project) throws JavaModelException {
        return project.findPackageFragmentRoot((IPath)new Path(String.valueOf('/') + project.getElementName() + '/' + DEFAULT_SOURCE_FOLDER_NAME));
    }

    public static IPackageFragment getPackage(IJavaElement element) {
        IPackageFragment packageFragment = (IPackageFragment)element.getAncestor(4);
        return packageFragment;
    }

    public static IPackageFragment getPackage(IJavaProject project, String packageName) throws JavaModelException {
        return TypeUtility.getSrcPackageFragmentRoot(project).getPackageFragment(packageName);
    }

    public static IPackageFragment[] getSubPackages(IPackageFragment packageFragment) {
        ArrayList<IPackageFragment> subPackages = new ArrayList<IPackageFragment>();
        String prefix = String.valueOf(packageFragment.getElementName()) + ".";
        IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)packageFragment.getAncestor(3);
        if (TypeUtility.exists((IJavaElement)packageFragmentRoot)) {
            try {
                IJavaElement[] iJavaElementArray = packageFragmentRoot.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement candidate = iJavaElementArray[n2];
                    if (TypeUtility.exists(candidate) && candidate.getElementType() == 4 && candidate.getElementName().startsWith(prefix)) {
                        subPackages.add((IPackageFragment)candidate);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logError("could not get subpackages of '" + packageFragment.getElementName() + "'.", e);
            }
        }
        return subPackages.toArray(new IPackageFragment[subPackages.size()]);
    }

    public static IType[] toArray(IType ... types) {
        if (types == null) {
            return new IType[0];
        }
        return types;
    }

    public static IType getPrimaryType(IJavaElement e) throws JavaModelException {
        if (TypeUtility.exists(e)) {
            ICompilationUnit icu = (ICompilationUnit)e.getAncestor(5);
            if (TypeUtility.exists((IJavaElement)icu)) {
                IType result;
                IType[] candidates = icu.getTypes();
                if (candidates != null && candidates.length > 0 && TypeUtility.exists((IJavaElement)(result = candidates[0]))) {
                    return result;
                }
            } else {
                IType candidate;
                IClassFile cf = (IClassFile)e.getAncestor(6);
                if (TypeUtility.exists((IJavaElement)cf) && TypeUtility.exists((IJavaElement)(candidate = cf.getType()))) {
                    return candidate;
                }
            }
        }
        return null;
    }

    public static IType[] getInnerTypes(IType type) {
        return TypeUtility.getInnerTypes(type, null);
    }

    public static IType[] getInnerTypes(IType type, ITypeFilter filter) {
        return TypeUtility.getInnerTypes(type, filter, null);
    }

    public static IType[] getInnerTypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        AbstractSet result = null;
        result = comparator == null ? new HashSet() : new TreeSet<IType>(comparator);
        try {
            IType[] iTypeArray = type.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType subType = iTypeArray[n2];
                if (filter == null || filter.accept(subType)) {
                    result.add(subType);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get inner types of '" + type.getFullyQualifiedName() + "'", e);
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IType[] getInnerTypesOrdered(IType declaringType, IType superType, Comparator<IType> comparator) {
        ITypeHierarchy combinedTypeHierarchy = TypeUtility.getLocalTypeHierarchy(new IJavaElement[]{declaringType});
        IType[] allSubtypes = TypeUtility.getInnerTypes(declaringType, TypeFilters.getSubtypeFilter(superType, combinedTypeHierarchy), comparator);
        return allSubtypes;
    }

    public static IType getTypeBySignature(String signature) {
        if (signature == null) {
            return null;
        }
        return TypeUtility.getType(SignatureUtility.getFullyQualifiedName(signature));
    }

    public static ITypeHierarchy getLocalTypeHierarchy(IJavaElement ... elements) {
        IRegion region = JavaCore.newRegion();
        if (elements != null) {
            IJavaElement[] iJavaElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IType t;
                IJavaElement e = iJavaElementArray[n2];
                if (e.getElementType() == 7 && (t = (IType)e).isBinary()) {
                    TypeUtility.addBinaryInnerTypesToRegionRec(t, region);
                }
                region.add(e);
                ++n2;
            }
        }
        return HierarchyCache.getInstance().getLocalHierarchy(region);
    }

    private static void addBinaryInnerTypesToRegionRec(IType declaringType, IRegion region) {
        try {
            IType[] iTypeArray = declaringType.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType child = iTypeArray[n2];
                region.add((IJavaElement)child);
                TypeUtility.addBinaryInnerTypesToRegionRec(child, region);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logError("Unable to get inner types of type '" + declaringType.getFullyQualifiedName() + "'.", e);
        }
    }

    public static ITypeHierarchy getLocalTypeHierarchy(IRegion region) {
        return HierarchyCache.getInstance().getLocalHierarchy(region);
    }

    public static ITypeHierarchy getSuperTypeHierarchy(IType type) {
        return HierarchyCache.getInstance().getSuperHierarchy(type);
    }

    public static IPrimaryTypeTypeHierarchy[] getAllCachedPrimaryTypeHierarchies() {
        return HierarchyCache.getInstance().getAllCachedHierarchies();
    }

    public static IPrimaryTypeTypeHierarchy getPrimaryTypeHierarchy(IType type) throws IllegalArgumentException {
        return HierarchyCache.getInstance().getPrimaryTypeHierarchy(type);
    }

    public static boolean hasInnerType(IType declaringType, String typeName) {
        IType candidate = declaringType.getType(typeName);
        return candidate != null && candidate.exists();
    }

    public static IMethod getMethod(IType declaringType, String methodName, String[] resolvedParameterSignatures) throws CoreException {
        IMethod[] iMethodArray = declaringType.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] parameterSignatures;
            IMethod m = iMethodArray[n2];
            if (CompareUtility.equals((Object)m.getElementName(), (Object)methodName) && (parameterSignatures = SignatureUtility.getMethodParameterSignatureResolved(m)).length == resolvedParameterSignatures.length) {
                boolean signatureEquals = true;
                int i = 0;
                while (i < parameterSignatures.length) {
                    if (!CompareUtility.equals((Object)resolvedParameterSignatures[i], (Object)parameterSignatures[i])) {
                        signatureEquals = false;
                        break;
                    }
                    ++i;
                }
                if (signatureEquals) {
                    return m;
                }
            }
            ++n2;
        }
        return null;
    }

    public static IMethod findMethodInSuperClassHierarchy(IType type, IMethodFilter filter) {
        try {
            return TypeUtility.findMethodInSuperClassHierarchy(type, type.newSupertypeHierarchy(null), filter);
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not create super type hierarchy of '" + type.getFullyQualifiedName() + "'.", e);
            return null;
        }
    }

    public static IMethod findMethodInSuperClassHierarchy(IType type, org.eclipse.jdt.core.ITypeHierarchy hierarchy, IMethodFilter filter) {
        if (TypeUtility.exists((IJavaElement)type)) {
            IMethod method = TypeUtility.getFirstMethod(type, filter);
            if (TypeUtility.exists((IJavaElement)method)) {
                return method;
            }
            return TypeUtility.findMethodInSuperClassHierarchy(hierarchy.getSuperclass(type), hierarchy, filter);
        }
        return null;
    }

    public static IMethod getFirstMethod(IType type, IMethodFilter filter) {
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (filter == null || filter.accept(method)) {
                    return method;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            SdkUtilActivator.logWarning("could not get methods of '" + type.getFullyQualifiedName() + "' with filter '" + filter + "'.", e);
        }
        return null;
    }

    public static IMethod getMethod(IType type, final String methodName) {
        IMethod[] methods = TypeUtility.getMethods(type, new IMethodFilter(){

            @Override
            public boolean accept(IMethod method) {
                return method.getElementName().equals(methodName);
            }
        });
        if (methods.length > 0) {
            return methods[0];
        }
        return null;
    }

    public static IMethod[] getMethods(IType type) {
        return TypeUtility.getMethods(type, null);
    }

    public static IMethod[] getMethods(IType type, IMethodFilter filter) {
        return TypeUtility.getMethods(type, filter, null);
    }

    public static IMethod[] getMethods(IType type, IMethodFilter filter, Comparator<IMethod> comparator) {
        try {
            IMethod[] methods = type.getMethods();
            if (filter == null && comparator == null) {
                return methods;
            }
            AbstractCollection collector = null;
            collector = comparator == null ? new ArrayList(methods.length) : new TreeSet<IMethod>(comparator);
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (filter == null || filter.accept(method)) {
                    collector.add(method);
                }
                ++n2;
            }
            return collector.toArray(new IMethod[collector.size()]);
        }
        catch (CoreException e) {
            SdkUtilActivator.logWarning("could not get methods of '" + type.getFullyQualifiedName() + "' with filter '" + filter + "'.", e);
            return new IMethod[0];
        }
    }

    public static ISourceRange getContentSourceRange(IMethod method) throws JavaModelException {
        ASTParser parser = AstUtility.newParser();
        parser.setCompilerOptions(method.getJavaProject().getOptions(true));
        parser.setKind(4);
        parser.setSource(method.getSource().toCharArray());
        parser.setResolveBindings(false);
        parser.setBindingsRecovery(false);
        ASTNode rootNode = parser.createAST(null);
        final Holder rangeHolder = new Holder(ISourceRange.class);
        rootNode.accept(new ASTVisitor(){
            boolean a = false;

            public boolean visit(MethodDeclaration node) {
                this.a = true;
                return true;
            }

            public boolean visit(Block node) {
                if (this.a) {
                    rangeHolder.setValue((Object)new SourceRange(node.getStartPosition(), node.getLength()));
                    return false;
                }
                return true;
            }
        });
        ISourceRange methodRelativeRange = (ISourceRange)rangeHolder.getValue();
        if (methodRelativeRange != null) {
            return new SourceRange(methodRelativeRange.getOffset() + method.getSourceRange().getOffset() + 1, methodRelativeRange.getLength() - 2);
        }
        return null;
    }

    public static MethodParameter[] getMethodParameters(IMethod method, IType contextType) throws CoreException {
        String[] resolvedParamSignatures;
        String[] paramNames = method.getParameterNames();
        if (paramNames.length != (resolvedParamSignatures = SignatureUtility.getMethodParameterSignatureResolved(method, contextType)).length) {
            throw new IllegalArgumentException("Could not resolve method parameters of '" + method.getElementName() + "' in '" + method.getDeclaringType().getFullyQualifiedName() + "'.");
        }
        ArrayList<MethodParameter> params = new ArrayList<MethodParameter>();
        int i = 0;
        while (i < paramNames.length) {
            params.add(new MethodParameter(paramNames[i], resolvedParamSignatures[i]));
            ++i;
        }
        return params.toArray(new MethodParameter[params.size()]);
    }

    public static MethodParameter[] getMethodParameters(IMethod method, Map<String, String> generics) throws CoreException {
        String[] resolvedParamSignatures;
        String[] paramNames = method.getParameterNames();
        if (paramNames.length != (resolvedParamSignatures = SignatureUtility.getMethodParameterSignatureResolved(method, generics)).length) {
            throw new IllegalArgumentException("Could not resolve method parameters of '" + method.getElementName() + "' in '" + method.getDeclaringType().getFullyQualifiedName() + "'.");
        }
        ArrayList<MethodParameter> params = new ArrayList<MethodParameter>();
        int i = 0;
        while (i < paramNames.length) {
            params.add(new MethodParameter(paramNames[i], resolvedParamSignatures[i]));
            ++i;
        }
        return params.toArray(new MethodParameter[params.size()]);
    }

    public static IType getAncestor(IType type, ITypeFilter filter) {
        IType ancestorType = type;
        while (TypeUtility.exists((IJavaElement)ancestorType)) {
            if (filter.accept(ancestorType)) {
                return ancestorType;
            }
            ancestorType = ancestorType.getDeclaringType();
        }
        return null;
    }

    public static IField[] getFields(IType declaringType) {
        return TypeUtility.getFields(declaringType, null);
    }

    public static IField[] getFields(IType declaringType, IFieldFilter filter) {
        return TypeUtility.getFields(declaringType, filter, null);
    }

    public static IField[] getFields(IType declaringType, IFieldFilter filter, Comparator<IField> comparator) {
        try {
            IField[] fields = declaringType.getFields();
            if (filter == null && comparator == null) {
                return fields;
            }
            AbstractCollection collector = null;
            collector = comparator == null ? new ArrayList(fields.length) : new TreeSet<IField>(comparator);
            IField[] iFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (filter == null || filter.accept(field)) {
                    collector.add(field);
                }
                ++n2;
            }
            return collector.toArray(new IField[collector.size()]);
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get fields of '" + declaringType.getElementName() + "'.", e);
            return new IField[0];
        }
    }

    public static IField getFirstField(IType type, IFieldFilter filter) {
        try {
            IField[] iFieldArray = type.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField method = iFieldArray[n2];
                if (filter == null || filter.accept(method)) {
                    return method;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get methods of '" + type.getFullyQualifiedName() + "'.", e);
        }
        return null;
    }

    public static Object getFieldConstant(IField field) throws JavaModelException {
        Object val = field.getConstant();
        if (val instanceof String) {
            String ret = (String)val;
            if ((ret = ret.trim()).length() > 2 && ret.charAt(0) == '\"' && ret.charAt(ret.length() - 1) == '\"') {
                ret = ret.substring(1, ret.length() - 1);
            }
            return ret;
        }
        return val;
    }

    public static boolean equalTypes(IType[] arr1, IType[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null) {
            return false;
        }
        if (arr2 == null) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        Arrays.sort(arr1, TypeComparators.getHashCodeComparator());
        Arrays.sort(arr2, TypeComparators.getHashCodeComparator());
        return Arrays.equals(arr1, arr2);
    }

    public static IMethod getOverwrittenMethod(IMethod method, org.eclipse.jdt.core.ITypeHierarchy superTypeHierarchy) {
        IType superType = superTypeHierarchy.getSuperclass(method.getDeclaringType());
        IMethodFilter overrideFilter = MethodFilters.getSuperMethodFilter(method);
        while (superType != null) {
            IMethod superMethod = TypeUtility.getFirstMethod(superType, overrideFilter);
            if (superMethod != null) {
                return superMethod;
            }
            superType = superTypeHierarchy.getSuperclass(superType);
        }
        return null;
    }

    public static IType getToplevelType(IType type) {
        if (type == null) {
            return null;
        }
        if (type.getParent().getElementType() != 7) {
            return type;
        }
        return TypeUtility.getToplevelType(type.getDeclaringType());
    }

    public static IType[] getTypesInPackage(IPackageFragment pck) {
        return TypeUtility.getTypesInPackage(pck, null);
    }

    public static IType[] getTypesInPackage(IPackageFragment pck, ITypeFilter filter) {
        return TypeUtility.getTypesInPackage(pck, filter, null);
    }

    public static IType[] getTypesInPackage(IPackageFragment pck, ITypeFilter filter, Comparator<IType> comparator) {
        return TypeUtility.getTypesInPackage(pck, filter, comparator, false);
    }

    public static IType[] getTypesInPackage(IPackageFragment pck, ITypeFilter filter, Comparator<IType> comparator, boolean includeSubpackages) {
        ArrayList<IType> unsortedTypes = new ArrayList<IType>();
        TypeUtility.collectTypesInPackage(pck, filter, includeSubpackages, unsortedTypes);
        if (comparator == null) {
            return unsortedTypes.toArray(new IType[unsortedTypes.size()]);
        }
        TreeSet<IType> sortedTypes = new TreeSet<IType>(comparator);
        sortedTypes.addAll(unsortedTypes);
        return sortedTypes.toArray(new IType[sortedTypes.size()]);
    }

    private static void collectTypesInPackage(IPackageFragment pck, ITypeFilter filter, boolean includeSubPackages, Collection<IType> collector) {
        try {
            if (pck != null && pck.exists()) {
                IJavaElement[] iJavaElementArray = pck.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit icu;
                    IType[] types;
                    IJavaElement element = iJavaElementArray[n2];
                    if (element.getElementType() == 4) {
                        if (includeSubPackages) {
                            TypeUtility.collectTypesInPackage((IPackageFragment)element, filter, includeSubPackages, collector);
                        }
                    } else if (element.getElementType() == 5 && (types = (icu = (ICompilationUnit)element).getTypes()) != null && types.length > 0) {
                        collector.add(types[0]);
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get types of package '" + pck.getElementName() + "'", e);
        }
    }

    public static boolean exists(IJavaElement element) {
        return element != null && element.exists();
    }

    public static IType findInnerType(IType type, String innerTypeName) {
        if (type == null) {
            return null;
        }
        if (StringUtility.equalsIgnoreCase((String)type.getElementName(), (String)innerTypeName)) {
            return type;
        }
        try {
            IType[] iTypeArray = type.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType innerType = iTypeArray[n2];
                IType found = TypeUtility.findInnerType(innerType, innerTypeName);
                if (found != null) {
                    return found;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logError("could not find inner type named '" + innerTypeName + "' in type '" + type.getFullyQualifiedName() + "'.", e);
        }
        return null;
    }

    public static String getReferencedTypeFqn(IType declaringType, String typeName, boolean searchOnClassPath) throws JavaModelException {
        IType[] candidates;
        String[][] resolvedTypeName;
        ICompilationUnit compilationUnit = declaringType.getCompilationUnit();
        if (compilationUnit != null) {
            IImportDeclaration[] imports;
            String searchString = String.valueOf('.') + typeName;
            IImportDeclaration[] iImportDeclarationArray = imports = compilationUnit.getImports();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                IImportDeclaration imp = iImportDeclarationArray[n2];
                if (imp.getElementName().endsWith(searchString)) {
                    return imp.getElementName();
                }
                ++n2;
            }
        }
        if ((resolvedTypeName = declaringType.resolveType(typeName)) != null && resolvedTypeName.length == 1) {
            String pck = resolvedTypeName[0][0];
            StringBuilder fqName = new StringBuilder();
            if (pck != null && pck.length() > 0) {
                fqName.append(pck);
                fqName.append('.');
            }
            fqName.append(resolvedTypeName[0][1]);
            return fqName.toString();
        }
        if (searchOnClassPath && TypeUtility.exists((IJavaElement)declaringType.getJavaProject()) && (candidates = TypeUtility.getTypes(typeName, declaringType.getJavaProject())).length == 1) {
            return candidates[0].getFullyQualifiedName();
        }
        return null;
    }

    public static IType getReferencedType(IType declaringType, String typeName, boolean searchOnClassPath) throws JavaModelException {
        String referencedTypeFqn = TypeUtility.getReferencedTypeFqn(declaringType, typeName, searchOnClassPath);
        if (referencedTypeFqn != null) {
            return TypeUtility.getType(referencedTypeFqn);
        }
        return null;
    }

    public static boolean isGenericType(IType type) {
        return TypeUtility.getTypeParameters(type).length > 0;
    }

    public static IType getMoreSpecificType(IType a, IType b) throws JavaModelException {
        if (!TypeUtility.exists((IJavaElement)a) && !TypeUtility.exists((IJavaElement)b)) {
            return null;
        }
        if (!TypeUtility.exists((IJavaElement)a)) {
            return b;
        }
        if (!TypeUtility.exists((IJavaElement)b)) {
            return a;
        }
        if (a.newSupertypeHierarchy(null).contains(b)) {
            return a;
        }
        if (b.newSupertypeHierarchy(null).contains(a)) {
            return b;
        }
        return null;
    }

    public static ITypeParameter[] getTypeParameters(IType type) {
        if (TypeUtility.exists((IJavaElement)type)) {
            try {
                return type.getTypeParameters();
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logWarning("could not get generic information of type: " + type.getFullyQualifiedName(), e);
            }
        }
        return new ITypeParameter[0];
    }

    public static boolean isOnClasspath(IJavaElement element, IJavaProject project) {
        IMember member;
        if (!TypeUtility.exists(element)) {
            return false;
        }
        if (!TypeUtility.exists((IJavaElement)project)) {
            return false;
        }
        if (element instanceof IMember && (member = (IMember)element).isBinary()) {
            return project.isOnClasspath((IJavaElement)member);
        }
        IJavaProject elemenProject = element.getJavaProject();
        if (elemenProject != null) {
            if (project.equals(elemenProject)) {
                return true;
            }
            return project.isOnClasspath((IJavaElement)elemenProject);
        }
        return project.isOnClasspath(element);
    }

    public static IPropertyBean[] getPropertyBeans(IType type, IPropertyBeanFilter propertyFilter, Comparator<IPropertyBean> comparator) {
        IField[] name;
        IMethod[] methods;
        HashMap<IField[], PropertyBean> beans = new HashMap<IField[], PropertyBean>();
        IMethodFilter filter = MethodFilters.getMultiMethodFilter(MethodFilters.getFlagsFilter(1), MethodFilters.getNameRegexFilter(BEAN_METHOD_NAME));
        IMethod[] iMethodArray = methods = TypeUtility.getMethods(type, filter);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            Matcher matcher = BEAN_METHOD_NAME.matcher(m.getElementName());
            if (matcher.matches()) {
                try {
                    PropertyBean desc;
                    String kind = matcher.group(1);
                    name = matcher.group(2);
                    String[] parameterTypes = m.getParameterTypes();
                    String returnType = m.getReturnType();
                    if (kind.equals("get") && parameterTypes.length == 0 && !returnType.equals("V")) {
                        desc = (PropertyBean)beans.get(name);
                        if (desc == null) {
                            desc = new PropertyBean(type, (String)name);
                            beans.put(name, desc);
                        }
                        if (desc.getReadMethod() == null) {
                            desc.setReadMethod(m);
                        }
                    } else if (kind.equals("is") && parameterTypes.length == 0 && returnType.equals("Z")) {
                        desc = (PropertyBean)beans.get(name);
                        if (desc == null) {
                            desc = new PropertyBean(type, (String)name);
                            beans.put(name, desc);
                        }
                        if (desc.getReadMethod() == null) {
                            desc.setReadMethod(m);
                        }
                    } else if (kind.equals("set") && parameterTypes.length == 1 && returnType.equals("V")) {
                        desc = (PropertyBean)beans.get(name);
                        if (desc == null) {
                            desc = new PropertyBean(type, (String)name);
                            beans.put(name, desc);
                        }
                        if (desc.getWriteMethod() == null) {
                            desc.setWriteMethod(m);
                        }
                    }
                }
                catch (JavaModelException e) {
                    SdkUtilActivator.logError("Error while collectiong property beans of type [" + type + "]", e);
                }
            }
            ++n2;
        }
        ArrayList<PropertyBean> filteredBeans = new ArrayList<PropertyBean>(beans.size());
        for (PropertyBean bean : beans.values()) {
            if (propertyFilter != null && !propertyFilter.accept(bean)) continue;
            filteredBeans.add(bean);
        }
        IField[] fieldCandidates = TypeUtility.getFields(type, FieldFilters.getPrivateNotStaticNotFinalNotAbstract(), null);
        HashMap<String, IField> fields = new HashMap<String, IField>();
        name = fieldCandidates;
        int e = fieldCandidates.length;
        int matcher = 0;
        while (matcher < e) {
            IField field = name[matcher];
            fields.put(field.getElementName(), field);
            ++matcher;
        }
        AssistOptions assistOptions = new AssistOptions(type.getJavaProject().getOptions(true));
        String[] fieldPrefixes = TypeUtility.toStringArray(assistOptions.fieldPrefixes, "m_", "");
        String[] fieldSuffixes = TypeUtility.toStringArray(assistOptions.fieldSuffixes, "");
        for (PropertyBean bean : filteredBeans) {
            IField field = TypeUtility.findFieldForPropertyBean(bean.getBeanName(), fields, fieldPrefixes, fieldSuffixes);
            if (field != null) {
                bean.setField(field);
                continue;
            }
            SdkUtilActivator.logWarning("Unable to find field for property bean [" + bean + "]");
        }
        if (comparator != null) {
            Collections.sort(filteredBeans, comparator);
        }
        return filteredBeans.toArray(new IPropertyBean[filteredBeans.size()]);
    }

    public static boolean isAncestor(IJavaElement parent, IJavaElement chlid) {
        if (parent == null || chlid == null) {
            return false;
        }
        if (parent.equals(chlid)) {
            return true;
        }
        if (chlid.getParent() != null && chlid.getParent().getElementType() >= parent.getElementType()) {
            return TypeUtility.isAncestor(parent, chlid.getParent().getAncestor(parent.getElementType()));
        }
        return false;
    }

    public static int getIndent(IJavaElement element) {
        int indent = 0;
        IJavaElement visitedElement = element;
        while (visitedElement.getElementType() != 5) {
            ++indent;
            visitedElement = element.getParent();
        }
        return indent;
    }

    public static IMethod findMethodInSuperHierarchy(String methodName, IType type, ITypeHierarchy superTypeHierarchy) {
        return TypeUtility.findMethodInSuperTypeHierarchy(type, superTypeHierarchy, MethodFilters.getNameFilter(methodName));
    }

    public static IMethod findMethodInSuperTypeHierarchy(IType type, ITypeHierarchy superTypeHierarchy, IMethodFilter filter) {
        IMethod[] methods = TypeUtility.getMethods(type, filter);
        IMethod method = null;
        if (methods.length == 1) {
            return methods[0];
        }
        if (methods.length > 1) {
            StringBuilder sb = new StringBuilder(" [\n");
            sb.append("\t\t").append(methods[0].toString());
            int i = 1;
            while (i < methods.length) {
                sb.append(", \n\t\t").append(methods[i].toString());
                ++i;
            }
            sb.append("\n\t]");
            SdkUtilActivator.logWarning("found more than one method in hierarchy" + sb.toString());
            return methods[0];
        }
        IType superType = superTypeHierarchy.getSuperclass(type);
        if (TypeUtility.exists((IJavaElement)superType) && !superType.getElementName().equals(Object.class.getName())) {
            method = TypeUtility.findMethodInSuperTypeHierarchy(superType, superTypeHierarchy, filter);
        }
        if (TypeUtility.exists(method)) {
            return method;
        }
        IType[] iTypeArray = superTypeHierarchy.getSuperInterfaces(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType intType = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)intType) && !intType.getElementName().equals(Object.class.getName())) {
                method = TypeUtility.findMethodInSuperTypeHierarchy(intType, superTypeHierarchy, filter);
            }
            if (TypeUtility.exists((IJavaElement)method)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static IField findFieldForPropertyBean(String beanName, HashMap<String, IField> fields, String[] fieldPrefixes, String[] fieldSuffixes) {
        String[] stringArray = fieldPrefixes;
        int n = fieldPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            String[] stringArray2 = fieldSuffixes;
            int n3 = fieldSuffixes.length;
            int n4 = 0;
            while (n4 < n3) {
                String suffix = stringArray2[n4];
                IField field = fields.get(String.valueOf(prefix) + NamingUtility.ensureStartWithLowerCase(beanName) + suffix);
                if (TypeUtility.exists((IJavaElement)field)) {
                    return field;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private static String[] toStringArray(char[][] arrayOfChars, String ... additionalValues) {
        int n;
        int n2;
        Object object;
        HashSet<String> result = new HashSet<String>();
        if (additionalValues != null) {
            object = additionalValues;
            n2 = additionalValues.length;
            n = 0;
            while (n < n2) {
                String s = object[n];
                result.add(s);
                ++n;
            }
        }
        if (arrayOfChars != null) {
            object = arrayOfChars;
            n2 = arrayOfChars.length;
            n = 0;
            while (n < n2) {
                String cs = object[n];
                if (cs != null && ((String)cs).length > 0) {
                    result.add(String.valueOf((char[])cs));
                }
                ++n;
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

