/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsProviderImplNewOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderCodeFirstNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class MissingPortTypeCommand
extends AbstractExecutableMarkerCommand {
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;
    private IType m_portTypeInterfaceType;
    private String m_markerGroupUUID;
    private String m_fqnPortType;

    public MissingPortTypeCommand(IScoutBundle bundle, String markerGroupUUID, SunJaxWsBean sunJaxWsBean, IType portTypeInterfaceType) {
        super("Missing or invalid port type");
        this.m_bundle = bundle;
        this.m_portTypeInterfaceType = portTypeInterfaceType;
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.m_markerGroupUUID = markerGroupUUID;
        String portType = this.m_sunJaxWsBean.getImplementation();
        if (portType == null) {
            String name = this.m_sunJaxWsBean.getAlias();
            if (!name.toLowerCase().endsWith("service") || !name.toLowerCase().endsWith("webservice")) {
                name = String.valueOf(name) + "WebService";
            }
            this.m_fqnPortType = StringUtility.join((String)".", (Object[])new Object[]{JaxWsSdkUtility.getRecommendedProviderImplPackageName(this.m_bundle), name});
        } else {
            this.m_fqnPortType = portType;
        }
        this.setSolutionDescription("By using this task, the port type '" + this.m_fqnPortType + "' is created'.");
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        WsProviderImplNewOperation op = new WsProviderImplNewOperation();
        op.setBundle(this.m_bundle);
        op.setPackageName(Signature.getQualifier((String)this.m_fqnPortType));
        op.setTypeName(Signature.getSimpleName((String)this.m_fqnPortType));
        op.setCreateScoutWebServiceAnnotation(true);
        op.setSessionFactoryQName(TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.DefaultServerSessionFactory").getFullyQualifiedName());
        op.setAuthenticationHandlerQName(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.BasicAuthenticationHandler").getFullyQualifiedName());
        op.setCredentialValidationStrategyQName(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.ConfigIniCredentialValidationStrategy").getFullyQualifiedName());
        op.setPortTypeInterfaceType(this.m_portTypeInterfaceType);
        op.validate();
        op.run(monitor, workingCopyManager);
        this.m_sunJaxWsBean.setImplementation(this.m_fqnPortType);
        XmlResource sunJaxWsResource = ResourceFactory.getSunJaxWsResource(this.m_bundle);
        sunJaxWsResource.storeXmlAsync(this.m_sunJaxWsBean.getXml().getOwnerDocument(), 32, this.m_sunJaxWsBean.getAlias());
        JaxWsSdk.getDefault().notifyPageReload(WebServiceProviderNodePage.class, this.m_markerGroupUUID, 1);
        JaxWsSdk.getDefault().notifyPageReload(WebServiceProviderCodeFirstNodePage.class, this.m_markerGroupUUID, 1);
    }
}

