/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.action;

import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.marker.MarkerUtility;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.IMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.operation.CommandExecutionOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.AbstractLinkAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.CommandExecutionDialog;
import org.eclipse.swt.widgets.Shell;

public class RepairAction
extends AbstractLinkAction {
    private IScoutBundle m_bundle;
    private String m_markerGroupUUID;

    public RepairAction() {
        super(Texts.get("Repair"), null);
        this.setLeadingText(Texts.get("presenterRepair"));
        this.setLinkText(Texts.get("repairTools"));
        this.setToolTip(Texts.get("ClickToFixTheProblems"));
    }

    public void init(String markerGroupUUID, IScoutBundle bundle) {
        this.m_markerGroupUUID = markerGroupUUID;
        this.m_bundle = bundle;
        IMarkerCommand[] markerCommands = MarkerUtility.getMarkerCommands(this.m_markerGroupUUID, this.m_bundle);
        int severity = 0;
        IMarkerCommand[] iMarkerCommandArray = markerCommands;
        int n = markerCommands.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerCommand cmd = iMarkerCommandArray[n2];
            severity = Math.max(cmd.getMarker().getAttribute("severity", 0), severity);
            if (severity == 2) break;
            ++n2;
        }
        switch (severity) {
            case 0: {
                this.setImage(JaxWsSdk.getImageDescriptor("quick_assist_obj.gif"));
                break;
            }
            case 1: {
                this.setImage(JaxWsSdk.getImageDescriptor("quick_fix_warning_obj.gif"));
                break;
            }
            default: {
                this.setImage(JaxWsSdk.getImageDescriptor("quick_fix_error_obj.gif"));
            }
        }
    }

    public boolean isVisible() {
        return !this.m_bundle.isBinary();
    }

    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        IMarkerCommand[] markerCommands = MarkerUtility.getMarkerCommands(this.m_markerGroupUUID, this.m_bundle);
        CommandExecutionDialog dialog = new CommandExecutionDialog(Texts.get("RepairTools"));
        dialog.setHeaderMessage(Texts.get("TheFollowingProblemsWereEncountered"));
        dialog.setCommands(markerCommands);
        if (dialog.open() == 0) {
            LinkedList<IMarkerCommand> commandsToBeExecuted = new LinkedList<IMarkerCommand>();
            IMarkerCommand[] iMarkerCommandArray = markerCommands;
            int n = markerCommands.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerCommand command = iMarkerCommandArray[n2];
                if (command.isDoExecute()) {
                    try {
                        if (command.prepareForUi()) {
                            commandsToBeExecuted.add(command);
                        }
                    }
                    catch (CoreException e) {
                        JaxWsSdk.logError("Error occured while preparing command to be executed", e);
                    }
                }
                ++n2;
            }
            OperationJob job = new OperationJob(new IOperation[]{new CommandExecutionOperation(commandsToBeExecuted.toArray(new IMarkerCommand[commandsToBeExecuted.size()]))});
            job.schedule();
        }
        return null;
    }
}

