/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.internal.interpreter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.internal.interpreter.FeatureInterpreter;

public class FeatureProposalProvider
implements IProposalProvider {
    private static final String SEPARATOR_1 = ":";
    private static final String SEPARATOR_2 = " - ";
    private static final String SEPARATOR_3 = "[0..*]";

    public ContentProposal getNewEmtpyExpression() {
        return new ContentProposal("feature:", "feature:", "New feature access expression.", "feature:".length());
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentContext context) {
        List<ContentProposal> proposals;
        if (context == null || !(interpreter instanceof FeatureInterpreter)) {
            proposals = Collections.emptyList();
        } else if (context.getContents() == null || context.getContents().length() == 0) {
            proposals = Collections.singletonList(this.getNewEmtpyExpression());
        } else {
            FeatureInterpreter featureInterpreter = (FeatureInterpreter)interpreter;
            IInterpreterContext interpreterContext = context.getInterpreterContext();
            EClass currentElementType = featureInterpreter.getCurrentElementType(interpreterContext);
            proposals = this.getProposals(context.getContents(), context.getPosition(), currentElementType);
        }
        return proposals;
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentInstanceContext context) {
        List<ContentProposal> proposals = context == null || !(interpreter instanceof FeatureInterpreter) ? Collections.emptyList() : (context.getCurrentSelected() == null ? Collections.singletonList(this.getNewEmtpyExpression()) : this.getProposals(context.getTextSoFar(), context.getCursorPosition(), context.getCurrentSelected().eClass()));
        return proposals;
    }

    private List<ContentProposal> getProposals(String writtenExpression, int cursorPosition, EClass currentElementType) {
        ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
        String featureNamePrefix = writtenExpression.substring(0, cursorPosition);
        if ((featureNamePrefix = featureNamePrefix.trim()).length() >= "feature:".length()) {
            String eReferencesFeatureName;
            String eClassFeatureName;
            String eAllContentsFeatureName;
            String eContentsFeatureName;
            featureNamePrefix = featureNamePrefix.trim().substring("feature:".length());
            String eObjectName = EObject.class.getSimpleName();
            String eContainerFeatureName = FeatureInterpreter.DEFAULT_FEATURE_NAMES[0];
            if (eContainerFeatureName.startsWith(featureNamePrefix)) {
                String displayedName = String.valueOf(eContainerFeatureName) + SEPARATOR_1 + eObjectName + SEPARATOR_2 + eObjectName;
                proposals.add(new ContentProposal(eContainerFeatureName, displayedName, displayedName));
            }
            if ((eContentsFeatureName = FeatureInterpreter.DEFAULT_FEATURE_NAMES[1]).startsWith(featureNamePrefix)) {
                String displayedName = String.valueOf(eContentsFeatureName) + SEPARATOR_1 + eObjectName + SEPARATOR_3 + SEPARATOR_2 + eObjectName;
                proposals.add(new ContentProposal(eContentsFeatureName, displayedName, displayedName));
            }
            if ((eAllContentsFeatureName = FeatureInterpreter.DEFAULT_FEATURE_NAMES[2]).startsWith(featureNamePrefix)) {
                String displayedName = String.valueOf(eAllContentsFeatureName) + SEPARATOR_1 + "TreeIterator" + SEPARATOR_2 + eObjectName;
                proposals.add(new ContentProposal(eAllContentsFeatureName, displayedName, displayedName));
            }
            if ((eClassFeatureName = FeatureInterpreter.DEFAULT_FEATURE_NAMES[3]).startsWith(featureNamePrefix)) {
                String displayedName = String.valueOf(eClassFeatureName) + SEPARATOR_1 + eObjectName + SEPARATOR_3 + SEPARATOR_2 + EClass.class.getSimpleName();
                proposals.add(new ContentProposal(eClassFeatureName, displayedName, displayedName));
            }
            if ((eReferencesFeatureName = FeatureInterpreter.DEFAULT_FEATURE_NAMES[4]).startsWith(featureNamePrefix)) {
                String displayedName = String.valueOf(eReferencesFeatureName) + SEPARATOR_1 + eObjectName + SEPARATOR_3 + SEPARATOR_2 + eObjectName;
                proposals.add(new ContentProposal(eReferencesFeatureName, displayedName, displayedName));
            }
            if (currentElementType != null) {
                for (EStructuralFeature eStructuralFeature : currentElementType.getEAllStructuralFeatures()) {
                    if (!eStructuralFeature.getName().startsWith(featureNamePrefix)) continue;
                    String displayedName = String.valueOf(eStructuralFeature.getName()) + (eStructuralFeature.isMany() ? "[" + eStructuralFeature.getLowerBound() + ".." + (eStructuralFeature.getUpperBound() == -1 ? "*" : Integer.valueOf(eStructuralFeature.getUpperBound())) + "]" : "") + (eStructuralFeature.getEType() != null ? SEPARATOR_1 + eStructuralFeature.getEType().getName() : "") + SEPARATOR_2 + eStructuralFeature.getEContainingClass().getName();
                    proposals.add(new ContentProposal(eStructuralFeature.getName(), displayedName, displayedName));
                }
            }
        }
        return proposals;
    }
}

