/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class EdgeQuery {
    private Edge edge;

    public EdgeQuery(Edge edge) {
        this.edge = edge;
    }

    public Option<IdentityAnchor> getTargetAnchorOfFirstBrotherWithSameTarget() {
        for (Object brother : this.edge.getTarget().getTargetEdges()) {
            if (!(brother instanceof Edge) || ((Edge)brother).getSource() == null || ((Edge)brother).getSource().equals(this.edge.getSource())) continue;
            IdentityAnchor anchor = (IdentityAnchor)((Edge)brother).getTargetAnchor();
            return Options.newSome((Object)anchor);
        }
        return Options.newNone();
    }

    public Option<IdentityAnchor> getSourceAnchorOfFirstBrotherWithSameSource() {
        for (Object brother : this.edge.getSource().getSourceEdges()) {
            if (!(brother instanceof Edge) || ((Edge)brother).getTarget() == null || ((Edge)brother).getTarget().equals(this.edge.getTarget())) continue;
            IdentityAnchor anchor = (IdentityAnchor)((Edge)brother).getSourceAnchor();
            return Options.newSome((Object)anchor);
        }
        return Options.newNone();
    }

    public boolean usedTreeRouter() {
        boolean edgeUsedTreeRouter = false;
        if (this.edge.getElement() instanceof DEdge && ((DEdge)this.edge.getElement()).getOwnedStyle() != null && EdgeRouting.TREE_LITERAL.equals((Object)((DEdge)this.edge.getElement()).getOwnedStyle().getRoutingStyle())) {
            edgeUsedTreeRouter = true;
        }
        return edgeUsedTreeRouter;
    }

    public boolean isEdgeOnTreeOnTargetSide() {
        if (this.usedTreeRouter() && this.edge.getTarget() != null) {
            for (Object brother : this.edge.getTarget().getTargetEdges()) {
                if (this.edge.equals(brother) || !(brother instanceof Edge) || !new EdgeQuery((Edge)brother).usedTreeRouter()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEdgeOnTreeOnSourceSide() {
        if (this.usedTreeRouter() && this.edge.getSource() != null) {
            for (Object brother : this.edge.getSource().getSourceEdges()) {
                if (this.edge.equals(brother) || !(brother instanceof Edge) || !new EdgeQuery((Edge)brother).usedTreeRouter()) continue;
                return true;
            }
        }
        return false;
    }

    public List<Edge> getBrothersOnTreeOnTargetSide() {
        ArrayList brothers = Lists.newArrayList();
        for (Object brother : this.edge.getTarget().getTargetEdges()) {
            if (this.edge.equals(brother) || !(brother instanceof Edge) || !new EdgeQuery((Edge)brother).usedTreeRouter()) continue;
            brothers.add((Edge)brother);
        }
        return brothers;
    }

    public List<Edge> getBrothersOnTreeOnSourceSide() {
        ArrayList brothers = Lists.newArrayList();
        for (Object brother : this.edge.getSource().getSourceEdges()) {
            if (this.edge.equals(brother) || !(brother instanceof Edge) || !new EdgeQuery((Edge)brother).usedTreeRouter()) continue;
            brothers.add((Edge)brother);
        }
        return brothers;
    }

    public boolean isEdgeWithTreeRoutingStyle() {
        boolean isEdgeTreeRoutingStyle = false;
        for (Object style : this.edge.getStyles()) {
            if (!(style instanceof ConnectorStyle)) continue;
            ConnectorStyle connectorStyle = (ConnectorStyle)style;
            if (!Routing.TREE_LITERAL.getLiteral().equals(connectorStyle.getRouting().getLiteral())) continue;
            isEdgeTreeRoutingStyle = true;
        }
        return isEdgeTreeRoutingStyle;
    }
}

