/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionQuery;
import org.eclipse.sirius.diagram.ui.business.internal.operation.ShiftDirectBorderedNodesOperation;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.validators.ResizeValidator;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SetConnectionBendpointsAccordingToDraw2DCommand;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.NoCopyDragEditPartsTrackerEx;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.Style;

public class AirResizableEditPolicy
extends ResizableShapeEditPolicy {
    protected Command getAutoSizeCommand(Request request) {
        NodeStyle nodeStyle;
        EObject eObject;
        if (this.getHost() instanceof IDiagramNodeEditPart && (eObject = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement()) instanceof DNode && (nodeStyle = (NodeStyle)((DNode)eObject).getStyle()) != null && nodeStyle.getLabelPosition() == LabelPosition.NODE_LITERAL) {
            DNode viewNode = (DNode)eObject;
            SiriusWrapLabel label = ((IDiagramNodeEditPart)this.getHost()).getNodeLabel();
            Style style = viewNode.getStyle();
            DiagramElementMapping mapping = viewNode.getDiagramElementMapping();
            DefaultSizeNodeFigure defaultSizeNodeFigure = (DefaultSizeNodeFigure)((IDiagramNodeEditPart)this.getHost()).getMainFigure();
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(mapping, style);
            Dimension newDim = styleConfiguration.fitToText(viewNode, label, defaultSizeNodeFigure);
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)viewNode);
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(transactionalEditingDomain, "Auto Size", (IAdaptable)new EObjectAdapter((EObject)((IGraphicalEditPart)this.getHost()).getNotationView()), newDim);
            return new ICommandProxy((ICommand)setBoundsCommand);
        }
        return super.getAutoSizeCommand(request);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move children");
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        if (this.getHost().getParent() != null) {
            return this.changeBendpointsOfTreeEdges(this.getHost(), this.getHost().getParent().getCommand((Request)req), request.getMoveDelta());
        }
        return null;
    }

    protected Command changeBendpointsOfTreeEdges(EditPart host, Command command, Point moveDelta) {
        CompoundCommand result = new CompoundCommand(command.getLabel());
        if (host instanceof AbstractGraphicalEditPart) {
            AbstractGraphicalEditPart graphicalEditPart = (AbstractGraphicalEditPart)host;
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((Object)host.getModel());
            List sourceConnections = graphicalEditPart.getSourceConnections();
            int i = 0;
            while (i < sourceConnections.size()) {
                ConnectionEditPart connectionEditPart;
                Option<? extends Command> optionalCommand;
                if (sourceConnections.get(i) instanceof ConnectionEditPart && (optionalCommand = this.getBendpointsChangedCommand(transactionalEditingDomain, moveDelta, connectionEditPart = (ConnectionEditPart)sourceConnections.get(i), true)).some()) {
                    if (result.isEmpty()) {
                        result.add(command);
                    }
                    result.add((Command)optionalCommand.get());
                }
                ++i;
            }
            List targetConnections = graphicalEditPart.getTargetConnections();
            int i2 = 0;
            while (i2 < targetConnections.size()) {
                ConnectionEditPart connectionEditPart;
                Option<? extends Command> optionalCommand;
                if (targetConnections.get(i2) instanceof ConnectionEditPart && (optionalCommand = this.getBendpointsChangedCommand(transactionalEditingDomain, moveDelta, connectionEditPart = (ConnectionEditPart)targetConnections.get(i2), false)).some()) {
                    if (result.isEmpty()) {
                        result.add(command);
                    }
                    result.add((Command)optionalCommand.get());
                }
                ++i2;
            }
        }
        if (result.isEmpty()) {
            return command;
        }
        return result;
    }

    protected Option<? extends Command> getBendpointsChangedCommand(TransactionalEditingDomain transactionalEditingDomain, Point moveDelta, ConnectionEditPart connectionEditPart, boolean sourceMove) {
        Connection connectionFigure = connectionEditPart.getConnectionFigure();
        if (new ConnectionQuery(connectionFigure).isOrthogonalTreeBranch(connectionFigure.getPoints()) && new ConnectionEditPartQuery(connectionEditPart).isLayoutComponent()) {
            CompoundCommand command = new CompoundCommand("Map GMF to Draw2D");
            SetConnectionAnchorsCommand setConnectionAnchorsCommand = new SetConnectionAnchorsCommand(transactionalEditingDomain, "Map GMF anchor to Draw2D anchor");
            setConnectionAnchorsCommand.setEdgeAdaptor((IAdaptable)connectionEditPart);
            setConnectionAnchorsCommand.setNewSourceTerminal(((INodeEditPart)connectionEditPart.getSource()).mapConnectionAnchorToTerminal(connectionFigure.getSourceAnchor()));
            setConnectionAnchorsCommand.setNewTargetTerminal(((INodeEditPart)connectionEditPart.getTarget()).mapConnectionAnchorToTerminal(connectionFigure.getTargetAnchor()));
            command.add((Command)new ICommandProxy((ICommand)setConnectionAnchorsCommand));
            SetConnectionBendpointsAccordingToDraw2DCommand setConnectionBendpointsCommand = new SetConnectionBendpointsAccordingToDraw2DCommand(transactionalEditingDomain);
            setConnectionBendpointsCommand.setLabel("Map GMF points to Draw2D points");
            setConnectionBendpointsCommand.setSourceMove(sourceMove);
            setConnectionBendpointsCommand.setMoveDelta(moveDelta);
            setConnectionBendpointsCommand.setEdgeAdapter((IAdaptable)connectionEditPart);
            command.add((Command)new ICommandProxy((ICommand)setConnectionBendpointsCommand));
            return Options.newSome((Object)command);
        }
        return Options.newNone();
    }

    public PointList getPointsFromConstraint(Connection conn) {
        List bendpoints = (List)conn.getRoutingConstraint();
        if (bendpoints == null) {
            return new PointList();
        }
        PointList points = new PointList(bendpoints.size());
        int i = 0;
        while (i < bendpoints.size()) {
            Bendpoint bp = (Bendpoint)bendpoints.get(i);
            points.addPoint(bp.getLocation());
            ++i;
        }
        AirResizableEditPolicy.straightenPoints(points, MapModeUtil.getMapMode((IFigure)conn).DPtoLP(3));
        return points;
    }

    protected static void straightenPoints(PointList newLine, int tolerance) {
        int i = 0;
        while (i < newLine.size() - 1) {
            int yDelta;
            Point ptCurrent = newLine.getPoint(i);
            Point ptNext = newLine.getPoint(i + 1);
            int xDelta = Math.abs(ptNext.x - ptCurrent.x);
            if (xDelta < (yDelta = Math.abs(ptNext.y - ptCurrent.y))) {
                if (xDelta > tolerance) {
                    return;
                }
                ptNext.x = ptCurrent.x;
            } else {
                if (yDelta > tolerance) {
                    return;
                }
                ptNext.y = ptCurrent.y;
            }
            newLine.setPoint(ptNext, i + 1);
            ++i;
        }
    }

    protected List createSelectionHandles() {
        List selectionHandles = super.createSelectionHandles();
        for (Object selectionHandle : selectionHandles) {
            if (!(selectionHandle instanceof MoveHandle)) continue;
            ((MoveHandle)selectionHandle).setDragTracker((DragTracker)new NoCopyDragEditPartsTrackerEx(this.getHost()));
        }
        return selectionHandles;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        ICommand solution;
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        boolean valid = true;
        ResizeValidator resizeValidator = new ResizeValidator(request);
        valid = resizeValidator.validate();
        if (valid && (solution = this.buildResizeCommand(request)) != null) {
            result = new ICommandProxy(solution);
        }
        return result;
    }

    private ICommand buildResizeCommand(ChangeBoundsRequest request) {
        Command cmd = super.getResizeCommand(request);
        if (cmd == null) {
            return null;
        }
        GraphicalEditPart hostPart = (GraphicalEditPart)this.getHost();
        TransactionalEditingDomain editingDomain = hostPart.getEditingDomain();
        CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(editingDomain, cmd.getLabel());
        ctc.add((IUndoableOperation)new CommandProxy(cmd));
        if (hostPart instanceof IBorderedShapeEditPart) {
            this.addChildrenAdjustmentCommands(hostPart, ctc, editingDomain, request);
        }
        return ctc;
    }

    private void addChildrenAdjustmentCommands(GraphicalEditPart resizedPart, CompositeTransactionalCommand cc, TransactionalEditingDomain editingDomain, ChangeBoundsRequest cbr) {
        Map<Node, Integer> westChildrenToMoveWithDelta;
        Map<Node, Integer> eastChildrenToMoveWithDelta;
        List<Node> childrenToMove;
        RequestQuery rq = new RequestQuery((Request)cbr);
        Rectangle logicalDelta = rq.getLogicalDelta();
        if (rq.isResizeFromTop() || rq.isResizeFromBottom()) {
            int verticalSizeDelta = logicalDelta.height;
            childrenToMove = new EditPartQuery((IGraphicalEditPart)resizedPart).getBorderedNodes(4);
            if (!childrenToMove.isEmpty()) {
                cc.compose((IUndoableOperation)CommandFactory.createICommand(editingDomain, new ShiftDirectBorderedNodesOperation(childrenToMove, verticalSizeDelta, 128)));
            }
            eastChildrenToMoveWithDelta = new EditPartQuery((IGraphicalEditPart)resizedPart).getBorderedNodesToMoveWithDelta(16, verticalSizeDelta);
            for (Map.Entry<Node, Integer> entry : eastChildrenToMoveWithDelta.entrySet()) {
                cc.compose((IUndoableOperation)CommandFactory.createICommand(editingDomain, new ShiftDirectBorderedNodesOperation(Lists.newArrayList((Object[])new Node[]{entry.getKey()}), entry.getValue(), 128)));
            }
            westChildrenToMoveWithDelta = new EditPartQuery((IGraphicalEditPart)resizedPart).getBorderedNodesToMoveWithDelta(8, verticalSizeDelta);
            for (Map.Entry<Node, Integer> entry : westChildrenToMoveWithDelta.entrySet()) {
                cc.compose((IUndoableOperation)CommandFactory.createICommand(editingDomain, new ShiftDirectBorderedNodesOperation(Lists.newArrayList((Object[])new Node[]{entry.getKey()}), entry.getValue(), 128)));
            }
        }
        if (rq.isResizeFromRight() || rq.isResizeFromLeft()) {
            int horizontalSizeDelta = logicalDelta.width;
            childrenToMove = new EditPartQuery((IGraphicalEditPart)resizedPart).getBorderedNodes(16);
            if (!childrenToMove.isEmpty()) {
                cc.compose((IUndoableOperation)CommandFactory.createICommand(editingDomain, new ShiftDirectBorderedNodesOperation(childrenToMove, horizontalSizeDelta, 64)));
            }
            eastChildrenToMoveWithDelta = new EditPartQuery((IGraphicalEditPart)resizedPart).getBorderedNodesToMoveWithDelta(1, horizontalSizeDelta);
            for (Map.Entry<Node, Integer> entry : eastChildrenToMoveWithDelta.entrySet()) {
                cc.compose((IUndoableOperation)CommandFactory.createICommand(editingDomain, new ShiftDirectBorderedNodesOperation(Lists.newArrayList((Object[])new Node[]{entry.getKey()}), entry.getValue(), 64)));
            }
            westChildrenToMoveWithDelta = new EditPartQuery((IGraphicalEditPart)resizedPart).getBorderedNodesToMoveWithDelta(4, horizontalSizeDelta);
            for (Map.Entry<Node, Integer> entry : westChildrenToMoveWithDelta.entrySet()) {
                cc.compose((IUndoableOperation)CommandFactory.createICommand(editingDomain, new ShiftDirectBorderedNodesOperation(Lists.newArrayList((Object[])new Node[]{entry.getKey()}), entry.getValue(), 64)));
            }
        }
    }
}

