/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.CreationUtil;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusContainerEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.draw2d.ui.figures.FigureUtilities;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class NodeCreationEditPolicy
extends SiriusContainerEditPolicy {
    protected Command getCreateCommand(CreateRequest request) {
        if (!(this.getHost().getModel() instanceof Node)) {
            return null;
        }
        EObject containerElement = ((Node)this.getHost().getModel()).getElement();
        AbstractToolDescription tool = this.getTool(request);
        Command result = null;
        if (containerElement instanceof DDiagramElementContainer) {
            DDiagramElementContainer viewNodeContainer = (DDiagramElementContainer)containerElement;
            if (tool instanceof NodeCreationDescription) {
                result = this.getCreateNodeInContainerCommand(request, (NodeCreationDescription)tool, viewNodeContainer);
            } else if (tool instanceof ContainerCreationDescription) {
                result = this.getCreateContainerInContainerCommand(request, (ContainerCreationDescription)tool, viewNodeContainer);
            }
        } else if (containerElement instanceof DNode) {
            DNode viewNode = (DNode)containerElement;
            if (tool instanceof NodeCreationDescription) {
                result = this.getCreateNodeOnNodeCommand(request, (NodeCreationDescription)tool, viewNode);
            }
        }
        return result;
    }

    protected Command getCreateNodeOnNodeCommand(CreateRequest request, NodeCreationDescription tool, DNode viewnode) {
        CreationUtil creationUtil = new CreationUtil(request, this.getDiagramCommandFactory(), this.getRealLocation(request), this.getHost());
        return creationUtil.getNodeCreationCommand(viewnode, tool);
    }

    protected Command getCreateContainerInContainerCommand(CreateRequest request, ContainerCreationDescription tool, DDiagramElementContainer viewNodeContainer) {
        CreationUtil creationUtil = new CreationUtil(request, this.getDiagramCommandFactory(), this.getRealLocation(request), this.getHost());
        return creationUtil.getContainerCreationDescription(viewNodeContainer, tool);
    }

    protected Command getCreateNodeInContainerCommand(CreateRequest request, NodeCreationDescription tool, DDiagramElementContainer viewNodeContainer) {
        CreationUtil creationUtil = new CreationUtil(request, this.getDiagramCommandFactory(), this.getRealLocation(request), this.getHost());
        return creationUtil.getNodeCreationCommand(viewNodeContainer, tool);
    }

    protected AbstractToolDescription getTool(CreateRequest request) {
        if (request.getNewObject() instanceof AbstractToolDescription) {
            return (AbstractToolDescription)request.getNewObject();
        }
        return null;
    }

    protected Point getRealLocation(CreateRequest request) {
        Point realLocation;
        Point location = request.getLocation().getCopy();
        if (location != null && this.getHost() instanceof GraphicalEditPart) {
            IFigure fig = ((GraphicalEditPart)this.getHost()).getFigure();
            fig.translateToRelative((Translatable)location);
            Point containerLocation = fig.getBounds().getLocation();
            location = new Point(location.x - containerLocation.x, location.y - containerLocation.y);
            if (fig instanceof ResizableCompartmentFigure) {
                Point scrollOffset = ((ResizableCompartmentFigure)fig).getScrollPane().getViewport().getViewLocation();
                Point shiftFromMarginOffset = FigureUtilities.getShiftFromMarginOffset((ResizableCompartmentFigure)fig, new RequestQuery((Request)request).isDropOrCreationOfBorderedNode(), this.getHost());
                realLocation = new Point(location.x + scrollOffset.x - shiftFromMarginOffset.x, location.y + scrollOffset.y - shiftFromMarginOffset.y);
            } else {
                realLocation = location;
            }
        } else {
            realLocation = location;
        }
        return realLocation;
    }

    private IDiagramCommandFactory getDiagramCommandFactory() {
        DDiagramEditor diagramEditor = (DDiagramEditor)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (diagramEditor == null) {
            return null;
        }
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)diagramEditor.getEditingDomain().getResourceSet());
        Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        IDiagramCommandFactory diagramCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
        return diagramCommandFactory;
    }
}

