/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.layout.PinHelper;

public class IsPinnedPredicate
implements Predicate<IGraphicalEditPart> {
    ArrayList<IDiagramElementEditPart> elementsToKeepFixed;

    protected IsPinnedPredicate(ArrayList<IDiagramElementEditPart> elementsToKeepFixed) {
        this.elementsToKeepFixed = elementsToKeepFixed;
    }

    public boolean apply(IGraphicalEditPart part) {
        boolean result = false;
        result = part instanceof NoteEditPart ? this.applyNote((NoteEditPart)part) : this.isPinnedOrKeepFixed(part);
        return result;
    }

    private boolean applyNote(NoteEditPart part) {
        boolean result = false;
        boolean connectedToPinnedElement = false;
        for (ConnectionEditPart sourceConn : Iterables.filter((Iterable)part.getSourceConnections(), ConnectionEditPart.class)) {
            if (!(sourceConn.getTarget() instanceof IGraphicalEditPart)) continue;
            boolean bl = connectedToPinnedElement = connectedToPinnedElement || this.isPinnedOrKeepFixed((IGraphicalEditPart)sourceConn.getTarget());
        }
        for (ConnectionEditPart targetConn : Iterables.filter((Iterable)part.getTargetConnections(), ConnectionEditPart.class)) {
            if (!(targetConn.getSource() instanceof IGraphicalEditPart)) continue;
            boolean bl = connectedToPinnedElement = connectedToPinnedElement || this.isPinnedOrKeepFixed((IGraphicalEditPart)targetConn.getSource());
        }
        if (connectedToPinnedElement) {
            result = true;
        } else if (!Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", SiriusDiagramPreferencesKeys.PREF_MOVE_NOTES_DURING_LATOUT.name(), false, null)) {
            result = true;
        }
        return result;
    }

    private boolean isPinnedOrKeepFixed(IGraphicalEditPart part) {
        boolean isPinnedOrKeepFixed = false;
        if (part.resolveSemanticElement() instanceof DDiagramElement) {
            DDiagramElement dDiagramElement = (DDiagramElement)part.resolveSemanticElement();
            isPinnedOrKeepFixed = new PinHelper().isPinned(dDiagramElement) || this.elementsToKeepFixed != null && this.elementsToKeepFixed.contains(part);
        }
        return isPinnedOrKeepFixed;
    }
}

