/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.helper.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayMode;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.query.CompositeFilterDescriptionQuery;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.Filter;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.filter.FilterKind;

public final class FilterService {
    private FilterService() {
    }

    public static List<FilterDescription> getAppliedFilters(DDiagram diagram, DDiagramElement element) {
        List<FilterDescription> filters = FilterService.sortFilters(diagram.getActivatedFilters());
        if (filters.isEmpty()) {
            return Collections.emptyList();
        }
        return FilterService.getAppliedFiltersOnElement(filters, element);
    }

    private static List<FilterDescription> getAppliedFiltersOnElement(List<FilterDescription> filters, DDiagramElement element) {
        ArrayList<FilterDescription> result = new ArrayList<FilterDescription>();
        for (FilterDescription filter : filters) {
            if (filter.isVisible(element)) continue;
            result.add(filter);
        }
        return result;
    }

    public static boolean isCollapsed(DDiagram diagram, DDiagramElement element) {
        DslCommonPlugin.PROFILER.startWork("FilterService : is the element collapsed ?");
        boolean isCollapsed = false;
        if (DisplayServiceManager.INSTANCE.getMode() != DisplayMode.ALL_IS_DISPLAYED) {
            isCollapsed = FilterService.isCollapsed(FilterService.sortFilters(diagram.getActivatedFilters()), element);
        }
        DslCommonPlugin.PROFILER.stopWork("FilterService : is the element collapsed ?");
        return isCollapsed;
    }

    private static boolean isCollapsed(Collection<FilterDescription> sortedFilters, DDiagramElement element) {
        boolean isCollapsed = false;
        Iterator<FilterDescription> it = sortedFilters.iterator();
        block0: while (it.hasNext() && !isCollapsed) {
            FilterDescription filter = it.next();
            if (!(filter instanceof CompositeFilterDescription)) continue;
            CompositeFilterDescriptionQuery query = new CompositeFilterDescriptionQuery((CompositeFilterDescription)filter);
            for (Filter currentFilter : query.getCollapseFilters()) {
                isCollapsed = FilterService.isFilterCollapsed(currentFilter, element);
                if (isCollapsed) continue block0;
            }
        }
        return isCollapsed;
    }

    private static boolean isFilterCollapsed(Filter filter, DDiagramElement element) {
        return filter.getFilterKind() == FilterKind.COLLAPSE_LITERAL && !filter.isVisible(element);
    }

    private static List<FilterDescription> sortFilters(Collection<FilterDescription> filters) {
        ArrayList<FilterDescription> result = new ArrayList<FilterDescription>(filters);
        Collections.sort(result, new Comparator<FilterDescription>(){

            private boolean ownsACollapsedFilter(FilterDescription filterDescription) {
                if (filterDescription instanceof CompositeFilterDescription) {
                    CompositeFilterDescriptionQuery query = new CompositeFilterDescriptionQuery((CompositeFilterDescription)filterDescription);
                    return !query.getCollapseFilters().isEmpty();
                }
                return false;
            }

            @Override
            public int compare(FilterDescription o1, FilterDescription o2) {
                FilterDescription filterDescription0 = o1;
                FilterDescription filterDescription1 = o2;
                boolean hasCollapse0 = this.ownsACollapsedFilter(filterDescription0);
                boolean hasCollapse1 = this.ownsACollapsedFilter(filterDescription1);
                int result = 0;
                result = hasCollapse0 && !hasCollapse1 ? 1 : (hasCollapse1 && !hasCollapse0 ? -1 : filterDescription0.hashCode() - filterDescription1.hashCode());
                return result;
            }
        });
        return result;
    }
}

