/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.spec;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.util.EObjectCouple;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.AbstractNodeMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DSemanticDiagramHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.DDiagramElementSpecOperations;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.impl.DNodeImpl;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;

public class DNodeSpec
extends DNodeImpl {
    public DiagramElementMapping getMapping() {
        return this.getActualMapping();
    }

    public void refresh() {
        if (this.getActualMapping() != null) {
            this.getActualMapping().updateNode(this);
            Iterator iter = this.getOwnedBorderedNodes().iterator();
            HashSet<EObjectCouple> managedBorderingNodes = new HashSet<EObjectCouple>();
            while (iter.hasNext()) {
                DNode n = (DNode)iter.next();
                n.refresh();
                managedBorderingNodes.add(new EObjectCouple(n.getTarget(), (EObject)n.getActualMapping()));
            }
            AbstractNodeMappingSpecOperations.createBorderingNodes(this.getActualMapping(), this.getTarget(), this, managedBorderingNodes, this.getParentDiagram());
        }
    }

    public Style getStyle() {
        return this.getOwnedStyle();
    }

    @Override
    public DDiagram getParentDiagram() {
        return DDiagramElementSpecOperations.getParentDiagram(this);
    }

    @Override
    public boolean validate() {
        DslCommonPlugin.PROFILER.startWork("Validating the node");
        if (this.getTarget() != null && this.getFirstParentWithSemantic() != null && this.getActualMapping() != null) {
            EObject mySemanticElement = this.getTarget();
            DSemanticDecorator representedParent = this.getFirstParentWithSemantic();
            EObject representedParentSemantic = this.getFirstParentWithSemantic().getTarget();
            if (representedParent instanceof DSemanticDiagram) {
                representedParentSemantic = DSemanticDiagramHelper.getRootContent((DSemanticDiagram)representedParent);
            }
            if (!this.getActualMapping().getNodesCandidates(representedParentSemantic, representedParent.getTarget(), this.eContainer()).contains((Object)mySemanticElement)) {
                DslCommonPlugin.PROFILER.stopWork("Validating the node");
                return false;
            }
        }
        DslCommonPlugin.PROFILER.stopWork("Validating the node");
        return true;
    }

    public DSemanticDecorator getFirstParentWithSemantic() {
        DSemanticDecorator result = null;
        EObject cur = this.eContainer();
        while (cur != null && result == null) {
            if (cur instanceof DSemanticDecorator) {
                result = (DSemanticDecorator)cur;
            }
            cur = cur.eContainer();
        }
        return result;
    }

    @Override
    public DragAndDropTargetDescription getDragAndDropDescription() {
        return this.getActualMapping();
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("Node");
        if (this.getName() != null && this.getName().length() > 0) {
            result.append(" ");
            result.append(this.getName());
        }
        if (this.getTarget() != null) {
            result.append(" --> ");
            result.append(this.getTarget().toString());
        }
        return result.toString();
    }
}

