/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import java.util.Set;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;

public class HideDDiagramElementLabel
extends RecordingCommand {
    public static final String HIDE_LABEL = "Hide label";
    public static final String HIDE_LABELS = "Hide labels";
    private final Set<?> objectsToHide;

    public HideDDiagramElementLabel(TransactionalEditingDomain domain, Set<?> elementsToHide) {
        super(domain);
        if (elementsToHide != null && elementsToHide.size() > 1) {
            this.setLabel(HIDE_LABELS);
        } else {
            this.setLabel(HIDE_LABEL);
        }
        this.objectsToHide = elementsToHide;
    }

    protected void setInvisible(DDiagramElement element) {
        DDiagramElementQuery diagramElementQuery = new DDiagramElementQuery(element);
        if (!diagramElementQuery.isLabelHidden() && diagramElementQuery.canHideLabel()) {
            HideFilterHelper.INSTANCE.hideLabel(element);
        }
    }

    protected void doExecute() {
        for (Object obj : this.objectsToHide) {
            if (!(obj instanceof DDiagramElement)) continue;
            this.setInvisible((DDiagramElement)obj);
        }
    }
}

