/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.editor.properties.sections.style.nodestyledescription;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.diagram.description.style.StylePackage;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.sections.common.AbstractTextPropertySection;
import org.eclipse.sirius.ui.tools.api.assist.ContentProposalClient;
import org.eclipse.sirius.ui.tools.api.assist.IAssistContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class NodeStyleDescriptionSizeComputationExpressionPropertySection
extends AbstractTextPropertySection
implements ContentProposalClient {
    protected CLabel help;

    public void refresh() {
        super.refresh();
        String tooltip = this.getToolTipText();
        if (tooltip != null && this.help != null) {
            this.help.setToolTipText(this.getToolTipText());
        }
    }

    protected String getDefaultLabelText() {
        return "SizeComputationExpression";
    }

    protected String getLabelText() {
        String labelText = String.valueOf(super.getLabelText()) + ":";
        return labelText;
    }

    public EAttribute getFeature() {
        return StylePackage.eINSTANCE.getNodeStyleDescription_SizeComputationExpression();
    }

    protected Object getFeatureValue(String newText) {
        return newText;
    }

    protected boolean isEqual(String newText) {
        return this.getFeatureAsText().equals(newText);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.text.setBackground(SiriusEditor.getColorRegistry().get("yellow"));
        this.text.setToolTipText(this.getToolTipText());
        this.help = this.getWidgetFactory().createCLabel(this.composite, "");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.text, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        this.help.setLayoutData((Object)data);
        this.help.setFont(SiriusEditor.getFontRegistry().get("description"));
        this.help.setImage(this.getHelpIcon());
        this.help.setToolTipText(this.getToolTipText());
        List extension = EclipseUtil.getExtensionPlugins(IAssistContentProvider.class, (String)"org.eclipse.sirius.ui.assistContentProvider", (String)"class");
        if (extension.size() != 0) {
            IAssistContentProvider contentProposalAdapter = (IAssistContentProvider)extension.get(0);
            contentProposalAdapter.setView((AbstractPropertySection)this);
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
            TriggerSequence[] activeBindinds = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
            if (activeBindinds != null && activeBindinds.length > 0) {
                TriggerSequence sequence = activeBindinds[0];
                KeyStroke keyStroke = this.getKeyStroke(sequence);
                TextContentAdapter textContentAdapter = new TextContentAdapter();
                ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)textContentAdapter, (IContentProposalProvider)contentProposalAdapter, keyStroke, IAssistContentProvider.AUTO_ACTIVATION_CHARACTERS);
                adapter.setPopupSize(new Point(300, 100));
                adapter.addContentProposalListener((IContentProposalListener2)contentProposalAdapter);
            }
        }
    }

    private KeyStroke getKeyStroke(TriggerSequence sequence) {
        Trigger[] triggerArray = sequence.getTriggers();
        int n = triggerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Trigger trigger = triggerArray[n2];
            if (trigger instanceof KeyStroke) {
                return (KeyStroke)trigger;
            }
            ++n2;
        }
        return null;
    }

    protected String getPropertyDescription() {
        return "";
    }

    protected String getToolTipText() {
        String tooltip;
        String superTooltip = super.getToolTipText();
        if (this.needsCustomTooltip()) {
            StringBuilder sb = new StringBuilder();
            sb.append("-1 will force the node to have the real image size.");
            sb.append("\n");
            sb.append(superTooltip);
            tooltip = sb.toString();
        } else {
            tooltip = superTooltip;
        }
        return tooltip;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.needsCustomTooltip()) {
            String toolTipText = this.getToolTipText();
            this.text.setToolTipText(toolTipText);
            this.help.setToolTipText(toolTipText);
        }
    }

    private boolean needsCustomTooltip() {
        boolean customEObjectListTooltip;
        boolean customEObjectTooltip = this.eObject instanceof WorkspaceImageDescription;
        boolean bl = customEObjectListTooltip = this.eObjectList != null && !this.eObjectList.isEmpty() && !Iterables.isEmpty((Iterable)Iterables.filter((Iterable)this.eObjectList, WorkspaceImageDescription.class));
        return customEObjectTooltip || customEObjectListTooltip;
    }
}

