/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.editor.properties.sections.description.spec.foregroundstyledescription;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.sections.common.AbstractCheckBoxGroupPropertySection;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.ForegroundStyleDescription;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ForegroundStyleDescriptionLabelFormatPropertySection
extends AbstractCheckBoxGroupPropertySection {
    private static final String BOLD = "Bold";
    private static final String ITALIC = "Italic";
    private static final String TOOL_TIP = "The font formatting style to use for the label";

    public ForegroundStyleDescriptionLabelFormatPropertySection() {
        this.buttonGroup = false;
    }

    protected boolean isEqual(List<?> newList) {
        List<String> value = ForegroundStyleDescriptionLabelFormatPropertySection.convertPropertiesToUI(((ForegroundStyleDescription)this.eObject).getLabelFormat());
        return value.equals(newList);
    }

    protected List<?> getChoiceOfValues() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(BOLD);
        values.add(ITALIC);
        return values;
    }

    private FontFormat getSelectedValue() {
        List<?> possibleValues = this.getChoiceOfValues();
        ArrayList selectedValues = new ArrayList();
        int i = 0;
        while (i < this.button.length) {
            if (this.button[i].getSelection()) {
                selectedValues.add(possibleValues.get(i));
            }
            ++i;
        }
        FontFormat fontFormat = selectedValues.isEmpty() ? FontFormat.NORMAL_LITERAL : (selectedValues.size() == 1 ? (selectedValues.get(0).equals(ITALIC) ? FontFormat.ITALIC_LITERAL : FontFormat.BOLD_LITERAL) : FontFormat.BOLD_ITALIC_LITERAL);
        return fontFormat;
    }

    protected EStructuralFeature getFeature() {
        return DescriptionPackage.eINSTANCE.getForegroundStyleDescription_LabelFormat();
    }

    protected String getDefaultLabelText() {
        return "Label Format";
    }

    protected String getFeatureAsText() {
        EStructuralFeature eFeature = this.getFeature();
        IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(eFeature);
        if (propertyDescriptor != null) {
            String featureText = propertyDescriptor.getLabelProvider((Object)this.eObject).getText(this.eObject.eGet(eFeature)).replace(" ", ", ");
            return featureText;
        }
        return this.getDefaultFeatureAsText();
    }

    protected String getDefaultFeatureAsText() {
        String returnStr = "";
        if (this.eObject instanceof ForegroundStyleDescription) {
            for (String str : ForegroundStyleDescriptionLabelFormatPropertySection.convertPropertiesToUI(((ForegroundStyleDescription)this.eObject).getLabelFormat())) {
                returnStr = returnStr.length() > 0 ? String.valueOf(returnStr) + ", " + str : str;
            }
        }
        return returnStr;
    }

    protected String getLabelText() {
        return String.valueOf(super.getLabelText()) + ":";
    }

    protected EEnum getFeatures() {
        return ViewpointPackage.eINSTANCE.getFontFormat();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite fakeGroup = this.getWidgetFactory().createComposite(this.composite);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginLeft = 0;
        rowLayout.spacing = 5;
        fakeGroup.setLayout((Layout)rowLayout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        fakeGroup.setLayoutData((Object)data);
        int i = 0;
        while (i < this.button.length) {
            this.button[i].setParent(fakeGroup);
            this.button[i].setLayoutData(null);
            ++i;
        }
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)fakeGroup, -25);
        data.top = new FormAttachment((Control)fakeGroup, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        this.nameLabel.setToolTipText(TOOL_TIP);
        data = new FormData();
        CLabel help = this.getWidgetFactory().createCLabel(this.composite, "");
        data.top = new FormAttachment((Control)this.nameLabel, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        help.setLayoutData((Object)data);
        help.setFont(SiriusEditor.getFontRegistry().get("description"));
        help.setImage(this.getHelpIcon());
        help.setToolTipText(TOOL_TIP);
    }

    public void handleSelectionChanged() {
        boolean equals = this.isEqual(this.getSelectedValues());
        if (!equals) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            FontFormat value = this.getSelectedValue();
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    private static List<String> convertPropertiesToUI(FontFormat font) {
        ArrayList<String> formats = new ArrayList<String>();
        if (font.getValue() == 1) {
            formats.add(ITALIC);
        } else if (font.getValue() == 2) {
            formats.add(BOLD);
        } else if (font.getValue() == 3) {
            formats.add(ITALIC);
            formats.add(BOLD);
        }
        return formats;
    }
}

