/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.description.DeleteTool;
import org.eclipse.sirius.table.metamodel.table.description.TableTool;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractTargetColumnAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.command.DeleteElementRecordingCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class DeleteTargetColumnAction
extends AbstractTargetColumnAction {
    private static final String DEFAULT_NAME = "Delete column";

    public DeleteTargetColumnAction(DeleteTool deleteTool, TransactionalEditingDomain editingDomain, ITableCommandFactory tableCommandFactory) {
        super(DEFAULT_NAME, DTableViewerManager.getImageRegistry().getDescriptor("table/delete"), editingDomain, tableCommandFactory, (TableTool)deleteTool);
        this.setToolTipText("Delete the target semantic element");
        if (this.getDeleteTool() != null) {
            this.setText(new IdentifiedElementQuery((IdentifiedElement)this.getDeleteTool()).getLabel());
            this.setToolTipText(this.getDeleteTool().getDocumentation());
        }
    }

    public void run() {
        super.run();
        this.getEditingDomain().getCommandStack().execute((Command)new DeleteElementRecordingCommand(this.getEditingDomain(), this.getText(), this.tableCommandFactory, (DTableElement)this.getColumn()));
    }

    @Override
    public boolean canExecute() {
        boolean canExecute = true;
        if (this.getDeleteTool() != null) {
            if (this.getDeleteTool().getFirstModelOperation() == null) {
                canExecute = false;
            } else if (this.getDeleteTool().getPrecondition() != null && !StringUtil.isEmpty((String)this.getDeleteTool().getPrecondition().trim())) {
                IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)this.getColumn().getTarget());
                interpreter.setVariable("root", (Object)TableHelper.getTable((EObject)this.getColumn()).getTarget());
                interpreter.setVariable("element", (Object)this.getColumn().getTarget());
                interpreter.setVariable("container", (Object)((DTable)this.getColumn().eContainer()).getTarget());
                try {
                    canExecute = interpreter.evaluateBoolean(this.getColumn().getTarget(), this.getDeleteTool().getPrecondition());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)this.getDeleteTool(), (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                }
                interpreter.unSetVariable("root");
                interpreter.unSetVariable("element");
                interpreter.unSetVariable("container");
            }
        }
        return canExecute;
    }

    public DeleteTool getDeleteTool() {
        DeleteTool tool = null;
        TableTool tableTool = this.getTool();
        if (tableTool instanceof DeleteTool) {
            tool = (DeleteTool)tableTool;
        }
        return tool;
    }
}

