/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.dialect;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.AbstractRepresentationDialectServices;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.contribution.ContributionPointHelper;
import org.eclipse.sirius.business.internal.contribution.IncrementalModelContributor;
import org.eclipse.sirius.business.internal.contribution.IntrinsicPathIdentifier;
import org.eclipse.sirius.business.internal.contribution.ModelContributorAdapter;
import org.eclipse.sirius.business.internal.contribution.ReferenceResolver;
import org.eclipse.sirius.business.internal.contribution.RepresentationExtensionsFinder;
import org.eclipse.sirius.business.internal.contribution.SiriusReferenceResolver;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.description.contribution.ContributionPoint;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.table.business.internal.dialect.ContributionTrakingIdentifier;
import org.eclipse.sirius.table.business.internal.dialect.TableContributionsFinder;
import org.eclipse.sirius.table.business.internal.dialect.TableModelContributor;
import org.eclipse.sirius.table.business.internal.dialect.description.TableInterpretedExpressionQuery;
import org.eclipse.sirius.table.business.internal.refresh.DTableSynchronizerImpl;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.table.metamodel.table.description.EditionTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.tools.internal.command.TableCommandFactory;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class TableDialectServices
extends AbstractRepresentationDialectServices {
    public static boolean isHandledByMovida(DRepresentation representation) {
        return Movida.isEnabled() && representation instanceof DTable && ((DTable)representation).getDescription() instanceof EditionTableDescription;
    }

    protected boolean isSupported(DRepresentation representation) {
        return representation instanceof DTable;
    }

    protected boolean isSupported(RepresentationDescription description) {
        return description instanceof TableDescription;
    }

    public boolean canCreate(EObject semantic, RepresentationDescription desc) {
        boolean result = false;
        if (semantic != null && this.isSupported(desc)) {
            TableDescription tableDesc = (TableDescription)desc;
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semantic);
            if (accessor != null) {
                result = this.checkDomainClass(accessor, semantic, tableDesc.getDomainClass());
            }
            result = result && this.checkPrecondition(semantic, tableDesc.getPreconditionExpression());
        }
        return result;
    }

    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, IProgressMonitor monitor) {
        DTable table = null;
        try {
            monitor.beginTask("Create table : " + name, 11);
            monitor.subTask("Create table : " + name);
            table = TableFactory.eINSTANCE.createDTable();
            table.setName(name);
            table.setTarget(semantic);
            table.setDescription((TableDescription)description);
            if (TableDialectServices.isHandledByMovida(table)) {
                this.refreshEffectiveRepresentationDescription(table, monitor);
            }
            monitor.worked(1);
            this.refresh(table, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        finally {
            monitor.done();
        }
        return table;
    }

    public void updateRepresentationsExtendedBy(Session session, Viewpoint viewpoint, boolean activated) {
        if (Movida.isEnabled()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            for (DView view : session.getOwnedViews()) {
                for (DRepresentation representation : view.getAllRepresentations()) {
                    RepresentationExtensionsFinder ref;
                    if (!TableDialectServices.isHandledByMovida(representation) || !(ref = new RepresentationExtensionsFinder((RepresentationDescription)((DTable)representation).getDescription())).isAffectedBy(viewpoint)) continue;
                    this.refreshEffectiveRepresentationDescription(representation, (IProgressMonitor)monitor);
                    this.refresh(representation, (IProgressMonitor)monitor);
                }
            }
        }
    }

    public void refreshEffectiveRepresentationDescription(DRepresentation representation, IProgressMonitor monitor) {
        if (!TableDialectServices.isHandledByMovida(representation)) {
            return;
        }
        DTable table = (DTable)representation;
        Session session = SessionManager.INSTANCE.getSession(table.getTarget());
        IncrementalModelContributor imc = this.getModelContributor(session, table);
        imc.apply((EObject)table.getDescription(), (Collection)new RepresentationExtensionsFinder((RepresentationDescription)table.getDescription()).findAllRelevantViewpoints(session));
        Supplier<EObject> efSupplier = new Supplier<EObject>(){

            public EObject get() {
                return null;
            }
        };
        Supplier<EList<ContributionPoint>> cpSupplier = new Supplier<EList<ContributionPoint>>(){

            public EList<ContributionPoint> get() {
                return null;
            }
        };
        this.updateContributionPoints(table, efSupplier, cpSupplier, imc);
    }

    private IncrementalModelContributor getModelContributor(Session session, DTable table) {
        ModelContributorAdapter mca = ModelContributorAdapter.find((EObject)table);
        if (mca == null) {
            mca = ModelContributorAdapter.attach((EObject)table, (IncrementalModelContributor)this.createModelContributor(session, table));
        }
        return mca.getModelContributor();
    }

    private IncrementalModelContributor createModelContributor(Session session, DTable table) {
        Supplier<EObject> efSupplier = new Supplier<EObject>(){

            public EObject get() {
                return null;
            }
        };
        Supplier<Iterable<ContributionPoint>> cpSupplier = new Supplier<Iterable<ContributionPoint>>(){

            public Iterable<ContributionPoint> get() {
                return null;
            }
        };
        SiriusReferenceResolver resolver = new SiriusReferenceResolver(session.getInterpreter());
        ContributionTrakingIdentifier idFunction = new ContributionTrakingIdentifier(efSupplier, cpSupplier, (Function<EObject, String>)new IntrinsicPathIdentifier());
        TableModelContributor imc = new TableModelContributor(new TableContributionsFinder(table.getDescription()), (ReferenceResolver)resolver, idFunction);
        if (efSupplier.get() != null) {
            HashMap restoredIdentifiers = Maps.newHashMap();
            for (EObject obj : AllContents.of((EObject)((EObject)efSupplier.get()), (boolean)true)) {
                restoredIdentifiers.put(obj, idFunction.apply(obj));
            }
            imc.resetState((EObject)efSupplier.get(), restoredIdentifiers);
        }
        return imc;
    }

    private void updateContributionPoints(DTable table, Supplier<EObject> efSupplier, Supplier<EList<ContributionPoint>> cpSupplier, IncrementalModelContributor imc) {
        ArrayList newPoints = Lists.newArrayList();
        newPoints.add(ContributionPointHelper.make((EObject)((EObject)efSupplier.get()), (String)new IntrinsicPathIdentifier().apply((EObject)table.getDescription())));
        Map cps = imc.getContributionPoints();
        for (Map.Entry entry : cps.entrySet()) {
            newPoints.add(ContributionPointHelper.make((EObject)((EObject)entry.getKey()), (String)((String)entry.getValue())));
        }
        for (EObject imported : ((TableDescription)efSupplier.get()).getImportedElements()) {
            newPoints.add(ContributionPointHelper.make((EObject)imported, (String)((String)imc.getIdentifier(imported))));
        }
        ContributionPointHelper.updateIfNeeded((EList)((EList)cpSupplier.get()), (List)newPoints);
    }

    public void refresh(DRepresentation representation, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Refresh table", 1);
            DTable table = (DTable)representation;
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(table.getTarget());
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)representation);
            Supplier<EObject> efSupplier = new Supplier<EObject>(){

                public EObject get() {
                    return null;
                }
            };
            if (TableDialectServices.isHandledByMovida(table) && efSupplier.get() == null) {
                this.refreshEffectiveRepresentationDescription(representation, monitor);
                monitor.worked(1);
            }
            TableDescription description = TableDialectServices.isHandledByMovida(table) ? (TableDescription)efSupplier.get() : table.getDescription();
            DTableSynchronizerImpl sync = new DTableSynchronizerImpl(description, accessor, interpreter);
            sync.setTable(table);
            sync.refresh((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    public RepresentationDescription getDescription(DRepresentation representation) {
        if (this.isSupported(representation)) {
            return ((DTable)representation).getDescription();
        }
        return null;
    }

    public void initRepresentations(Viewpoint vp, EObject semantic) {
        super.initRepresentations(semantic, vp, TableDescription.class);
    }

    public void initRepresentations(Viewpoint vp, EObject semantic, IProgressMonitor monitor) {
        super.initRepresentations(semantic, vp, TableDescription.class, monitor);
    }

    protected <T extends RepresentationDescription> void initRepresentationForElement(T representationDescription, EObject semanticElement, IProgressMonitor monitor) {
        TableDescription tableDescription;
        if (representationDescription instanceof TableDescription && this.shouldInitializeRepresentation(semanticElement, tableDescription = (TableDescription)representationDescription, tableDescription.getDomainClass())) {
            ModelAccessor modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semanticElement);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)semanticElement);
            if (modelAccessor.eInstanceOf(semanticElement, tableDescription.getDomainClass())) {
                boolean canCreate = true;
                if (tableDescription.getPreconditionExpression() != null && !StringUtil.isEmpty((String)tableDescription.getPreconditionExpression())) {
                    try {
                        canCreate = InterpreterUtil.getInterpreter((EObject)semanticElement).evaluateBoolean(semanticElement, tableDescription.getPreconditionExpression());
                    }
                    catch (EvaluationException evaluationException) {
                        canCreate = false;
                    }
                }
                if (canCreate) {
                    try {
                        monitor.beginTask("Initialize table of type " + new IdentifiedElementQuery(representationDescription).getLabel(), 1);
                        TableCommandFactory tableCommandFactory = new TableCommandFactory(domain);
                        tableCommandFactory.setModelAccessor(modelAccessor);
                        DCommand command = tableCommandFactory.buildCreateTableFromDescription(tableDescription, semanticElement, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        domain.getCommandStack().execute((Command)command);
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        }
    }

    public DRepresentation copyRepresentation(DRepresentation representation, String name, Session session, IProgressMonitor monitor) {
        DRepresentation newRepresentation = super.copyRepresentation(representation, name, session, monitor);
        session.getServices().putCustomData("DREPRESENTATION", ((DSemanticDecorator)representation).getTarget(), (EObject)newRepresentation);
        return newRepresentation;
    }

    public IInterpretedExpressionQuery createInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        return new TableInterpretedExpressionQuery(target, feature);
    }

    public boolean handles(RepresentationDescription representationDescription) {
        return representationDescription instanceof TableDescription;
    }

    public boolean handles(RepresentationExtensionDescription representationExtensionDescription) {
        return false;
    }
}

