/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.tools.internal.export;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.tools.api.export.TableExportHelper;
import org.eclipse.sirius.table.tools.internal.TablePlugin;
import org.eclipse.sirius.table.tools.internal.export.csv.TableCsvHelper;

public final class TableExportHelperImpl
implements TableExportHelper {
    private static final String EXCEPTION_ON_SAVE_CONTENT = "Error while saving the exported content.";

    private TableExportHelperImpl() {
    }

    public static TableExportHelper init() {
        return new TableExportHelperImpl();
    }

    @Override
    public void saveContent(String content, String fileName) {
        File file = new File(fileName);
        FileOutputStream outputStream = null;
        try {
            try {
                outputStream = new FileOutputStream(file);
                outputStream.write(content.getBytes());
            }
            catch (FileNotFoundException exception) {
                TablePlugin.getDefault().error(EXCEPTION_ON_SAVE_CONTENT, exception);
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException exception2) {
                    TablePlugin.getDefault().error(EXCEPTION_ON_SAVE_CONTENT, exception2);
                }
            }
            catch (IOException exception) {
                TablePlugin.getDefault().error(EXCEPTION_ON_SAVE_CONTENT, exception);
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException exception3) {
                    TablePlugin.getDefault().error(EXCEPTION_ON_SAVE_CONTENT, exception3);
                }
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException exception) {
                TablePlugin.getDefault().error(EXCEPTION_ON_SAVE_CONTENT, exception);
            }
        }
    }

    @Override
    public String exportToCsv(DTable table) {
        Iterable<Iterable<String>> tableDescriptors = TableCsvHelper.getTableDescriptor(table);
        StringBuilder contentBuilder = new StringBuilder();
        for (Iterable<String> line : tableDescriptors) {
            for (String cellValue : line) {
                contentBuilder.append(cellValue).append(';');
            }
            contentBuilder.append('\n');
        }
        return contentBuilder.toString();
    }
}

