/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.provider;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.description.TreeDragSource;
import org.eclipse.sirius.tree.description.TreeItemContainerDropTool;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TransferData;

public class DTreeItemDropListener
extends ViewerDropAdapter
implements DropTargetListener {
    private static final String MORE_THAN_ONE_DROP_DESCRIPTION_ERROR_MSG = "There are more than one drop description that match the dropped element";
    private TransactionalEditingDomain domain;
    private ModelAccessor accessor;
    private ITreeCommandFactory commandFactory;
    private final Set<DSemanticDecorator> droppedData = Sets.newLinkedHashSet();
    private final Map<EObject, TreeItemContainerDropTool> semanticDroppedData = Maps.newLinkedHashMap();
    private DTreeItemContainer dropTarget;
    private final Collection<DTreeItem> precedingSiblings = Lists.newArrayList();

    public DTreeItemDropListener(Viewer viewer, TransactionalEditingDomain domain, ITreeCommandFactory treeCommandFactory, ModelAccessor accessor) {
        super(viewer);
        this.domain = domain;
        this.commandFactory = treeCommandFactory;
        this.accessor = accessor;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        this.resetContext();
        this.computeContext(target, operation, transferType);
        boolean valid = this.validateContext();
        if (!valid) {
            this.resetContext();
        }
        return valid;
    }

    private void resetContext() {
        this.dropTarget = null;
        this.precedingSiblings.clear();
        this.droppedData.clear();
        this.semanticDroppedData.clear();
    }

    private void computeContext(Object target, int operation, TransferData transferType) {
        this.computeDropTargetAndPrecedingSiblings(target);
        this.computeDraggedDataFromLocalSelectionTransfer();
    }

    private void computeDropTargetAndPrecedingSiblings(Object target) {
        int currentLocation = this.getCurrentLocation();
        Object mouseTarget = target;
        if (mouseTarget == null) {
            mouseTarget = this.getViewer().getInput();
            currentLocation = 3;
        }
        if (mouseTarget instanceof DTreeItem) {
            DTreeItem itemMouseTarget = (DTreeItem)mouseTarget;
            if (currentLocation == 1 || currentLocation == 2) {
                if (itemMouseTarget.eContainer() instanceof DTreeItemContainer) {
                    this.dropTarget = (DTreeItemContainer)itemMouseTarget.eContainer();
                }
            } else {
                this.dropTarget = (DTreeItem)mouseTarget;
            }
        } else if (mouseTarget instanceof DTree) {
            this.dropTarget = (DTree)mouseTarget;
        }
        this.precedingSiblings.clear();
        if (this.dropTarget != null) {
            EList ownedTreeItems = this.dropTarget.getOwnedTreeItems();
            if (currentLocation == 1 || currentLocation == 2) {
                if (mouseTarget instanceof DTreeItem) {
                    DTreeItem ticMouseTarget = (DTreeItem)mouseTarget;
                    int dropTargetIndex = ownedTreeItems.indexOf(ticMouseTarget);
                    if (dropTargetIndex > 0) {
                        this.precedingSiblings.addAll(ownedTreeItems.subList(0, dropTargetIndex));
                    }
                    if (currentLocation == 2) {
                        this.precedingSiblings.add(ticMouseTarget);
                    }
                }
            } else {
                this.precedingSiblings.addAll((Collection<DTreeItem>)this.dropTarget.getOwnedTreeItems());
            }
        }
    }

    private void computeDraggedDataFromLocalSelectionTransfer() {
        block4: {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            this.droppedData.clear();
            this.semanticDroppedData.clear();
            if (!(selection instanceof IStructuredSelection)) break block4;
            IStructuredSelection sel = (IStructuredSelection)selection;
            Iterable dSelection = Iterables.filter((Iterable)sel.toList(), DSemanticDecorator.class);
            if (!Iterables.isEmpty((Iterable)dSelection)) {
                for (DSemanticDecorator semDec : dSelection) {
                    this.droppedData.add(semDec);
                    this.semanticDroppedData.put(semDec.getTarget(), null);
                }
            } else {
                for (EObject eobject : Iterables.filter((Iterable)sel.toList(), EObject.class)) {
                    this.semanticDroppedData.put(eobject, null);
                }
            }
        }
    }

    private boolean validateContext() {
        boolean valid;
        block12: {
            valid = false;
            if (this.dropTarget == null || this.semanticDroppedData.isEmpty()) break block12;
            boolean bl = valid = !this.sourceIsTargetContainer();
            if (valid) {
                valid = this.canEditSemanticDecorator((DSemanticDecorator)this.dropTarget);
                if (!this.droppedData.isEmpty()) {
                    for (DSemanticDecorator dSem : this.droppedData) {
                        Option<TreeItemContainerDropTool> dropTool;
                        valid = valid && this.canEditSemanticDecorator(dSem);
                        EObject oldContainer = null;
                        if (dSem.eContainer() instanceof DSemanticDecorator) {
                            oldContainer = ((DSemanticDecorator)dSem.eContainer()).getTarget();
                        }
                        if ((dropTool = this.getBestDropDescription(dSem.getTarget(), oldContainer, TreeDragSource.TREE, dSem)).some()) {
                            this.semanticDroppedData.put(dSem.getTarget(), (TreeItemContainerDropTool)dropTool.get());
                        } else {
                            valid = false;
                        }
                        if (valid) {
                            continue;
                        }
                        break;
                    }
                } else {
                    for (EObject droppedElement : Lists.newArrayList(this.semanticDroppedData.keySet())) {
                        valid = valid && this.canEditEObject(droppedElement);
                        Option<TreeItemContainerDropTool> dropTool = this.getBestDropDescription(droppedElement, null, TreeDragSource.PROJECT_EXPLORER, null);
                        if (dropTool.some()) {
                            this.semanticDroppedData.put(droppedElement, (TreeItemContainerDropTool)dropTool.get());
                        } else {
                            valid = false;
                        }
                        if (valid) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        return valid;
    }

    private boolean sourceIsTargetContainer() {
        DTreeItemContainer targetContainer = this.dropTarget;
        while (targetContainer instanceof DTreeItem) {
            if (this.droppedData.contains(targetContainer)) {
                return true;
            }
            targetContainer = ((DTreeItem)targetContainer).getContainer();
        }
        return false;
    }

    public boolean performDrop(Object data) {
        CompoundCommand dndCommand;
        boolean dropped = false;
        if (this.dropTarget != null && (dndCommand = this.buildCommand()).canExecute()) {
            this.domain.getCommandStack().execute((Command)dndCommand);
            dropped = true;
        }
        this.resetContext();
        return dropped;
    }

    private CompoundCommand buildCommand() {
        CompoundCommand dndCommand = new CompoundCommand("Drag And Drop");
        if (!this.droppedData.isEmpty()) {
            for (DSemanticDecorator semDec : this.droppedData) {
                EObject droppedElement = semDec.getTarget();
                TreeItemContainerDropTool tool = this.semanticDroppedData.get(droppedElement);
                if (tool == null) {
                    dndCommand.append((Command)UnexecutableCommand.INSTANCE);
                }
                dndCommand.append(this.commandFactory.buildDropItemFromTool((EObject)semDec, this.dropTarget, this.precedingSiblings, tool));
            }
        } else {
            for (Map.Entry<EObject, TreeItemContainerDropTool> entry : this.semanticDroppedData.entrySet()) {
                if (entry.getValue() == null) {
                    dndCommand.append((Command)UnexecutableCommand.INSTANCE);
                }
                dndCommand.append(this.commandFactory.buildDropItemFromTool(entry.getKey(), this.dropTarget, this.precedingSiblings, entry.getValue()));
            }
        }
        return dndCommand;
    }

    protected boolean canEditSemanticDecorator(DSemanticDecorator decorator) {
        IPermissionAuthority authority = this.accessor != null ? this.accessor.getPermissionAuthority() : null;
        boolean canEdit = authority != null && authority.canEditInstance(decorator.getTarget());
        canEdit = canEdit && authority.canEditInstance((EObject)decorator);
        return canEdit;
    }

    protected boolean canEditEObject(EObject obj) {
        IPermissionAuthority authority = this.accessor != null ? this.accessor.getPermissionAuthority() : null;
        boolean canEdit = authority != null && authority.canEditInstance(obj);
        return canEdit;
    }

    private Option<TreeItemContainerDropTool> getBestDropDescription(EObject droppedElement, EObject oldContainer, TreeDragSource dragSource, DSemanticDecorator droppedSemanticDecorator) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(droppedElement);
        if (oldContainer != null) {
            interpreter.setVariable("oldContainer", (Object)oldContainer);
        }
        interpreter.setVariable("newContainer", (Object)this.dropTarget.getTarget());
        interpreter.setVariable("newViewContainer", (Object)this.dropTarget);
        interpreter.setVariable("element", (Object)droppedElement);
        if (droppedSemanticDecorator != null) {
            interpreter.setVariable("view", (Object)droppedSemanticDecorator);
        }
        RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
        TreeItemContainerDropTool bestDropDescription = null;
        for (TreeItemContainerDropTool dropTool : this.getDropTools(dragSource)) {
            if (!this.checkPrecondition(dropTool, safeInterpreter, droppedElement)) continue;
            if (bestDropDescription == null) {
                bestDropDescription = dropTool;
                continue;
            }
            SiriusPlugin.getDefault().warning("There are more than one drop description that match the dropped element : " + droppedElement + " (" + bestDropDescription.getName() + " and " + dropTool.getName() + ").", (Exception)new RuntimeException());
            break;
        }
        if (oldContainer != null) {
            interpreter.unSetVariable("oldContainer");
        }
        interpreter.unSetVariable("newContainer");
        interpreter.unSetVariable("newViewContainer");
        interpreter.unSetVariable("element");
        if (droppedSemanticDecorator != null) {
            interpreter.unSetVariable("view");
        }
        return Options.newSome((Object)bestDropDescription);
    }

    private boolean checkPrecondition(TreeItemContainerDropTool dropTool, RuntimeLoggerInterpreter safeInterpreter, EObject droppedElement) {
        String precondition = dropTool.getPrecondition();
        if (precondition != null && !StringUtil.isEmpty((String)precondition.trim())) {
            return safeInterpreter.evaluateBoolean(droppedElement, (EObject)dropTool, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition());
        }
        return true;
    }

    private Iterable<TreeItemContainerDropTool> getDropTools(final TreeDragSource dragSource) {
        Predicate<TreeItemContainerDropTool> checkedDragSource = new Predicate<TreeItemContainerDropTool>(){

            public boolean apply(TreeItemContainerDropTool input) {
                return input.getDragSource() == TreeDragSource.BOTH || input.getDragSource() == dragSource;
            }
        };
        ArrayList availableTools = Lists.newArrayList();
        if (this.dropTarget instanceof DTree) {
            availableTools.addAll(((DTree)this.dropTarget).getDescription().getDropTools());
        } else if (this.dropTarget instanceof DTreeItem) {
            availableTools.addAll(((DTreeItem)this.dropTarget).getActualMapping().getDropTools());
        }
        return Iterables.filter((Iterable)availableTools, (Predicate)checkedDragSource);
    }
}

