/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.helper;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.tools.internal.command.RefreshTreeElementCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class RefreshTreeElementTask
extends AbstractCommandTask {
    private EObject uniqueRefreshable;
    private final TransactionalEditingDomain editingDomain;
    private Collection<DTreeElement> refreshablesList;
    private final IProgressMonitor monitor;

    public RefreshTreeElementTask(EObject objectToRefresh, TransactionalEditingDomain editingDomain) {
        this(objectToRefresh, editingDomain, (IProgressMonitor)new NullProgressMonitor());
    }

    public RefreshTreeElementTask(EObject objectToRefresh, TransactionalEditingDomain editingDomain, IProgressMonitor monitor) {
        this.uniqueRefreshable = objectToRefresh;
        this.editingDomain = editingDomain;
        this.monitor = monitor;
    }

    public RefreshTreeElementTask(Collection<DTreeElement> objectsToRefresh, TransactionalEditingDomain editingDomain) {
        this(objectsToRefresh, editingDomain, (IProgressMonitor)new NullProgressMonitor());
    }

    public RefreshTreeElementTask(Collection<DTreeElement> objectsToRefresh, TransactionalEditingDomain editingDomain, IProgressMonitor monitor) {
        this.refreshablesList = objectsToRefresh;
        this.editingDomain = editingDomain;
        this.monitor = monitor;
    }

    public void execute() {
        if (this.uniqueRefreshable instanceof DTree) {
            this.editingDomain.getCommandStack().execute((Command)new RefreshRepresentationsCommand(this.editingDomain, this.monitor, new DRepresentation[]{(DTree)this.uniqueRefreshable}));
        }
        if (this.uniqueRefreshable instanceof DTreeElement) {
            this.editingDomain.getCommandStack().execute((Command)new RefreshTreeElementCommand(this.editingDomain, (DTreeItem)this.uniqueRefreshable, this.monitor));
        }
        if (this.refreshablesList != null) {
            for (DTreeElement obj : this.refreshablesList) {
                if (obj instanceof DTree) {
                    this.editingDomain.getCommandStack().execute((Command)new RefreshRepresentationsCommand(this.editingDomain, this.monitor, new DRepresentation[]{(DTree)((Object)obj)}));
                    continue;
                }
                if (!(obj instanceof DTreeElement)) continue;
                this.editingDomain.getCommandStack().execute((Command)new RefreshTreeElementCommand(this.editingDomain, (DTreeItem)obj, this.monitor));
            }
        }
    }

    public String getLabel() {
        return "Refresh element task";
    }
}

