/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.editor;

import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ecore.extender.business.internal.permission.ReadOnlyWrapperPermissionAuthority;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.tools.api.permission.DRepresentationPermissionStatusListener;
import org.eclipse.sirius.tools.api.permission.DRepresentationPermissionStatusQuery;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditorDialogFactory;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.internal.dialect.TreeEditorDialogFactory;
import org.eclipse.sirius.ui.tools.api.properties.DTablePropertySheetpage;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTableViewerManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditorSessionListenerDelegate;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeViewer;
import org.eclipse.sirius.ui.tools.internal.editor.UndoRedoActionHandler;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public abstract class AbstractDTreeEditor
extends EditorPart
implements ISelectionListener,
DialectEditor,
IViewerProvider,
ITabbedPropertySheetPageContributor,
IEditingDomainProvider,
IReusableEditor,
SessionListener,
ISaveablesSource,
IPageListener {
    private static final ImageDescriptor LOCK_BY_ME_IMAGE_DESCRIPTOR = SiriusEditPlugin.Implementation.getBundledImageDescriptor("icons/full/decorator/permission_granted_to_current_user_exclusively.gif");
    private static final ImageDescriptor LOCK_BY_OTHER_IMAGE_DESCRIPTOR = SiriusEditPlugin.Implementation.getBundledImageDescriptor("icons/full/decorator/permission_denied.gif");
    private static final ImageDescriptor NO_WRITE_PERMISSION_IMAGE_DESCRIPTOR = SiriusEditPlugin.Implementation.getBundledImageDescriptor("icons/full/decorator/permission_no_write.gif");
    protected ComposedAdapterFactory adapterFactory;
    protected ModelAccessor accessor;
    protected AbstractDTableViewerManager treeViewerManager;
    protected Session session;
    protected boolean propertiesUpdateEnabled;
    protected boolean isClosing;
    protected DTablePropertySheetpage currentPropertySheetpage;
    protected ICommandFactory emfCommandFactory = null;
    protected final SessionManagerListener sessionManagerListener = new SessionManagerListener.Stub(){

        public void notifyAddSession(Session newSession) {
            IEditingSession editingSession = SessionUIManager.INSTANCE.getOrCreateUISession(newSession);
            if (!editingSession.isOpen()) {
                editingSession.open();
                editingSession.attachEditor(AbstractDTreeEditor.this);
                SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)this);
            }
        }
    };
    protected DialectEditorDialogFactory myDialogFactory = new TreeEditorDialogFactory(this);
    protected UndoRedoActionHandler undoRedoActionHandler;
    protected Image initialTitleImage;
    protected Image frozenRepresentationImage;
    private IAuthorityListener dRepresentationLockStatusListener;
    private Image lockByMeImage;
    private Image lockByOtherImage;
    private Image noWritePermissionImage;

    public abstract Image getInitialImage();

    protected Image getLockByMeImage() {
        if (this.lockByMeImage == null || this.lockByMeImage.isDisposed()) {
            this.lockByMeImage = SiriusEditPlugin.getPlugin().getImage(LOCK_BY_ME_IMAGE_DESCRIPTOR);
        }
        return this.lockByMeImage;
    }

    protected Image getLockByOtherImage() {
        if (this.lockByOtherImage == null || this.lockByOtherImage.isDisposed()) {
            this.lockByOtherImage = SiriusEditPlugin.getPlugin().getImage(LOCK_BY_OTHER_IMAGE_DESCRIPTOR);
        }
        return this.lockByOtherImage;
    }

    protected Image getNoWritePermissionImage() {
        if (this.noWritePermissionImage == null || this.noWritePermissionImage.isDisposed()) {
            this.noWritePermissionImage = SiriusEditPlugin.getPlugin().getImage(NO_WRITE_PERMISSION_IMAGE_DESCRIPTOR);
        }
        return this.noWritePermissionImage;
    }

    public abstract Image getFrozenRepresentationImage();

    public TransactionalEditingDomain getEditingDomain() {
        return this.session.getTransactionalEditingDomain();
    }

    public IActionBars getActionBars() {
        return ((EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor()).getActionBars();
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        this.session.save(progressMonitor);
    }

    protected boolean isDeleted(IEditorInput editorInput) {
        Resource sessionResource;
        boolean isDeleted = false;
        if (this.getRepresentation() != null && (sessionResource = this.getRepresentation().eResource()) != null) {
            URI sessionResourceURI = sessionResource.getURI();
            boolean sessionResourceExists = sessionResource.getResourceSet().getURIConverter().exists(sessionResourceURI, Collections.emptyMap());
            isDeleted = !sessionResourceExists && new URIQuery(sessionResourceURI).isInMemoryURI() ? false : !sessionResourceExists;
        }
        return isDeleted;
    }

    public abstract void init(IEditorSite var1, IEditorInput var2) throws PartInitException;

    protected void initCollaborativeIPermissionAuthority(DSemanticDecorator representation) {
        ReadOnlyWrapperPermissionAuthority readOnlyWrapperPermissionAuthority;
        IPermissionAuthority wrappedAuthority;
        IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(representation.getTarget());
        this.dRepresentationLockStatusListener = new DRepresentationPermissionStatusListener(representation, (SessionListener)this);
        permissionAuthority.addAuthorityListener(this.dRepresentationLockStatusListener);
        if (!permissionAuthority.canEditInstance((EObject)this.getRepresentation())) {
            this.notify(14);
        } else if (permissionAuthority instanceof ReadOnlyWrapperPermissionAuthority && "CDOLockBasedPermissionAuthority".equals((wrappedAuthority = (readOnlyWrapperPermissionAuthority = (ReadOnlyWrapperPermissionAuthority)permissionAuthority).getWrappedAuthority()).getClass().getSimpleName()) && LockStatus.LOCKED_BY_ME.equals((Object)wrappedAuthority.getLockStatus((EObject)representation))) {
            this.notify(12);
        }
    }

    protected void getSession(DSemanticDecorator rootElement) {
        this.session = SessionManager.INSTANCE.getSession(rootElement.getTarget());
        if (this.session == null) {
            SiriusTransPlugin.getPlugin().error("a DSemanticDecorator must be owned by a Session" + rootElement, null);
        }
    }

    public boolean isDirty() {
        boolean dirty = this.session.getStatus() == SessionStatus.DIRTY;
        return dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        if (this.treeViewerManager != null) {
            AbstractDTreeViewer viewer = this.treeViewerManager.getTreeViewer();
            if (viewer != null && viewer.getTree() != null && viewer.getTree().getTopItem() != null) {
                this.treeViewerManager.getControl().setFocus();
            }
            this.setEclipseWindowTitle();
        }
    }

    protected void setEclipseWindowTitle() {
        String title = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getText();
        int end = title.lastIndexOf(".aird#");
        if (end > -1) {
            title = String.valueOf(title.substring(0, end + 6)) + this.getPartName() + " - Eclipse Platform";
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(title);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.equals(this.getSite().getPage().getActiveEditor())) {
            part.equals(this);
        }
    }

    protected final IEditorDescriptor getEditorDescriptor() {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = editorRegistry.findEditor(this.getSite().getId());
        return editorDesc;
    }

    @Override
    public boolean needsRefresh(int propId) {
        boolean result = false;
        if (propId == 258) {
            if (this.isAutoRefresh()) {
                result = true;
            }
        } else if (propId == 259) {
            result = true;
        }
        return result;
    }

    protected abstract void launchRefresh();

    public Object getAdapter(Class type) {
        Object result = super.getAdapter(type);
        if (result == null) {
            if (type == IPropertySheetPage.class) {
                this.currentPropertySheetpage = new DTablePropertySheetpage(this);
                result = this.currentPropertySheetpage;
            } else if (type == EditingDomain.class) {
                result = this.getEditingDomain();
            }
        }
        return result;
    }

    public void forceRefreshProperties() {
        if (this.currentPropertySheetpage != null && this.currentPropertySheetpage.getControl() != null && !this.currentPropertySheetpage.getControl().isDisposed()) {
            this.currentPropertySheetpage.refresh();
        }
    }

    public Viewer getViewer() {
        AbstractDTreeViewer viewer = null;
        if (this.treeViewerManager != null) {
            viewer = this.treeViewerManager.getTreeViewer();
        }
        return viewer;
    }

    public AbstractDTableViewerManager getTableViewer() {
        return this.treeViewerManager;
    }

    public ModelAccessor getAccessor() {
        return this.accessor;
    }

    public void dispose() {
        if (this.dRepresentationLockStatusListener != null) {
            IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)this.getRepresentation());
            permissionAuthority.removeAuthorityListener(this.dRepresentationLockStatusListener);
        }
        this.isClosing = true;
        SessionManager.INSTANCE.removeSessionsListener(this.sessionManagerListener);
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        if (this.undoRedoActionHandler != null) {
            this.undoRedoActionHandler.dispose();
        }
        if (this.session != null) {
            this.session.removeListener((SessionListener)this);
            IEditingSession sess = SessionUIManager.INSTANCE.getUISession(this.session);
            if (sess != null) {
                sess.detachEditor(this);
            }
        }
        super.dispose();
        if (this.getTableViewer() != null) {
            this.getTableViewer().dispose();
        }
    }

    public void setInput(IEditorInput input) {
        DRepresentation representation;
        super.setInput(input);
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.refresh();
        }
        if ((representation = this.getRepresentation()) instanceof DSemanticDecorator) {
            DSemanticDecorator dSemanticDecorator = (DSemanticDecorator)representation;
            DRepresentationPermissionStatusQuery dRepresentationPermissionStatusQuery = new DRepresentationPermissionStatusQuery(dSemanticDecorator);
            IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)dSemanticDecorator);
            LockStatus lockStatus = LockStatus.NOT_LOCKED;
            LockStatus dSemanticDecoratorLockStatus = permissionAuthority.getLockStatus((EObject)dSemanticDecorator);
            if (dSemanticDecoratorLockStatus != LockStatus.NOT_LOCKED) {
                lockStatus = dSemanticDecoratorLockStatus;
            }
            int associatedSessionListenerEvent = dRepresentationPermissionStatusQuery.getAssociatedSessionListenerEvent(lockStatus);
            this.notify(associatedSessionListenerEvent);
        }
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void enablePropertiesUpdate(boolean enabled) {
        this.propertiesUpdateEnabled = enabled;
    }

    public boolean isPropertiesUpdateEnabled() {
        return this.propertiesUpdateEnabled;
    }

    public void notify(int changeKind) {
        AbstractDTreeEditorSessionListenerDelegate abstractDTreeEditorSessionListenerDelegate = new AbstractDTreeEditorSessionListenerDelegate(this, changeKind);
        if (Display.getCurrent() == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)abstractDTreeEditorSessionListenerDelegate);
        } else {
            abstractDTreeEditorSessionListenerDelegate.run();
        }
    }

    public void setTitleImage(Image titleImage) {
        if (!this.getTitleImage().equals((Object)titleImage)) {
            super.setTitleImage(titleImage);
        }
    }

    protected void firePropertyChangeInUIThread(int notificationKind) {
        if (notificationKind == 1) {
            this.setPartName(this.getRepresentation().getName());
        }
        this.firePropertyChange(notificationKind);
    }

    protected IEditingSession getUISession() {
        return SessionUIManager.INSTANCE.getUISession(this.session);
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    protected boolean isAutoRefresh() {
        boolean autoRefresh = false;
        try {
            autoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), autoRefresh, null);
        }
        catch (IllegalArgumentException e) {
            SiriusTransPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.common.ui", 0, e.getMessage(), (Throwable)e));
        }
        return autoRefresh;
    }

    @Override
    public void setDialogFactory(DialectEditorDialogFactory dialogFactory) {
        this.myDialogFactory = dialogFactory;
    }

    public Saveable[] getSaveables() {
        IEditingSession uiSession;
        if (this.session != null && this.session.isOpen() && (uiSession = this.getUISession()) instanceof ISaveablesSource) {
            return ((ISaveablesSource)uiSession).getSaveables();
        }
        return new Saveable[0];
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public int promptToSaveOnClose() {
        IEditingSession uiSession;
        int choice = 3;
        if (this.session != null && this.session.isOpen() && (uiSession = SessionUIManager.INSTANCE.getUISession(this.session)) != null && uiSession.needToBeSavedOnClose(this)) {
            choice = uiSession.promptToSaveOnClose();
        }
        return choice;
    }

    public void createPartControl(Composite parent) {
        this.setUpUndoRedoActionHandler();
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public void pageActivated(IWorkbenchPage page) {
        this.setUpUndoRedoActionHandler();
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    protected void setUpUndoRedoActionHandler() {
        IWorkbenchPage part;
        IWorkbenchWindow workbenchWindow = this.getEditorSite().getWorkbenchWindow();
        if (workbenchWindow != null && (part = workbenchWindow.getActivePage()) != null) {
            this.undoRedoActionHandler = new UndoRedoActionHandler(this.getEditingDomain(), this.getEditorSite());
        }
        if (this.undoRedoActionHandler == null) {
            this.getEditorSite().getWorkbenchWindow().addPageListener((IPageListener)this);
        }
    }

    protected TreeItem contains(TreeItem[] items, Object element) {
        TreeItem searchedTreeItem = null;
        int i = 0;
        while (i < items.length && searchedTreeItem == null) {
            if (items[i].getData() != null && items[i].getData().equals(element)) {
                searchedTreeItem = items[i];
            }
            if (searchedTreeItem == null) {
                searchedTreeItem = this.contains(items[i].getItems(), element);
            }
            ++i;
        }
        return searchedTreeItem;
    }

    @Override
    public DialectEditorDialogFactory getDialogFactory() {
        return this.myDialogFactory;
    }

    protected void modelerDescriptionFilesLoaded() {
        if (this.isAutoRefresh()) {
            Job refreshJob = new Job("Refresh "){

                protected IStatus run(IProgressMonitor monitor) {
                    AbstractDTreeEditor.this.getEditingDomain().getCommandStack().execute((Command)new RefreshRepresentationsCommand(AbstractDTreeEditor.this.getEditingDomain(), monitor, new DRepresentation[]{AbstractDTreeEditor.this.getRepresentation()}));
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractDTreeEditor.this.getViewer().refresh();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            refreshJob.schedule();
        }
    }
}

