/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.pages;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.common.tools.api.util.WorkspaceUtil;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SessionResourceCreationWizardPage;

public class SessionFileCreationWizardPage
extends SessionResourceCreationWizardPage {
    public SessionFileCreationWizardPage(String pageName, IStructuredSelection selection, String fileExtension) {
        super(pageName, selection, fileExtension);
        this.setTitle("Representations File");
        this.setDescription("Create a new representations file resource");
    }

    @Override
    protected String getNoselectionFileName() {
        return "representations";
    }

    @Override
    protected boolean validatePage() {
        boolean result = true;
        boolean isValidForModelingProject = this.noSecondaryAirdCreationForModelingProject(this.getFilePath());
        if (!isValidForModelingProject) {
            result = false;
            this.setErrorMessage("The selected Modeling Project already has its representations file");
        } else {
            result = super.validatePage();
        }
        return result;
    }

    private boolean noSecondaryAirdCreationForModelingProject(IPath filePath) {
        String[] segments = filePath.segments();
        if (segments != null && segments.length > 1 && "aird".equals(this.getExtension())) {
            String projName = segments[0];
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                List airdInProject;
                IProject p = iProjectArray[n2];
                if (p.getName().equals(projName) && ModelingProject.hasModelingProjectNature((IProject)p) && !(airdInProject = WorkspaceUtil.getFilesFromWorkspace(Collections.singleton(p), (String)"aird")).isEmpty()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }
}

