/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.color;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.tools.api.ui.color.EnvironmentSystemColorFactory;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.description.ColorStep;
import org.eclipse.sirius.viewpoint.description.ComputedColor;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.FixedColor;
import org.eclipse.sirius.viewpoint.description.InterpolatedColor;

public class RGBValuesProvider {
    private Predicate<ColorStep> definedLevelColors = new Predicate<ColorStep>(){

        public boolean apply(ColorStep input) {
            return input.getAssociatedColor() != null && input.getAssociatedValue() != null && !"".equals(input.getAssociatedValue());
        }
    };

    public RGBValues getRGBValues(FixedColor object) {
        RGBValues rgb = ViewpointFactory.eINSTANCE.createRGBValues();
        if (object != null) {
            rgb.setBlue(object.getBlue());
            rgb.setGreen(object.getGreen());
            rgb.setRed(object.getRed());
        }
        return rgb;
    }

    public RGBValues getRGBValues(ComputedColor object, EObject evaluationContext, IInterpreter interpreter) {
        Integer blue;
        Integer green;
        Integer red = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getComputedColor_Red());
        if (red == null) {
            red = 0;
        }
        if ((green = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getComputedColor_Green())) == null) {
            green = 0;
        }
        if ((blue = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getComputedColor_Blue())) == null) {
            blue = 0;
        }
        RGBValues rgb = ViewpointFactory.eINSTANCE.createRGBValues();
        rgb.setBlue(blue);
        rgb.setGreen(green);
        rgb.setRed(red);
        return rgb;
    }

    public RGBValues getRGBValues(InterpolatedColor object, EObject evaluationContext, IInterpreter interpreter) {
        if (object.getColorSteps().isEmpty() || !Iterables.any(object.getColorSteps(), this.definedLevelColors)) {
            return this.getDefaultRGBValues(object, evaluationContext, interpreter);
        }
        return this.getInterpolatedRGBValues(object, evaluationContext, interpreter);
    }

    private RGBValues getInterpolatedRGBValues(InterpolatedColor object, EObject evaluationContext, IInterpreter interpreter) {
        RGBValues rgb = ViewpointFactory.eINSTANCE.createRGBValues();
        rgb.setBlue(0);
        rgb.setGreen(0);
        rgb.setRed(0);
        Integer closestLowerBound = Integer.MIN_VALUE;
        FixedColor closestLowerFixedColor = null;
        Integer minBound = Integer.MAX_VALUE;
        FixedColor minFixedColor = null;
        Integer closestUpperBound = Integer.MAX_VALUE;
        FixedColor closestUpperFixedColor = null;
        Integer maxBound = Integer.MIN_VALUE;
        FixedColor maxFixedColor = null;
        Integer value = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getInterpolatedColor_ColorValueComputationExpression());
        if (value == null) {
            return this.getDefaultRGBValues(object, evaluationContext, interpreter);
        }
        for (ColorStep colorStep : Iterables.filter(object.getColorSteps(), this.definedLevelColors)) {
            Integer associatedValue = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, colorStep, (EStructuralFeature)DescriptionPackage.eINSTANCE.getColorStep_AssociatedValue());
            if (associatedValue != null && associatedValue > closestLowerBound && associatedValue <= value) {
                closestLowerBound = associatedValue;
                closestLowerFixedColor = colorStep.getAssociatedColor();
            }
            if (associatedValue != null && associatedValue < closestUpperBound && associatedValue >= value) {
                closestUpperBound = associatedValue;
                closestUpperFixedColor = colorStep.getAssociatedColor();
            }
            if (associatedValue != null && associatedValue < minBound) {
                minBound = associatedValue;
                minFixedColor = colorStep.getAssociatedColor();
            }
            if (associatedValue == null || associatedValue <= maxBound) continue;
            maxBound = associatedValue;
            maxFixedColor = colorStep.getAssociatedColor();
        }
        if (closestLowerFixedColor == null) {
            closestLowerBound = minBound;
            closestLowerFixedColor = minFixedColor;
        }
        if (closestUpperFixedColor == null) {
            closestUpperBound = maxBound;
            closestUpperFixedColor = maxFixedColor;
        }
        closestLowerBound = closestLowerBound == null ? Integer.valueOf(0) : closestLowerBound;
        Integer n = closestUpperBound = closestUpperBound == null ? Integer.valueOf(1) : closestUpperBound;
        if (closestUpperBound <= closestLowerBound) {
            closestUpperBound = closestLowerBound + 1;
        }
        if (value < closestLowerBound) {
            value = (int)closestLowerBound;
        }
        if (value > closestUpperBound) {
            value = (int)closestUpperBound;
        }
        if (closestUpperBound <= closestLowerBound) {
            closestUpperBound = closestLowerBound + 1;
        }
        if (value > closestUpperBound) {
            value = closestUpperBound;
        }
        if (value < closestLowerBound) {
            value = closestLowerBound;
        }
        float scale = ((float)value.intValue() - (float)closestLowerBound.intValue()) / (float)(closestUpperBound - closestLowerBound);
        int valRed = (int)((float)closestLowerFixedColor.getRed() + (float)(closestUpperFixedColor.getRed() - closestLowerFixedColor.getRed()) * scale);
        int valGreen = (int)((float)closestLowerFixedColor.getGreen() + (float)(closestUpperFixedColor.getGreen() - closestLowerFixedColor.getGreen()) * scale);
        int valBlue = (int)((float)closestLowerFixedColor.getBlue() + (float)(closestUpperFixedColor.getBlue() - closestLowerFixedColor.getBlue()) * scale);
        rgb.setRed(EnvironmentSystemColorFactory.clamp(valRed, 0, 255));
        rgb.setGreen(EnvironmentSystemColorFactory.clamp(valGreen, 0, 255));
        rgb.setBlue(EnvironmentSystemColorFactory.clamp(valBlue, 0, 255));
        return rgb;
    }

    private RGBValues getDefaultRGBValues(InterpolatedColor object, EObject evaluationContext, IInterpreter interpreter) {
        RGBValues rgb = ViewpointFactory.eINSTANCE.createRGBValues();
        rgb.setBlue(0);
        rgb.setGreen(0);
        rgb.setRed(0);
        Integer min = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getInterpolatedColor_MinValueComputationExpression());
        Integer max = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getInterpolatedColor_MaxValueComputationExpression());
        Integer value = RGBValuesProvider.getIntFromAcceleoExpression(interpreter, evaluationContext, object, (EStructuralFeature)DescriptionPackage.eINSTANCE.getInterpolatedColor_ColorValueComputationExpression());
        min = min == null ? Integer.valueOf(0) : min;
        max = max == null ? Integer.valueOf(1) : max;
        Integer n = value = value == null ? min : value;
        if (max <= min) {
            max = min + 1;
        }
        if (value < min) {
            value = (int)min;
        }
        if (value > max) {
            value = (int)max;
        }
        RGBValues red = this.red();
        RGBValues green = this.green();
        if (max <= min) {
            max = min + 1;
        }
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        float scale = ((float)value.intValue() - (float)min.intValue()) / (float)(max - min);
        int valRed = (int)((float)green.getRed() + (float)(red.getRed() - green.getRed()) * scale);
        int valGreen = (int)((float)green.getGreen() + (float)(red.getGreen() - green.getGreen()) * scale);
        int valBlue = (int)((float)green.getBlue() + (float)(red.getBlue() - green.getBlue()) * scale);
        rgb.setRed(EnvironmentSystemColorFactory.clamp(valRed, 0, 255));
        rgb.setGreen(EnvironmentSystemColorFactory.clamp(valGreen, 0, 255));
        rgb.setBlue(EnvironmentSystemColorFactory.clamp(valBlue, 0, 255));
        return rgb;
    }

    private RGBValues red() {
        RGBValues values = ViewpointFactory.eINSTANCE.createRGBValues();
        values.setRed(255);
        values.setBlue(0);
        values.setGreen(0);
        return values;
    }

    private RGBValues green() {
        RGBValues values = ViewpointFactory.eINSTANCE.createRGBValues();
        values.setRed(0);
        values.setBlue(0);
        values.setGreen(255);
        return values;
    }

    private static Integer getIntFromAcceleoExpression(IInterpreter interpreter, EObject context, EObject descriptionObject, EStructuralFeature eFeature) {
        String computationExpression = (String)descriptionObject.eGet(eFeature);
        try {
            return interpreter.evaluateInteger(context, computationExpression);
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error(descriptionObject, eFeature, e);
            return 0;
        }
    }
}

