/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;

public class ReloadingPolicyImpl
implements ReloadingPolicy {
    private final UICallBack callBack;

    public ReloadingPolicyImpl(UICallBack callBack) {
        Preconditions.checkNotNull((Object)callBack);
        this.callBack = callBack;
    }

    @Override
    public List<ReloadingPolicy.Action> getActions(Session session, Resource resource, ResourceSetSync.ResourceStatus newStatus) {
        List<Object> actions = Lists.newArrayList();
        switch (newStatus) {
            case EXTERNAL_CHANGED: {
                actions = this.handleExternalChange(session, resource, newStatus);
                break;
            }
            case DELETED: {
                actions = this.handleExternalDelete(session, resource, newStatus);
                break;
            }
            case CONFLICTING_CHANGED: {
                actions = this.handleExternalChangeConflict(session, resource, newStatus);
                break;
            }
            case CONFLICTING_DELETED: {
                actions = this.handleExternalDeleteConflict(session, resource, newStatus);
                break;
            }
        }
        return actions;
    }

    private List<ReloadingPolicy.Action> handleExternalChangeConflict(Session session, Resource resource, ResourceSetSync.ResourceStatus newStatus) {
        ArrayList actions = Lists.newArrayList();
        if (this.shouldReload(resource)) {
            actions.add(ReloadingPolicy.Action.RELOAD);
        }
        return actions;
    }

    private List<ReloadingPolicy.Action> handleExternalDeleteConflict(Session session, Resource resource, ResourceSetSync.ResourceStatus newStatus) {
        ArrayList actions = Lists.newArrayList();
        if (this.shouldRemove(resource)) {
            actions.add(ReloadingPolicy.Action.REMOVE);
        }
        return actions;
    }

    private List<ReloadingPolicy.Action> handleExternalDelete(Session session, Resource resource, ResourceSetSync.ResourceStatus newStatus) {
        ArrayList actions = Lists.newArrayList();
        if (this.isRepresentationsResourceOwnedBySession(session, resource)) {
            if (this.shouldClose(session, resource)) {
                actions.add(ReloadingPolicy.Action.CLOSE_SESSION);
            }
        } else {
            actions.add(ReloadingPolicy.Action.REMOVE);
        }
        return actions;
    }

    private boolean isRepresentationsResourceOwnedBySession(Session session, Resource resource) {
        boolean isRepresentationsResourceOwnedBySession = session.getAllSessionResources().contains(resource);
        return isRepresentationsResourceOwnedBySession;
    }

    private List<ReloadingPolicy.Action> handleExternalChange(Session session, Resource resource, ResourceSetSync.ResourceStatus newStatus) {
        ArrayList actions = Lists.newArrayList();
        actions.add(ReloadingPolicy.Action.RELOAD);
        return actions;
    }

    private boolean shouldReload(Resource resource) {
        if (this.callBack != null) {
            return this.callBack.shouldReload(resource);
        }
        return true;
    }

    private boolean shouldRemove(Resource resource) {
        if (this.callBack != null) {
            return this.callBack.shouldRemove(resource);
        }
        return true;
    }

    private boolean shouldClose(Session session, Resource resource) {
        if (this.callBack != null) {
            return this.callBack.shouldClose(session, resource);
        }
        return true;
    }
}

