/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.command.semantic;

import com.google.common.collect.Lists;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;

public class RemoveSemanticResourceCommand
extends RecordingCommand {
    protected Session session;
    protected Resource semanticResource;
    protected boolean removeCrossReferencedResources;
    protected boolean removeFromControlledResources;
    private IProgressMonitor monitor;

    public RemoveSemanticResourceCommand(Session session, Resource semanticResource, boolean removeFromControlledResources, IProgressMonitor monitor) {
        super(session.getTransactionalEditingDomain(), "Remove model");
        this.semanticResource = semanticResource;
        this.session = session;
        this.removeFromControlledResources = removeFromControlledResources;
        this.monitor = monitor;
    }

    protected void doExecute() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        if (this.semanticResource != null && this.session != null && this.session.getSemanticResources().contains(this.semanticResource)) {
            this.session.removeSemanticResource(this.semanticResource, this.monitor);
        }
        if (this.removeFromControlledResources && this.session instanceof DAnalysisSessionEObject && ((DAnalysisSessionEObject)((Object)this.session)).getControlledResources().contains((Object)this.semanticResource)) {
            for (EObject root : Lists.newArrayList((Iterable)this.semanticResource.getContents())) {
                EcoreUtil.remove((EObject)root);
            }
            ((DAnalysisSessionEObject)((Object)this.session)).getControlledResources().remove((Object)this.semanticResource);
        }
    }
}

