/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.mwe.resources.BasicWorkspaceResourceLoader;
import org.eclipse.sphinx.emf.mwe.resources.IWorkspaceResourceLoader;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.xtend.typesystem.emf.SphinxManagedEmfMetaModel;
import org.eclipse.sphinx.xtendxpand.XpandEvaluationRequest;
import org.eclipse.sphinx.xtendxpand.jobs.XpandJob;
import org.eclipse.sphinx.xtendxpand.outlet.ExtendedOutlet;
import org.eclipse.sphinx.xtendxpand.preferences.OutletsPreference;
import org.eclipse.sphinx.xtendxpand.preferences.PrDefaultExcludesPreference;
import org.eclipse.sphinx.xtendxpand.preferences.PrExcludesPreference;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.sphinx.xtendxpand.ui.jobs.ResultMessageHandler;
import org.eclipse.sphinx.xtendxpand.ui.wizards.M2TConfigurationWizard;
import org.eclipse.sphinx.xtendxpand.util.XtendXpandUtil;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.xtend.shared.ui.MetamodelContributor;
import org.eclipse.xtend.shared.ui.core.metamodel.MetamodelContributorRegistry;
import org.eclipse.xtend.typesystem.MetaModel;

public class BasicM2TAction
extends BaseSelectionListenerAction {
    public static final String PROJECT_RELATIVE_DEFAULT_OUTLET_PATH = "gen";
    public static final String DEFAULT_TEMPLATE_NAME = "main";
    private IWorkspaceResourceLoader workspaceResourceLoader;

    public BasicM2TAction(String text) {
        super(text);
    }

    protected EObject getSelectedModelObject() {
        Object selected = this.getStructuredSelection().getFirstElement();
        if (selected instanceof EObject) {
            return (EObject)selected;
        }
        Resource resource = EcorePlatformUtil.getResource((Object)selected);
        if (resource != null && !resource.getContents().isEmpty()) {
            return (EObject)resource.getContents().get(0);
        }
        return null;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return selection.size() == 1 && this.getSelectedModelObject() != null;
    }

    public void run() {
        EObject modelObject = this.getSelectedModelObject();
        if (this.getDefinitionName(modelObject) != null) {
            IJobChangeListener handler;
            ExtendedPlatformUI.showSystemConsole();
            XpandJob job = this.createXpandJob();
            job.setPriority(40);
            IFile file = EcorePlatformUtil.getFile((EObject)modelObject);
            if (file != null) {
                job.setRule((ISchedulingRule)file.getProject());
            }
            if ((handler = this.createResultMessageHandler()) != null) {
                job.addJobChangeListener(handler);
            }
            job.schedule();
            return;
        }
        M2TConfigurationWizard wizard = new M2TConfigurationWizard(modelObject, this.getMetaModels());
        wizard.setM2TJobName(this.getM2TJobName());
        wizard.setWorkspaceResourceLoader(this.getWorkspaceResourceLoader());
        wizard.setOutletsPreference(this.getOutletsPreference());
        wizard.setDefaultOutlet(this.getDefaultOutlet());
        wizard.setResultMessageHandler(this.createResultMessageHandler());
        WizardDialog wizardDialog = new WizardDialog(ExtendedPlatformUI.getDisplay().getActiveShell(), (IWizard)wizard);
        wizardDialog.open();
    }

    protected XpandJob createXpandJob() {
        XpandJob job = new XpandJob(this.getM2TJobName(), this.getMetaModels(), this.getXpandEvaluationRequests());
        job.setWorkspaceResourceLoader(this.getWorkspaceResourceLoader());
        job.getOutlets().addAll(this.getOutlets());
        IProject currentProject = EcorePlatformUtil.getFile((EObject)this.getSelectedModelObject()).getProject();
        job.configureProtectedRegionResolver(this.getPrSrcPaths(this.getOutlets()), ((Boolean)PrDefaultExcludesPreference.INSTANCE.get(currentProject)).booleanValue(), (String)PrExcludesPreference.INSTANCE.get(currentProject));
        job.setPriority(40);
        job.setRule((ISchedulingRule)currentProject);
        return job;
    }

    protected String getPrSrcPaths(Collection<ExtendedOutlet> outlets) {
        HashSet<String> paths = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        ArrayList<ExtendedOutlet> allOutlets = new ArrayList<ExtendedOutlet>(outlets);
        for (ExtendedOutlet outlet : allOutlets) {
            if (!outlet.isProtectedRegion()) continue;
            paths.add(outlet.getPath());
        }
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            builder.append((String)iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    protected String getM2TJobName() {
        return Messages.job_generatingCode;
    }

    protected IJobChangeListener createResultMessageHandler() {
        return new ResultMessageHandler();
    }

    protected List<MetaModel> getMetaModels() {
        ArrayList<Object> metaModels = new ArrayList<Object>();
        IFile file = EcorePlatformUtil.getFile((EObject)this.getSelectedModelObject());
        IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
        List contributors = MetamodelContributorRegistry.getActiveMetamodelContributors((IJavaProject)javaProject);
        for (MetamodelContributor contributor : contributors) {
            metaModels.addAll(Arrays.asList(contributor.getMetamodels(javaProject, null)));
        }
        if (metaModels.isEmpty()) {
            IModelDescriptor model = ModelDescriptorRegistry.INSTANCE.getModel(file);
            metaModels.add(new SphinxManagedEmfMetaModel(model));
        }
        return Collections.unmodifiableList(metaModels);
    }

    protected Collection<XpandEvaluationRequest> getXpandEvaluationRequests() {
        EObject selected = this.getSelectedModelObject();
        String definitionName = this.getDefinitionName(selected);
        if (definitionName != null && selected != null) {
            XpandEvaluationRequest request = new XpandEvaluationRequest(definitionName, (Object)selected);
            return Collections.singletonList(request);
        }
        return Collections.emptyList();
    }

    protected String getDefinitionName(EObject modelObject) {
        IFile templateFile = this.getTemplateFile(modelObject);
        if (templateFile != null) {
            return XtendXpandUtil.getQualifiedName((IFile)templateFile, (String)this.getTemplateName());
        }
        return null;
    }

    protected IFile getTemplateFile(EObject modelObject) {
        IFile modelFile = EcorePlatformUtil.getFile((EObject)modelObject);
        if (modelFile != null) {
            IPath templatePath = modelFile.getFullPath().removeFileExtension().addFileExtension("xpt");
            return ResourcesPlugin.getWorkspace().getRoot().getFile(templatePath);
        }
        return null;
    }

    protected String getTemplateName() {
        return DEFAULT_TEMPLATE_NAME;
    }

    protected IWorkspaceResourceLoader getWorkspaceResourceLoader() {
        if (this.workspaceResourceLoader == null) {
            this.workspaceResourceLoader = this.createWorkspaceResourceLoader();
        }
        return this.workspaceResourceLoader;
    }

    protected IWorkspaceResourceLoader createWorkspaceResourceLoader() {
        return new BasicWorkspaceResourceLoader();
    }

    protected OutletsPreference getOutletsPreference() {
        return null;
    }

    protected Collection<ExtendedOutlet> getOutlets() {
        IFile file;
        OutletsPreference outletsPreference = this.getOutletsPreference();
        if (outletsPreference != null && (file = EcorePlatformUtil.getFile((EObject)this.getSelectedModelObject())) != null && file.getProject() != null) {
            return (Collection)outletsPreference.get(file.getProject());
        }
        ExtendedOutlet defaultOutlet = this.getDefaultOutlet();
        if (defaultOutlet != null) {
            return Collections.singletonList(defaultOutlet);
        }
        return Collections.emptyList();
    }

    protected ExtendedOutlet getDefaultOutlet() {
        IFile file = EcorePlatformUtil.getFile((Object)this.getStructuredSelection().getFirstElement());
        if (file != null) {
            IProject project = file.getProject();
            String projectRelativeDefaultOutletPath = this.getProjectRelativeDefaultOutletPath();
            Object defaultOutletContainer = projectRelativeDefaultOutletPath != null && projectRelativeDefaultOutletPath.length() > 0 ? project.getFolder(projectRelativeDefaultOutletPath) : project;
            return new ExtendedOutlet((IContainer)defaultOutletContainer);
        }
        return null;
    }

    protected String getProjectRelativeDefaultOutletPath() {
        return PROJECT_RELATIVE_DEFAULT_OUTLET_PATH;
    }
}

