/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import java.util.ArrayList;
import org.eclipse.draw2d.Graphics;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayerBase;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class StrokedCurveLayer
extends CurveLayerBase {
    public StrokedCurveLayer(DataProvider provider, int curveNr) {
        super(provider, curveNr);
    }

    public StrokedCurveLayer(DataProvider provider, RGB color) {
        super(provider, color);
    }

    public StrokedCurveLayer(DataProvider provider) {
        super(provider);
    }

    public StrokedCurveLayer(CurveLayer wrapped) {
        super(wrapped);
    }

    @Override
    public void draw(Graphics gc, Metrics metrics, Configuration configuration) {
        super.draw(gc, metrics, configuration);
        if (this.getCoords().length > 0) {
            double shrinkFactor;
            gc.pushState();
            gc.setForegroundColor(this.getColor(configuration));
            Point[] points = Coord2D.model2swt(metrics.transposeToCanvas(this.getCoords()));
            int width = (int)Math.ceil(metrics.getPlotRectangle().getSize().getX());
            if (width > 0 && (shrinkFactor = (double)points.length / (double)width) > 4.0) {
                points = this.optimizeForDraw(points, shrinkFactor, width);
            }
            Point prev = points[0];
            int i = 1;
            while (i < points.length) {
                this.drawLine(gc, i - 1, prev, i, points[i]);
                prev = points[i];
                ++i;
            }
            gc.popState();
        }
    }

    protected void drawLine(Graphics gc, int index0, Point point0, int index1, Point point1) {
        gc.drawLine(point0.x, point0.y, point1.x, point1.y);
    }

    private Point[] optimizeForDraw(Point[] points, double factor, int width) {
        ArrayList<Point> result = new ArrayList<Point>();
        result.add(points[0]);
        int i = 1;
        while (i < points.length - 1) {
            if (points[i].x != points[i - 1].x || points[i].x != points[i + 1].x || points[i].y < Math.min(points[i - 1].y, points[i + 1].y) || points[i].y > Math.max(points[i - 1].y, points[i + 1].y)) {
                result.add(points[i]);
            }
            ++i;
        }
        return result.toArray(new Point[result.size()]);
    }
}

