/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.timeline;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DynamicData;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.SelectionProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2DList;

public class EditableDiscreteDataProvider
implements DataProvider,
DynamicData,
SelectionProvider {
    Coord2DList points;
    Set selection = new LinkedHashSet();
    int selectionDirection;

    public EditableDiscreteDataProvider(Coord2D[] points) {
        this.points = new Coord2DList(points);
    }

    @Override
    public Coord2D[] getPoints() {
        if (this.points.isEmpty()) {
            return new Coord2D[]{new Coord2D(0.0, 0.0)};
        }
        Coord2DList result = new Coord2DList();
        double previous = 0.0;
        Iterator iter = this.points.iterator();
        while (iter.hasNext()) {
            Coord2D p = (Coord2D)iter.next();
            result.add(new Coord2D(previous, p.getY()));
            result.add(p);
            previous = p.getX();
        }
        return result.toArray();
    }

    public Coord2D[] getDiscretePoints() {
        return this.points.toArray();
    }

    public boolean isFixed(Coord2D c) {
        return c == this.points.getLast();
    }

    public Coord2D isNearVertical(Coord2D c, double sensivity) {
        Iterator iter = this.points.iterator();
        while (iter.hasNext()) {
            Coord2D p = (Coord2D)iter.next();
            if (!(p.distanceX(c) <= sensivity)) continue;
            return p;
        }
        return null;
    }

    public Coord2D getHorizontal(Coord2D c) {
        double previous = 0.0;
        Iterator iter = this.points.iterator();
        while (iter.hasNext()) {
            Coord2D p = (Coord2D)iter.next();
            if (!(previous <= c.getX()) || !(c.getX() < p.getX())) continue;
            return p;
        }
        return null;
    }

    public Coord2D isNearHorizontal(Coord2D c, double sensivity) {
        Coord2D p = this.getHorizontal(c);
        if (p != null && p.distanceY(c) <= sensivity) {
            return p;
        }
        return null;
    }

    public Coord2D addPointAt(double x) {
        Coord2D p = this.getHorizontal(new Coord2D(x, 0.0));
        if (p != null) {
            Coord2D n = new Coord2D(x, p.getY());
            this.points.addBefore(p, n);
            return n;
        }
        return null;
    }

    public void deletePoint(Coord2D c) {
        this.points.remove(c);
    }

    public void clearSelection() {
        this.selection.clear();
    }

    public void setSelection(Coord2D point) {
        this.selection.clear();
        this.selection.add(point);
    }

    public void addSelection(Coord2D point) {
        this.setSelection(point);
    }

    public boolean isSelection(Coord2D point) {
        return this.selection.contains(point);
    }

    public boolean isSelection(int index) {
        return this.selection.contains(this.points.get(index));
    }

    public boolean isEmptySelection() {
        return this.selection.isEmpty();
    }

    @Override
    public Coord2D[] getSelection() {
        return this.selection.toArray(new Coord2D[this.selection.size()]);
    }

    public int getSelectionDirection() {
        return this.selectionDirection;
    }

    public void setSelectionDirection(int selectionDirection) {
        this.selectionDirection = selectionDirection;
    }

    public Coord2D adjustSelectionConstraints(Coord2D distance, Coord2D snapSize) {
        if (this.selectionDirection == 256) {
            double x = distance.getX();
            if (x > 0.0) {
                int i = 0;
                while (i < this.points.size() - 1) {
                    if (this.isSelection(i)) {
                        x = Math.min(x, this.points.get(i + 1).getX() - this.points.get(i).getX() - snapSize.getX());
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i < this.points.size()) {
                    if (this.isSelection(i)) {
                        x = Math.max(x, this.points.get(i - 1).getX() - this.points.get(i).getX() + snapSize.getX());
                    }
                    ++i;
                }
            }
            return new Coord2D(x, 0.0);
        }
        if (this.selectionDirection == 512) {
            return new Coord2D(0.0, distance.getY());
        }
        return distance;
    }

    public void replacePoints(Coord2D[] oldPoints, Coord2D[] newPoints) {
        int i = 0;
        while (i < oldPoints.length) {
            this.points.replace(oldPoints[i], newPoints[i]);
            ++i;
        }
    }

    public String toString() {
        StringBuffer builder = new StringBuffer("curve: ");
        Iterator itr = this.points.iterator();
        if (itr.hasNext()) {
            builder.append(itr.next());
            while (itr.hasNext()) {
                builder.append(", ").append(itr.next());
            }
        }
        return builder.toString();
    }
}

