/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.datagen;

import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.datagen.RandomDataGeneratorPanel;
import org.eclipse.stardust.ide.simulation.ui.datagen.UniformDistributionDataGenerator;
import org.eclipse.stardust.ide.simulation.ui.datagen.UniformDistributionIntegerGeneratorPanel;
import org.eclipse.swt.widgets.Composite;

public class UniformDistributionIntegerGenerator
extends UniformDistributionDataGenerator {
    public static final String NAME = Simulation_Modeling_Messages.DATA_GENERATOR_UNIFORM_INTEGER;

    public UniformDistributionIntegerGenerator(SimulationInterval interval) {
        super(interval);
        this.options.put("endPoint", Integer.toString(Integer.MAX_VALUE));
    }

    @Override
    public Object getRandom() {
        return new Integer(this.getStartPoint() + this.random.nextInt(this.getRange()));
    }

    @Override
    public Class getResultClass() {
        return Integer.class;
    }

    private int getStartPoint() {
        return Integer.parseInt(this.getOption("startPoint"));
    }

    private int getEndPoint() {
        return Integer.parseInt(this.getOption("endPoint"));
    }

    private int getRange() {
        return this.getEndPoint() - this.getStartPoint();
    }

    @Override
    public RandomDataGeneratorPanel createPanel(Composite parent) {
        return new UniformDistributionIntegerGeneratorPanel(parent, this);
    }
}

