/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.distributions.AbstractSimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.IDistributionConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDouble;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableValue;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessAdapter;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.DistributionUtils;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;

public class CustomDistributionConfiguration
extends AbstractSimulationSubConfiguration
implements IDistributionConfiguration {
    private AdjustableDouble endPoint;
    private List points = new ArrayList();

    public CustomDistributionConfiguration(SimulationInterval interval) {
        super(interval);
        this.endPoint = new AdjustableDouble(this.getFullAttributName("distribution:endPoint"));
    }

    public AdjustableDouble getEndPoint() {
        return this.endPoint;
    }

    public List getPoints() {
        return this.points;
    }

    public void setPoints(TimestampValue[] points) {
        this.points = points != null ? new ArrayList<TimestampValue>(Arrays.asList(points)) : new ArrayList();
    }

    @Override
    public void read(AttributeAccessAdapter attributes) {
        try {
            this.endPoint.read(attributes);
            this.points = TimestampValue.stringToList(attributes.getAttibute(this.getFullAttributName("distribution:points"), DistributionUtils.getDefaultFor(this.getFullAttributName("distribution:points"))));
        }
        catch (Exception e) {
            this.setNull();
            this.reportConfigurationReadingError(Simulation_Modeling_Messages.ERROR_READING_CONFIGURATION, e);
        }
    }

    @Override
    public void write(AttributeAccessAdapter attributes) {
        this.endPoint.write(attributes);
        attributes.setAttibute(this.getFullAttributName("distribution:points"), TimestampValue.listToString(this.points));
    }

    @Override
    public String getDistributionTypeId() {
        return "1004";
    }

    @Override
    public AdjustableValue[] getBoundValues() {
        return new AdjustableValue[]{this.endPoint};
    }

    protected String getFullAttributName(String attributName) {
        return DistributionUtils.getFullAttributName(this.getDistributionTypeId(), attributName);
    }

    @Override
    public boolean isComplete() {
        return !this.isNull();
    }
}

