/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.Point;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;

public class CurveMerger {
    private SortedMap mergedPoints = new TreeMap();
    private long baseLength;
    private int curveCount = 0;

    public CurveMerger(List mainCurve, long xLength) {
        this.baseLength = xLength;
        this.addCurve(mainCurve, xLength);
    }

    private void addCurve(List points, long xLength) {
        TimestampValue lastPoint = (TimestampValue)(points = new ArrayList<TimestampValue>(points)).get(points.size() - 1);
        if (lastPoint.getTime() < xLength) {
            TimestampValue newPoint = new TimestampValue(xLength, lastPoint.getValue());
            points.add(newPoint);
        }
        if (xLength > this.baseLength) {
            throw new RuntimeException("Multipliers that are longer than baselength are not supported (" + xLength + ">" + this.baseLength + ")");
        }
        if (xLength < this.baseLength) {
            points = this.extendToBaseLength(points, xLength);
        }
        for (TimestampValue coord : points) {
            Point point = new Point(coord.getTime(), coord.getValue(), this.curveCount);
            this.addPoint(point);
        }
        ++this.curveCount;
    }

    private List extendToBaseLength(List points, long xLength) {
        LinkedList<TimestampValue> result = new LinkedList<TimestampValue>();
        TimestampValue pointToCopy;
        long newX;
        while ((newX = (pointToCopy = (TimestampValue)points.get(result.size() % points.size())).getTime() + (long)result.size() / (long)points.size() * xLength) < this.baseLength) {
            TimestampValue point = new TimestampValue(newX, pointToCopy.getValue());
            result.add(point);
        }
        return result;
    }

    public void addMultiplier(List points, long xLength) {
        this.addCurve(points, xLength);
    }

    private void addPoint(Point point) {
        Long key = new Long(point.getX());
        if (this.mergedPoints.containsKey(key)) {
            List l = (List)this.mergedPoints.get(key);
            l.add(point);
        } else {
            LinkedList<Point> l = new LinkedList<Point>();
            l.add(point);
            this.mergedPoints.put(key, l);
        }
    }

    public List merge() {
        List<TimestampValue> result = new LinkedList();
        LinkedList lastPoints = new LinkedList();
        for (Map.Entry e : this.mergedPoints.entrySet()) {
            Long x = (Long)e.getKey();
            List l = (List)e.getValue();
            TimestampValue mergedPoint = this.mergeOne(lastPoints, x, l);
            result.add(mergedPoint);
        }
        result = this.normalize(result);
        return result;
    }

    private TimestampValue mergeOne(List lastPoints, long x, List currentPoints) {
        HashMap<Integer, Point> mergedPoints = new HashMap<Integer, Point>();
        for (Point point : lastPoints) {
            mergedPoints.put(new Integer(point.getCurveId()), point);
        }
        for (Point point : currentPoints) {
            mergedPoints.put(new Integer(point.getCurveId()), point);
        }
        lastPoints.clear();
        lastPoints.addAll(mergedPoints.values());
        double y = 1.0;
        for (Point point : mergedPoints.values()) {
            y *= point.getY();
        }
        return new TimestampValue(x, y);
    }

    public List add() {
        List<TimestampValue> result = new LinkedList();
        LinkedList lastPoints = new LinkedList();
        for (Map.Entry e : this.mergedPoints.entrySet()) {
            Long x = (Long)e.getKey();
            List l = (List)e.getValue();
            TimestampValue mergedPoint = this.addOne(lastPoints, x, l);
            result.add(mergedPoint);
        }
        result = this.normalize(result);
        return result;
    }

    private TimestampValue addOne(List lastPoints, long x, List currentPoints) {
        HashMap<Integer, Point> mergedPoints = new HashMap<Integer, Point>();
        for (Point point : lastPoints) {
            mergedPoints.put(new Integer(point.getCurveId()), point);
        }
        for (Point point : currentPoints) {
            mergedPoints.put(new Integer(point.getCurveId()), point);
        }
        lastPoints.clear();
        lastPoints.addAll(mergedPoints.values());
        double y = 0.0;
        for (Point point : mergedPoints.values()) {
            y += point.getY();
        }
        return new TimestampValue(x, y);
    }

    private List normalize(List points) {
        TimestampValue lastPoint = null;
        LinkedList<TimestampValue> result = new LinkedList<TimestampValue>();
        for (TimestampValue point : points) {
            if (lastPoint == null) {
                result.add(point);
                lastPoint = point;
                continue;
            }
            if (lastPoint.getValue() == point.getValue()) continue;
            result.add(point);
            lastPoint = point;
        }
        return result;
    }

    private String getAsCsv(List points) {
        StringBuffer sb = new StringBuffer();
        for (TimestampValue point : points) {
            sb.append(String.valueOf(point.getTime()) + "," + point.getValue() + "\n");
        }
        return sb.toString();
    }
}

