/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.platform.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.osgi.framework.Bundle;

public class ExtensionsResolver {
    private static Map<IConfigurationElement, Contributor> contributors = new ConcurrentHashMap<IConfigurationElement, Contributor>();

    public static boolean isMatchingClass(Object element, String classAttributeName, IConfigurationElement template) throws ClassNotFoundException {
        Bundle bundle;
        Contributor pageContributor = contributors.get(template);
        String pageContributorEnabled = template.getAttribute("pageContributor");
        if (pageContributor == null && pageContributorEnabled == null) {
            pageContributor = new Contributor(template);
            contributors.put(template, pageContributor);
        }
        if (pageContributor != null && !pageContributor.isApplicableTo(element, classAttributeName)) {
            return false;
        }
        String objectClass = template.getAttribute(classAttributeName);
        if (StringUtils.isEmpty((String)objectClass)) {
            return true;
        }
        Class targetClass = null;
        String bundleId = null;
        if (template.getContributor() != null) {
            bundleId = template.getContributor().getName();
        }
        if (bundleId != null && (bundle = Platform.getBundle((String)bundleId)) != null && bundle.getState() == 32) {
            targetClass = bundle.loadClass(objectClass);
        }
        if (targetClass == null) {
            targetClass = Class.forName(objectClass);
        }
        return targetClass.isInstance(element);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMatchingElement(EObject element, String classAttributeName, Map<String, String> filterValues, IConfigurationElement template) {
        try {
            if (!ExtensionsResolver.isMatchingClass(element, classAttributeName, template)) return false;
            IConfigurationElement[] filters = template.getChildren("filter");
            for (Map.Entry<String, String> entry : filterValues.entrySet()) {
                if (SpiExtensionRegistry.matchFilter((IConfigurationElement[])filters, (String)entry.getKey(), (String)entry.getValue())) continue;
                return false;
            }
            int j = 0;
            while (j < filters.length) {
                boolean notOperator = false;
                String name = filters[j].getAttribute("name");
                String value = filters[j].getAttribute("value");
                if (name.startsWith("!")) {
                    notOperator = true;
                    name = name.substring(1);
                }
                if ("metaType".equals(name)) {
                    if (!(element instanceof ITypedElement)) {
                        return false;
                    }
                    IMetaType metaType = ((ITypedElement)element).getMetaType();
                    if (!SpiExtensionRegistry.matchFilterValue((boolean)notOperator, (String)(metaType == null ? null : metaType.getId()), (String)value)) {
                        return false;
                    }
                }
                if (name.startsWith("feature:")) {
                    String featureName = name.substring("feature:".length());
                    Object featureValue = SpiExtensionRegistry.getFeatureValue((EObject)element, (String)featureName);
                    if (featureValue == null) {
                        return false;
                    }
                    if (!SpiExtensionRegistry.matchFilterValue((boolean)notOperator, (String)(featureValue == null ? null : featureValue.toString()), (String)value)) {
                        return false;
                    }
                }
                ++j;
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return false;
    }

    private ExtensionsResolver() {
    }

    private static class Contributor {
        private static final String CHILD_ENABLED_WHEN = "enabledWhen";
        private Expression enablementExpression;

        public Contributor(IConfigurationElement template) {
            this.initializeEnablement(template);
        }

        public boolean isApplicableTo(Object element, String classAttributeName) {
            if (this.enablementExpression == null) {
                return true;
            }
            try {
                EvaluationContext context = new EvaluationContext(null, element);
                context.setAllowPluginActivation(true);
                return this.enablementExpression.evaluate((IEvaluationContext)context).equals(EvaluationResult.TRUE);
            }
            catch (CoreException coreException) {
                return false;
            }
        }

        private void initializeEnablement(IConfigurationElement template) {
            IConfigurationElement[] elements = template.getChildren(CHILD_ENABLED_WHEN);
            if (elements.length == 0) {
                return;
            }
            try {
                IConfigurationElement[] enablement = elements[0].getChildren();
                if (enablement.length == 0) {
                    return;
                }
                this.enablementExpression = ExpressionConverter.getDefault().perform(enablement[0]);
            }
            catch (CoreException coreException) {}
        }
    }
}

