/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.platform.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.spi.IResourceResolver;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;

public class WorkspaceResourceResolver
implements IResourceResolver {
    public String resolveToLocalUri(String uri, EObject context) {
        String localUri;
        block5: {
            localUri = null;
            try {
                IProject project = WorkspaceUtils.getProjectFromEObject(context);
                if (project != null) {
                    localUri = this.getFileUrl(project, uri);
                    break block5;
                }
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    IProject proj = projects[i];
                    String fileUri = this.getFileUrl(proj, uri);
                    if (!StringUtils.isEmpty((String)fileUri)) {
                        localUri = fileUri;
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {}
        }
        return localUri;
    }

    public long getLastModificationTime(String uri, EObject context) {
        if (uri.toLowerCase().startsWith("http://")) {
            return 0L;
        }
        IProject project = WorkspaceUtils.getProjectFromEObject(context);
        String filePath = "/";
        String[] parts = uri.split("/");
        if (parts.length > 2) {
            int i = 2;
            while (i < parts.length) {
                filePath = String.valueOf(filePath) + parts[i];
                if (i < parts.length - 1) {
                    filePath = String.valueOf(filePath) + "/";
                }
                ++i;
            }
            IFile file = project.getFile(filePath);
            if (file.exists()) {
                return file.getModificationStamp();
            }
        }
        return 0L;
    }

    private String getFileUrl(IProject project, String url) {
        String fileUri;
        block4: {
            fileUri = null;
            try {
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) break block4;
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IFolder folder;
                    IFile file;
                    IResource resource = roots[i].getCorrespondingResource();
                    if (resource instanceof IFolder && (file = (folder = (IFolder)resource).getFile(url)).exists()) {
                        fileUri = file.toString().substring(1);
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return fileUri;
    }
}

