/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface.widgets;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class SelectionPopup {
    private SelectionListener listener;
    private Menu menu;
    protected Object popupSelection = null;
    private IContentProvider contentProvider = null;
    private ILabelProvider labelProvider = null;
    private Object input = null;

    public SelectionPopup(Shell parent) {
        this.menu = new Menu((Control)parent);
        this.listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.widget;
                SelectionPopup.this.popupSelection = item.getData();
            }
        };
    }

    public void setLocation(int x, int y) {
        this.menu.setLocation(x, y);
    }

    public void setContentProvider(IContentProvider cp) {
        this.contentProvider = cp;
    }

    public void setLabelProvider(ILabelProvider lp) {
        this.labelProvider = lp;
    }

    public void setInput(Object i) {
        this.input = i;
    }

    public Object open() {
        if (this.input != null && this.contentProvider instanceof IStructuredContentProvider) {
            Object[] elements = ((IStructuredContentProvider)this.contentProvider).getElements(this.input);
            int i = 0;
            while (i < elements.length) {
                MenuItem mi = new MenuItem(this.menu, 0);
                Object entry = elements[i];
                Image img = this.labelProvider.getImage(entry);
                String txt = this.labelProvider.getText(entry);
                mi.setText(txt == null ? String.valueOf(entry) : txt);
                if (img != null) {
                    mi.setImage(img);
                }
                mi.setData(entry);
                mi.addSelectionListener(this.listener);
                ++i;
            }
            this.menu.setVisible(true);
            while (!this.menu.isDisposed() && this.menu.isVisible()) {
                if (Display.getCurrent().readAndDispatch()) continue;
                Display.getCurrent().sleep();
            }
            return this.popupSelection;
        }
        return null;
    }
}

