/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.swt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class MetadataManager {
    private Class type;
    private Constructor defaultConstructor;
    private String[] propertyNames;
    private Method[] getters;
    private Method[] setters;
    private DateFormat dateFormat;

    public MetadataManager(Class type, String[] columnProperties) {
        this.type = type;
        try {
            this.defaultConstructor = type.getConstructor(null);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        this.propertyNames = columnProperties;
        this.getters = new Method[columnProperties.length];
        this.setters = new Method[columnProperties.length];
        int n = 0;
        while (n < columnProperties.length) {
            try {
                this.getters[n] = type.getMethod(MetadataManager.getGetterMethodName(columnProperties[n]), null);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            ++n;
        }
        n = 0;
        while (n < columnProperties.length) {
            try {
                Class<?> returnType = this.getters[n].getReturnType();
                this.setters[n] = type.getMethod(MetadataManager.getSetterMethodName(columnProperties[n]), returnType);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            ++n;
        }
        this.dateFormat = DateFormat.getDateInstance(3);
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Object createObject() {
        if (this.defaultConstructor == null) {
            throw new UnsupportedOperationException("No default constructor for class " + this.type.getName() + ".");
        }
        try {
            return this.defaultConstructor.newInstance(null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPropertyFromString(Object object, int index, String value) {
        block7: {
            try {
                if (this.getters[index].getReturnType() == Date.class) {
                    try {
                        this.setters[index].invoke(object, this.dateFormat.parse(value));
                        break block7;
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.setters[index].invoke(object, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("Illegal argument \"" + value + "\" for property \"" + this.propertyNames[index] + "\".");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getStringifiedValue(Object object, int index) {
        Object value;
        block6: {
            value = this.getters[index].invoke(object, null);
            if (value != null) break block6;
            return null;
        }
        try {
            if (this.getters[index].getReturnType() == Date.class) {
                return this.dateFormat.format((Date)value);
            }
            return (String)value;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Class getType(int index) {
        return this.getters[index].getReturnType();
    }

    public static String getGetterMethodName(String property) {
        String suffix = String.valueOf(property.substring(0, 1).toUpperCase()) + property.substring(1);
        return "get" + suffix;
    }

    public static String getSetterMethodName(String property) {
        String suffix = String.valueOf(property.substring(0, 1).toUpperCase()) + property.substring(1);
        return "set" + suffix;
    }
}

