/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.api.model.Modules;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.common.BpmCommonActivator;
import org.eclipse.stardust.modeling.common.ui.IWorkflowModelEditor;
import org.eclipse.stardust.modeling.common.ui.UI_Messages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;

public class BpmUiActivator
extends Plugin {
    private static final Logger trace = LogManager.getLogger(BpmUiActivator.class);
    public static final String PLUGIN_ID = "org.eclipse.stardust.modeling.common.ui";
    private static BpmUiActivator plugin;
    private String moduleError;
    private final IPerspectiveListener perspectiveListener = new PerspectiveAdapter(){

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            this.updateVisuals(page, perspective);
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            this.updateVisuals(page, perspective);
        }

        private void updateVisuals(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            IPreferenceStore store = PlatformUI.getPreferenceStore();
            if (!"ag.carnot.workflow.modeler.debuggingPerspective".equals(perspective.getId())) {
                store.setValue("org.eclipse.stardust.modeling.core.analystView", "ag.carnot.workflow.modeler.businessModelingPerspective".equals(perspective.getId()));
            }
            BpmUiActivator.this.updateEditors(page);
        }
    };

    public BpmUiActivator() {
        plugin = this;
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.autoValidation", true);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.autoIdGeneration", true);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.autoSubprocessNameGeneration", true);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.alwaysSwitchActivityType", false);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.neverSwitchActivityType", false);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType", true);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.modelingDirection", "Vertical");
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.classicMode", true);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.viewForkOnTraversalMode", false);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.snapGridMode", true);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.snapGridPixel", 5);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.visibleGridFactor", 4);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnatureoneSymbol", false);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnatureallSymbols", false);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnatureprompt", true);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnaturehtmlReportFormat", false);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnaturepdfReportFormat", false);
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnaturepromptReportFormat", true);
        FlowControlType[] flowControlTypeArray = FlowControlType.values();
        int n = flowControlTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FlowControlType flow = flowControlTypeArray[n2];
            if (flow != FlowControlType.NONE_LITERAL) {
                PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature" + flow.getLiteral() + "Prompt", true);
                JoinSplitType[] joinSplitTypeArray = JoinSplitType.values();
                int n3 = joinSplitTypeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    JoinSplitType type = joinSplitTypeArray[n4];
                    if (type != JoinSplitType.NONE_LITERAL) {
                        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature" + flow.getLiteral() + type.getLiteral(), false);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnaturedeployId", "motu");
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnaturedeployPassword", "motu");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.synchronizeTraceFile();
        try {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                windows[i].addPerspectiveListener(this.perspectiveListener);
                ++i;
            }
        }
        catch (IllegalStateException e) {
            trace.warn((Object)e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            windows[i].removePerspectiveListener(this.perspectiveListener);
            ++i;
        }
        plugin = null;
        super.stop(context);
    }

    public static BpmUiActivator getDefault() {
        return plugin;
    }

    public void setAnalystMode(IWorkbenchPage page, boolean analystMode) {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.setValue("org.eclipse.stardust.model.xpdl.diagram.analystView", analystMode);
        this.updateEditors(page);
    }

    private void updateEditors(IWorkbenchPage page) {
        IEditorReference[] editors = page.getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IEditorPart part = editors[i].getEditor(false);
            if (part instanceof IWorkflowModelEditor) {
                try {
                    ((IWorkflowModelEditor)part).updateEditor(page);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ++i;
        }
    }

    public String getTraceFilePath() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        return store.getString("org.eclipse.stardust.model.xpdl.license.path");
    }

    public void setTraceFilePath(String path) {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.setValue("org.eclipse.stardust.model.xpdl.license.path", path);
        BpmCommonActivator.getDefault().resetExtensions(path);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IEditorReference[] editors = pages[j].getEditorReferences();
                int k = 0;
                while (k < editors.length) {
                    IEditorPart part = editors[k].getEditor(false);
                    if (part instanceof IWorkflowModelEditor) {
                        IWorkflowModelEditor cwmEditor = (IWorkflowModelEditor)part;
                        if (cwmEditor.getWorkflowModel() == null) {
                            try {
                                cwmEditor.updateModel(cwmEditor.getEditorInput());
                            }
                            catch (Exception exception) {}
                        }
                        try {
                            cwmEditor.updateEditor(pages[j]);
                        }
                        catch (Exception exception) {}
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public String initializeExtensions(Modules module) {
        this.moduleError = null;
        this.synchronizeTraceFile();
        Exception e = BpmCommonActivator.getDefault().initializeExtensions(module);
        if (e != null) {
            this.moduleError = Parameters.instance().getString("License." + module + ".product") == null ? MessageFormat.format(UI_Messages.BpmUiActivator_noLicenseIsPresent, module) : e.getMessage();
        }
        return this.moduleError;
    }

    private void synchronizeTraceFile() {
        String path = this.getTraceFilePath();
        if (path != null && path.length() > 0 && !path.equals(Parameters.instance().getString(String.valueOf(new char[]{'L', 'i', 'c', 'e', 'n', 's', 'e', '.', 'L', 'i', 'c', 'e', 'n', 's', 'e', 'F', 'i', 'l', 'e', 'P', 'a', 't', 'h'})))) {
            BpmCommonActivator.getDefault().resetExtensions(path);
        }
    }

    public String getString(String name) {
        return Parameters.instance().getString(name);
    }

    public String getString(String name, String defaultValue) {
        return Parameters.instance().getString(name, defaultValue);
    }

    public String getModuleError() {
        return this.moduleError;
    }

    public static String i18n(FlowControlType flow) {
        switch (flow) {
            case JOIN_LITERAL: {
                return UI_Messages.LB_Join;
            }
            case SPLIT_LITERAL: {
                return UI_Messages.LB_Split;
            }
            case NONE_LITERAL: {
                return UI_Messages.LB_None;
            }
        }
        return null;
    }

    public static String i18n(JoinSplitType type) {
        switch (type) {
            case AND_LITERAL: {
                return UI_Messages.LB_AND;
            }
            case XOR_LITERAL: {
                return UI_Messages.LB_XOR;
            }
            case OR_LITERAL: {
                return UI_Messages.LB_OR;
            }
            case NONE_LITERAL: {
                return UI_Messages.LB_None;
            }
        }
        return null;
    }

    public static IWorkflowModelEditor findWorkflowModelEditor(ModelType model) {
        IEditorPart currentEditor;
        IWorkbenchPage activePage;
        if (model == null) {
            return null;
        }
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null && (currentEditor = activePage.getActiveEditor()) != null && currentEditor instanceof IWorkflowModelEditor && (model == null || ((IWorkflowModelEditor)currentEditor).getWorkflowModel() == model)) {
            return (IWorkflowModelEditor)currentEditor;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IEditorReference[] references = pages[j].getEditorReferences();
                int k = 0;
                while (k < references.length) {
                    IEditorPart editor = references[k].getEditor(false);
                    if (editor instanceof IWorkflowModelEditor && ((IWorkflowModelEditor)editor).getWorkflowModel() == model) {
                        return (IWorkflowModelEditor)editor;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

