/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.createUtils.CreateModelElementUtil;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.ConnectionUtils;
import org.eclipse.stardust.modeling.core.editors.cap.StoreObject;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.ActivitySymbolNodeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.utils.SnapGridUtils;
import org.eclipse.ui.PlatformUI;

public class CreateSubprocess {
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private static Object inConnection_ = null;
    private static Object outConnection_ = null;
    private List transitionList;
    private List connectionList;
    private WorkflowModelEditor editor;
    private ModelType model;
    private ProcessDefinitionType process;
    private DiagramType diagram;
    private PoolSymbol pool;
    private LaneSymbol laneSymbol = null;
    private ActivityType activity;
    private ActivitySymbolType symbol;
    private StoreObject storage;

    public CreateSubprocess(List selection, StoreObject storage, WorkflowModelEditor editor) {
        this.model = this.getModelFromSelection(selection);
        this.storage = storage;
        this.editor = editor;
        this.getInOutConnections(selection);
    }

    private void getInOutConnections(List selection) {
        ArrayList<ActivitySymbolType> activitySymbols = new ArrayList<ActivitySymbolType>();
        int i = 0;
        while (i < selection.size()) {
            Object element = selection.get(i);
            Object modelElement = null;
            if (element instanceof INodeSymbol) {
                modelElement = element;
            } else if (element instanceof AbstractNodeSymbolEditPart) {
                modelElement = ((AbstractEditPart)element).getModel();
            }
            if (modelElement instanceof ActivitySymbolType) {
                activitySymbols.add((ActivitySymbolType)modelElement);
            }
            ++i;
        }
        inConnection_ = null;
        outConnection_ = null;
        CreateSubprocess.isValidActivityNetwork(activitySymbols);
        this.transitionList = new ArrayList();
        this.connectionList = new ArrayList();
        if (inConnection_ != null && inConnection_ instanceof TransitionConnectionType) {
            this.connectionList.add(inConnection_);
            if (((TransitionConnectionType)inConnection_).getTransition() != null) {
                this.transitionList.add(((TransitionConnectionType)inConnection_).getTransition());
            }
        }
        if (outConnection_ != null && outConnection_ instanceof TransitionConnectionType) {
            this.connectionList.add(outConnection_);
            if (((TransitionConnectionType)outConnection_).getTransition() != null) {
                this.transitionList.add(((TransitionConnectionType)outConnection_).getTransition());
            }
        }
    }

    public void updateStorage() {
        this.storage.setTargetDiagram(this.diagram);
        this.storage.setTargetProcess(this.process);
        this.storage.setTargetModel(this.model);
        this.storage.setSameModel(true);
        this.storage.setTargetObject((EObject)this.pool);
    }

    public void createElements() {
        this.createSubProcess();
        this.createActivity();
    }

    private void createSubProcess() {
        IdFactory idFactory = new IdFactory(Diagram_Messages.ID_ProcessDefinition, Diagram_Messages.BASENAME_ProcessDefinition);
        EClass eClass = PKG.getProcessDefinitionType();
        ModelType container = this.model;
        this.process = (ProcessDefinitionType)CreateModelElementUtil.createModelElement(idFactory, eClass, (EObject)container, this.model);
        CreateModelElementUtil.addModelElement(CreateModelElementUtil.getContainingFeature(eClass, (EObject)container), (IModelElement)this.process, (EObject)container);
        this.createDiagram(this.process);
    }

    private void createDiagram(ProcessDefinitionType process) {
        EClass eClass = PKG.getDiagramType();
        ProcessDefinitionType container = process;
        this.diagram = (DiagramType)CreateModelElementUtil.createModelElement(null, eClass, (EObject)container, this.model);
        this.diagram.setName(Diagram_Messages.DIAGRAM_NAME_Diagram);
        this.diagram.setOrientation(OrientationType.VERTICAL_LITERAL.toString().equals(PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.modelingDirection")) ? OrientationType.VERTICAL_LITERAL : OrientationType.HORIZONTAL_LITERAL);
        DiagramModeType defaultMode = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.classicMode") ? DiagramModeType.MODE_400_LITERAL : DiagramModeType.MODE_450_LITERAL;
        this.diagram.setMode(defaultMode);
        this.pool = DiagramUtil.createDefaultPool(null);
        this.diagram.getPoolSymbols().add((Object)this.pool);
        CreateModelElementUtil.addModelElement(CreateModelElementUtil.getContainingFeature(eClass, (EObject)container), (IModelElement)this.diagram, (EObject)container);
    }

    private void createActivity() {
        IdFactory idFactory = new IdFactory(Diagram_Messages.ID_Activity, ActivityImplementationType.SUBPROCESS_LITERAL + Diagram_Messages.BASENAME_Activity);
        EClass eClass = PKG.getActivityType();
        ProcessDefinitionType container = this.storage.getSourceProcess();
        this.activity = (ActivityType)CreateModelElementUtil.createModelElement(idFactory, eClass, (EObject)container, this.model);
        this.activity.setImplementation(ActivityImplementationType.SUBPROCESS_LITERAL);
        this.activity.setSubProcessMode(SubProcessModeType.SYNC_SHARED_LITERAL);
        this.activity.eSet((EStructuralFeature)PKG.getActivityType_ImplementationProcess(), (Object)this.process);
        this.activity.eSet((EStructuralFeature)PKG.getIIdentifiableElement_Name(), (Object)this.process.getName());
        CreateModelElementUtil.addModelElement(CreateModelElementUtil.getContainingFeature(eClass, (EObject)container), (IModelElement)this.activity, (EObject)container);
        this.createActivitySymbol(this.activity);
    }

    private void createActivitySymbol(ActivityType activity) {
        EClass eClass = PKG.getActivitySymbolType();
        PoolSymbol container = DiagramUtil.getDefaultPool((DiagramType)this.storage.getSourceDiagram());
        if (this.laneSymbol != null) {
            container = this.laneSymbol;
        }
        DiagramType targetDiagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)container));
        AbstractGraphicalEditPart host = (AbstractGraphicalEditPart)this.editor.findEditPart(targetDiagram);
        this.symbol = (ActivitySymbolType)CreateModelElementUtil.createModelElement(null, eClass, (EObject)container, this.model);
        this.symbol.setActivity(activity);
        CreateModelElementUtil.addSymbol((ISymbolContainer)container, (IGraphicalObject)this.symbol, this.model);
        Point location = this.storage.getLocation();
        ActivitySymbolNodeEditPart editPart = (ActivitySymbolNodeEditPart)this.editor.findEditPart(this.symbol);
        Dimension prefSize = editPart.getFigure().getPreferredSize();
        Dimension size = SnapGridUtils.getSnapDimension(prefSize, host, 2, true);
        this.symbol.setHeight(size.height);
        this.symbol.setWidth(size.width);
        this.symbol.setXPos((long)location.x);
        this.symbol.setYPos((long)location.y);
        editPart.refresh();
    }

    private ModelType getModelFromSelection(List selection) {
        Object modelElement = selection.get(0);
        if (modelElement instanceof AbstractNodeSymbolEditPart || modelElement instanceof DiagramEditPart) {
            modelElement = ((AbstractEditPart)modelElement).getModel();
        }
        return ModelUtils.findContainingModel((EObject)((EObject)modelElement));
    }

    public void setLaneSymbol(LaneSymbol laneSymbol) {
        this.laneSymbol = laneSymbol;
    }

    public void reconnectConnections() {
        TransitionType transition;
        if (inConnection_ != null && inConnection_ instanceof TransitionConnectionType) {
            ((TransitionConnectionType)inConnection_).setTargetNode((INodeSymbol)this.symbol);
            transition = ((TransitionConnectionType)inConnection_).getTransition();
            if (transition != null) {
                transition.setTo(this.activity);
            }
        }
        if (outConnection_ != null && outConnection_ instanceof TransitionConnectionType) {
            ((TransitionConnectionType)outConnection_).setSourceNode((INodeSymbol)this.symbol);
            transition = ((TransitionConnectionType)outConnection_).getTransition();
            if (transition != null) {
                transition.setFrom(this.activity);
            }
        }
    }

    public void deleteSymbols(List symbols) {
        for (INodeSymbol symbol : symbols) {
            ConnectionUtils.deleteConnectionsFromSymbol(symbol, this.connectionList);
            MergeUtils.deleteElement((EObject)symbol, null);
        }
    }

    public void deleteElements(List modelSymbols) {
        for (IModelElementNodeSymbol symbol : modelSymbols) {
            IIdentifiableModelElement modelElement = symbol.getModelElement();
            EList symbols = modelElement.getSymbols();
            this.deleteSymbols((List)symbols);
            if (modelElement == null) continue;
            this.deleteElement((IModelElement)modelElement);
        }
    }

    public void deleteElement(IModelElement element) {
        if (element instanceof ActivityType) {
            ConnectionUtils.deleteTransitions((ActivityType)element, this.transitionList);
        }
        MergeUtils.deleteElement((EObject)element, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidActivityNetwork(List activitySymbols) {
        Object inConnection = null;
        Object outConnection = null;
        if (activitySymbols.isEmpty()) {
            return false;
        }
        HashMap<ActivityType, ActivitySymbolType> activityToSymbol = new HashMap<ActivityType, ActivitySymbolType>();
        ArrayList<ActivityType> activities = new ArrayList<ActivityType>();
        for (ActivitySymbolType activitySymbol : activitySymbols) {
            ActivityType activity = activitySymbol.getActivity();
            activityToSymbol.put(activity, activitySymbol);
            activities.add(activity);
        }
        TransitionType networkInTransition = null;
        TransitionType networkOutTransition = null;
        ActivityType startActivity = null;
        ActivityType endActivity = null;
        Iterator iter = activities.iterator();
        while (iter.hasNext()) {
            boolean hasOutTransitionIntoNetwork = false;
            boolean hasInTransitionIntoNetwork = false;
            boolean mustHaveOutTransitionIntoNetwork = false;
            boolean mustHaveInTransitionIntoNetwork = false;
            ActivityType activity = (ActivityType)iter.next();
            if (activity == null) {
                return false;
            }
            EList inTransitions = activity.getInTransitions();
            if (!inTransitions.isEmpty()) {
                if (inTransitions.size() == 1) {
                    TransitionType transition = (TransitionType)inTransitions.get(0);
                    ActivityType fromActivity = transition.getFrom();
                    if (!activities.contains(fromActivity)) {
                        if (networkInTransition != null) return false;
                        startActivity = activity;
                        networkInTransition = transition;
                        mustHaveOutTransitionIntoNetwork = true;
                    } else {
                        hasInTransitionIntoNetwork = true;
                    }
                } else {
                    hasInTransitionIntoNetwork = true;
                    for (TransitionType transition : inTransitions) {
                        ActivityType fromActivity = transition.getFrom();
                        if (activities.contains(fromActivity)) continue;
                        return false;
                    }
                }
            } else {
                startActivity = activity;
                mustHaveOutTransitionIntoNetwork = true;
            }
            EList outTransitions = activity.getOutTransitions();
            if (!outTransitions.isEmpty()) {
                if (outTransitions.size() == 1) {
                    TransitionType transition;
                    transition = (TransitionType)outTransitions.get(0);
                    ActivityType toActivity = transition.getTo();
                    if (!activities.contains(toActivity)) {
                        if (networkOutTransition != null) return false;
                        endActivity = activity;
                        networkOutTransition = transition;
                        mustHaveInTransitionIntoNetwork = true;
                    } else {
                        hasOutTransitionIntoNetwork = true;
                    }
                } else {
                    hasOutTransitionIntoNetwork = true;
                    for (TransitionType transition : outTransitions) {
                        ActivityType toActivity = transition.getTo();
                        if (activities.contains(toActivity)) continue;
                        return false;
                    }
                }
            } else {
                endActivity = activity;
                mustHaveInTransitionIntoNetwork = true;
            }
            if (activities.size() <= 1) continue;
            if (mustHaveInTransitionIntoNetwork && !hasInTransitionIntoNetwork) {
                return false;
            }
            if (!mustHaveOutTransitionIntoNetwork || hasOutTransitionIntoNetwork) continue;
            return false;
        }
        if (startActivity != null && (inConnection = ConnectionUtils.getInConnectionFromSymbol((INodeSymbol)activityToSymbol.get(startActivity), networkInTransition)) != null) {
            if (inConnection instanceof Boolean) {
                return false;
            }
            inConnection_ = inConnection;
        }
        if (endActivity == null || (outConnection = ConnectionUtils.getOutConnectionFromSymbol((INodeSymbol)activityToSymbol.get(endActivity), networkOutTransition)) == null) return true;
        if (outConnection instanceof Boolean) {
            return false;
        }
        outConnection_ = outConnection;
        return true;
    }
}

