/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.swt.graphics.Image;

public class ForkOnTraversalDecoration
extends ImageFigure
implements RotatableDecoration {
    private Point location = new Point();
    private Transform transform = new Transform();

    public ForkOnTraversalDecoration() {
        Image image = DiagramPlugin.getImage("icons/full/obj16/forkOnTraversal.gif");
        this.setImage(image);
        this.setSize(this.getPreferredSize());
    }

    public void setLocation(Point p) {
        this.location.setLocation(p);
        this.transform.setTranslation((double)p.x, (double)p.y);
        this.applyRotation();
    }

    public void setReferencePoint(Point ref) {
        Point pt = Point.SINGLETON;
        pt.setLocation(ref);
        pt.negate().translate(this.location);
        this.transform.setRotation(Math.atan2(pt.y, pt.x));
        this.applyRotation();
    }

    private void applyRotation() {
        Dimension size = this.getSize().getNegated();
        Point centerDislocation = new Point(size.width / 2, 0);
        Point center = this.transform.getTransformed(centerDislocation);
        super.setLocation(center.translate(size.width / 2, size.height / 2));
    }
}

